/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	kprintf;
include	error;
include	hardware;
include	_startup;
include	object;
include	debugger;
include	vmemory;
include	arena;
include	pc_hdw;
include	process;

KernelArena:	public	kernelArena;

kernelArena:	public	type	inherit	arena	{
	public:
	myDebugger:		ref far debugger;
	threadPtr:		vaddr_t;

generalProtectionFault:	dynamic	(ref interruptFrame_t) =
	{
	}

dumpHex:	dynamic	(p: vaddr_t, len: vaddr_t) =
	{
	dumpData(pointer(p), len);
	}

recoverSendParameters:	dynamic	(a: ref task_t) =
	{
	xp:		ref byte;
	gf:	ref i386gateFrame;

	memSet(a, 0, sizeof *a);
/*
	xp = &CurProc->kernelStack[|CurProc->kernelStack];
	gf = ref i386gateFrame(xp) - 1;
	a->eip = gf->eip;
	a->cs = gf->cs;
	a->esp = gf->esp;
 */
	a->eflags = DEFAULT_FLAGS;
	}

grow:	dynamic	(newSize: vaddr_t) boolean =
	{
	p:	unsigned;
	page1:	paddr_t;
	page2:	paddr_t;
	ap:	* paddr_t;

	page1 = getPageOffset(paddr_t(_brklvl) - 1) + KERNEL_CODE_SPACE >> 12;
	page2 = getPageOffset(paddr_t(newSize) - 1) + KERNEL_CODE_SPACE >> 12;
	if	(page1 == page2)
		return TRUE;
	ap = getPageTable(KERNEL_VIRTUAL_ADDRESS);
	if	(_brklvl > pointer(newSize)){	// A shrink of the heap
		while	(page1 > page2){
			FreePages put(ap[page1]);
			ap[page1] = 0;
			page1--;
			}
		}
	else	{				// a grow of the heap
		if	(page2 - page1 > FreePages.pageCount)
			return FALSE;
		do	{
			page1++;
			ap[page1] = FreePages get() | 1;
			}
			while	(page1 < page2);
		}
	return TRUE;
	}

_free:	dynamic	() =
	{
	super _free();
	}

obtainWrite:	dynamic	(buf: vaddr_t, len: vaddr_t) pointer =
	{
	return pointer(buf);
	}

unlock:	dynamic	() =
	{
	}

write:	dynamic	(offs: vaddr_t, src: pointer, len: vaddr_t) int =
	{
	memCopy(pointer(offs), src, len);
	return SUCCESS;
	}

read:	dynamic	(offs: vaddr_t, dest: pointer, len: vaddr_t) int =
	{
	memCopy(dest, pointer(offs), len);
	return SUCCESS;
	}
/*
	This function tests whether the kernel can legitimately call the 
	named code address.  The address is relative to the code segment.
 */
canCall:	dynamic	(addr: vaddr_t) boolean =
	{
	return addr < CSsize;
	}
/*
	This function tests whether the kernel can legitimately read
	the named data buffer in the arena.  The address is relative to
	the data segment.
 */
canRead:	dynamic	(addr: vaddr_t, len: vaddr_t) boolean =
	{
	return TRUE;
	}
/*
	This function tests whether the kernel can legitimately write to
	the named data buffer in the arena.  The address is relative to
	the data segment.
 */
canWrite:	dynamic	(addr: vaddr_t, len: vaddr_t) boolean =
	{
	return TRUE;
	}

	};

startup:	entry	() =
	{
	CurArena = &KernelArena;

		// Map a temporary grow vector, to finish boot

	P_grow = &localGrow;
	}

localGrow:	(brk: pointer) boolean =
	{
	return KernelArena grow(vaddr_t(brk));
	}
