/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
include	process;
include	alys;
include	node;
include	runload;
include	environ;
include	filesys;
include	alysfs;
include	backbone;
include	kprintf;
include	syscall;
include	dos_vol;
include	pc_video;
include	pc_hdisk;
include	pc_fdisk;
include	pc_keybd;
include	pc_comm;
include	arena;
include	object, message;
include	consfile;
include	console;
include	window;
include	video;
/*
	This is the ALYS/386 boot sequence.  The ALYS message passing
	kernel has been initialized by this point, so what needs to be
	done now is to bring up the higher-level functions of the system.

	The context at this point is as follows:

		Object 0 - the 'boot' object
		Object 1 - the AlysNode object
		Object 2 = the SystemENvironment object

		Process 0 - animates object 0

		Arena 0 - the kernel arena, an empty LDT
 */
boot:	entry	() =
	{
	CurProc->where = CurArena;
	AlysNode.kernelVersion = 0x100;
	kprintf("ALYS Version %d.%02d  Copyright (c) 1992 Robert Jervis    "
						__DATE__ " " __TIME__ "\n\n", 
						AlysNode.kernelVersion >> 8,
						AlysNode.kernelVersion & 0xff);

		// Load the disk partition tables

	makeFileContext0();
	pcFloppyDiskInitialization();
	pcHardDiskInitialization();
	mountDOSVolumes();
	Root createDevice("con", &ConsoleFile, 
				FA_DEVICE|FA_READ|FA_WRITE|FA_CONTROL);
	defineHotKey(CTRL_CENTER, &cycleWindows);
	defineHotKey(SYSREQ, &systemRequest);
	defineHotKey(ALT_F1, &systemRequest2);
	defineHotKey(CTRL_F1, &systemRequest3);
	defineHotKey(SHFT_F1, &systemRequest4);

	SystemEnvironment jobPublish("SystemEnvironment");
	BootContext makeLocal(SystemEnvironment.objectId, Environment);
	startComm();
	Screen showMouse(TRUE);
	SerialPorts[1] setMouse(&ConsoleObject);
	loadEnvironment();
	RunLoader register();

	sbuf:	[MAXPATH] char;
	shell:	[:] char;
	shell = sbuf;
	try
		shell [:]= Environment get("BOOTCOM");
	except
		kprintf("No BOOTCOM environment string\n");
	try
		Host spawn(shell, "-boot");
	except
		kprintf("Couldn't find '%S'\n", shell);

		// Sleep waiting for something to happen

	KernelDebugger = [ 0 ];

	myWindow:	ref PC_textWindow;
	myWindowId:	ref far PC_textWindow;

	myWindow = new PC_textWindow[ [ 80, 25 ], &ConsoleObject ];
	myWindowId = ref far PC_textWindow(
				jobPublishKernel("kernelConsoleWindow", 
							myWindow, AR_ANY));
	myWindowId zoom([ 0, 0 ], WZ_NORMAL);

	ch:	ref PC_consoleChannel;

	ch = new PC_consoleChannel[ myWindowId ];
	KernelConsole = ref far channel(jobPublishKernel("kconChannel", ch, AR_ANY));

	for	(;;){
		buf:	[100] char;
		s:	[:] char;
		i:	int;

//		KernelDebugger down(FALSE);
		KernelConsole write("kernel-: ");
		s = buf;
		s [:]= KernelConsole read();
		if	(|s &&
			 s[|s-1] == '\n')
			(|s)--;
		if	(stringCompare(s, "o") == 0){
			displayObjects();
			}
		else if	(stringCompare(s, "p") == 0){
			displayProcesses();
			}
		else
			help();
		}
	}

KernelDebugger:	semaphore;
KernelConsole:	ref far channel;

systemRequest:	(keystroke) =
	{
//	KernelDebugger up();
	displayProcesses();
	}

systemRequest2:	(keystroke) =
	{
	displayObjects();
	}

systemRequest3:	(keystroke) =
	{
	displayMessages();
	}

systemRequest4:	(keystroke) =
	{
//
	}

SystemEnvironment:	public	environment;

EOF_MARK:	const	char = 26;		// make ^Z an EOF

loadEnvironment:	() =
	{
	fd:		ref far channel;
	len:		int;
	buf:		[:] byte;
	cp:		* char;

		/* Open the file */

	fd = FileSystem open("/c/alys.env", AR_READ);
	if	(fd == 0){
		kprintf("Couldn't open '/c/alys.env'\n");
		return;
		}
	len = fd seek(0, 2);
	fd seek(0, 0);
	buf = new [len + 1] byte;
//	buf = ref byte(alloc(len + 1))[:len + 1];
	buf [:]= fd read();
	fd close();
	if	(|buf != len)
		return;			// something funny in the read
	buf[len] = EOF_MARK;		// force an EOF mark
	cp = ref char(buf);
	for	(;;){
		name:	[:] char;
		value:	[:] char;
		n:	ref char;

		while	(isspace(*cp))
			cp++;
		if	(*cp == EOF_MARK)
			break;
		if	(*cp == '/'){
			do
				cp++;
				while	(*cp != EOF_MARK &&
					 *cp != '\n');
			continue;
			}
		n = cp;
		while	(!isspace(*cp) &&
			 *cp != '\r' &&
			 *cp != '=' &&
			 *cp != EOF_MARK)
			cp++;
		name = n[:cp - n];
		while	(*cp == ' ' || *cp == '\t')
			cp++;
		if	(*cp != '='){
			while	(*cp != EOF_MARK &&
				 *cp != '\n')
				cp++;
			continue;
			}
		cp++;
		while	(*cp == ' ' || *cp == '\t')
			cp++;
		n = cp;
		while	(*cp != EOF_MARK &&
			 *cp != '\n' &&
			 *cp != '\r')
			cp++;
		value = n[:cp - n];
		Environment define(name, value);
		while	(*cp != EOF_MARK &&
			 *cp != '\n')
			cp++;
		}
	free(buf);
	}

help:	() = {
	KernelConsole write(
		"o	Display object table\n"
		"p	Display process table\n"
		);
	}
