/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
include	file;
include	runfile;
include	error;

loadMap:	public	(map: [:] char) =
	{
	mapFd:	stream;
	i:	int;
	buf:	[100] char;

	i = mapFd open(map, AR_READ);
	if	(i){
		printf("Couldn't open map file '%S': %S\n", map, cmdError(i));
		exit(1);
		}
	for	(;;){
		i = mapFd gets(buf);
		if	(i == 0)
			break;
		if	(stringCompare(buf[:i], "Code\n") == 0)
			break;
		}
	for	(;;){
		i = mapFd gets(buf);
		if	(i == 0)
			break;
		if	(stringCompare(buf[:i], "Data\n") == 0)
			break;
		if	(buf[0] == '\n')
			continue;

		cp:	ref char;

		cp = buf;
		while	(*cp && *cp != ':')
			cp++;
		if	(*cp == 0)
			continue;
		cp++;
		while	(*cp == ' ')
			cp++;
		if	(*cp == 0)
			continue;
		hex:	unsigned;
		digit:	int;

		hex = 0;
		while	(*cp && *cp != ' '){
			if	(isdigit(*cp))
				digit = *cp - '0';
			else
				digit = tolower(*cp) - 'a' + 10;
			hex = hex << 4 + digit;
			cp++;
			}
		while	(*cp == ' ')
			cp++;
		if	(*cp == 0)
			continue;
		name:	ref char;

		name = cp;
		while	(*cp && *cp != '\n')
			cp++;
		DataSymbols = symbol create(hex, name[:cp - name]);
		}
	CodeSymbols = DataSymbols;
	DataSymbols = 0;
	for	(;;){
		i = mapFd gets(buf);
		if	(i == 0)
			break;
		if	(stringCompare(buf[:i], 
				"  Address         Publics by Name\n") == 0)
			break;
		if	(buf[0] == '\n')
			continue;

		cp:	ref char;
		j:	int;

		j = 0;
		while	(buf[j] && buf[j] != ':')
			j++;
		if	(buf[j] == 0)
			continue;
		j++;
		while	(buf[j] == ' ')
			j++;
		if	(buf[j] == 0)
			continue;
		hex:	unsigned;
		digit:	int;

		hex = 0;
		while	(buf[j] &&
			 buf[j] != ' ' &&
			 buf[j] != '+'){
			if	(isdigit(buf[j]))
				digit = buf[j] - '0';
			else
				digit = tolower(buf[j]) - 'a' + 10;
			hex = hex << 4 + digit;
			j++;
			}
		while	(buf[j] == ' ' ||
			 buf[j] == '+')
			j++;
		if	(buf[j] == 0)
			continue;
		name:	int;

		name = j;
		while	(buf[j] && buf[j] != '\n')
			j++;
		DataSymbols = symbol create(hex, (buf + name)[:j - name]);
		}
	mapFd close();
	}

DataSymbols:	public	* symbol;
CodeSymbols:	public	* symbol;
Start:		public	* symbol;
Code:		public	* byte;
RunHeader:	public	* runHeader;

symbol:	public	type	{
	next:	public	* symbol;
	name:		[:] char;

	public:

	address:	size_t;

create:	factory	(a: size_t, n: [:] char) ref symbol =
	{
	self = new symbol[ DataSymbols ];
	address = a;
	name = new [|n] char;
	name [:]= n;
	return self;
	}

findName:	(cp: [:] char) ref symbol =
	{
	while	(self){
		if	(namesMatch(cp, name))
			return self;
		self = next;
		}
	return 0;
	}

findSymbol:	(a: unsigned) ref symbol =
	{
	save:	ref symbol;

	save = self;
	while	(self){
		if	(a >= address){
			if	(save == CodeSymbols &&
				 Start->address >= address &&
				 a >= Start->address)
				return Start;
			else
				return self;
			}
		self = next;
		}
	if	(save == CodeSymbols &&
		 a >= Start->address)
		return Start;
	else
		return 0;
	}

display:	(adjust: unsigned) =
	{
	printf("%S(@%x)", name, address);
	if	(adjust != address)
		printf("+%x", adjust - address);
	}

hasFullStackFrame:	() boolean =
	{
	code:	* byte;

	code = Code + address;
	for	(;;){
		switch	(*code){
		case	0x50:			// push eax
		case	0x51:			// push ecx
		case	0x52:			// push edx
		case	0x53:			// push ebx
		case	0x56:			// push esi
		case	0x57:			// push edi
			break;

		case	0x55:			// push EBP
		case	0xC8:			// enter
			return TRUE;
			
		default:
			return FALSE;
			}
		code++;
		}
	}

locateReturnAddress:	(ebp: unsigned, esp: unsigned) unsigned =
	{
	code:	* byte;

	code = Code + address;
	for	(;;){
		switch	(*code){
		case	0x50:			// push eax
		case	0x51:			// push ecx
		case	0x52:			// push edx
		case	0x53:			// push ebx
		case	0x56:			// push esi
		case	0x57:			// push edi
			ebp += 4;
			esp += 4;
			break;

		case	0x55:			// push EBP
		case	0xC8:			// enter
			return ebp + 4;
			
		default:
			return esp;
			}
		code++;
		}
	}
};

namesMatch:	(key: [:] char, fullName: [:] char) boolean =
	{
	i:		int;
	j:		int;


		// If the key has a unit, match it, otherwise ignore
		// the unit of the fullName

	i = stringSubstring(key, "::");
	j = stringSubstring(fullName, "::");
	if	(i >= 0){
		if	(j != i)
			return FALSE;
		if	(memCompare(key, fullName, i) != 0)
			return FALSE;
		key = key[i + 2:];
		fullName = fullName[i + 2:];
		}
	else if	(j >= 0)
		fullName = fullName[j + 2:];

		// If the search key has no dot, try to match on the last id

	i = stringScan(key, '.');
	if	(i < 0){
		j = stringReverseScan(fullName, '.');
		if	(j >= 0)
			fullName = fullName[j + 1:];
		}
	if	(stringCompare(key, fullName) != 0)
		return FALSE;
	else
		return TRUE;
	}

loadRun:	public	(run: [:] char) =
	{
	runFd:	stream;
	i:	int;
	len:	long;

	i = runFd open(run, AR_READ);
	if	(i){
		printf("Could not open '%S': %S\n", run, cmdError(i));
		exit(1);
		}
	len = runFd seek(0, SEEK_END);
	runFd seek(0, SEEK_ABS);
	Code = alloc(len);
	i = runFd read(Code[:len]);
	if	(i != len){
		printf("Could not read '%S'\n", run);
		exit(1);
		}
	RunHeader = ref runHeader(Code);
	Code += sizeof runHeader;
	Code -= RunHeader->codeOffset;
	if	(RunHeader->magic != RUN_MAGIC ||
		 (RunHeader->version != RUN_VERSION &&
		  RunHeader->version != RUN_VERSION_2)){
		printf("Improper core file '%S'\n", run);
		exit(1);
		}
	Start = symbol create(RunHeader->ip, "machine::__start__");
	}
