#include "stdio.h"
#include "mem.h"

unsigned char bitVals[]={1,2,4,8,16,32,64,128,0};

int toBits(unsigned char *source,char *dbits,int bits)
{
   int bit;
   int bitStart;
   int bitLoop;

   memset(dbits,'\0',(bits));
   for ( int loop=0 ; loop<(bits*8) ; loop++ )
   {
      bitStart=loop*8;
      for ( bitLoop=0,bit=bitVals[bitLoop] ; bitLoop<8 ; bitLoop++,bit=bitVals[bitLoop] )
      {
	 if ( (source[loop]&bit) )
         {
            dbits[bitStart+bitLoop]=1;
         }
      }
   }
}

int fromBits(unsigned char *source,unsigned char *dest,int bits)
{
   int bit;
   int bitStart;
   int bitLoop;
   int byte=0;

   memset(dest,'\0',(bits/8));
   for ( int loop=0 ; loop<(bits/8) ; loop++ )
   {
      bitStart=byte*8;
      dest[byte]=0;
      for ( bitLoop=0 ; bitLoop<8 ; bitLoop++ )
      {
         if ( (source[(loop*8)+bitLoop]) )
         {
            dest[byte]|=(bitVals[bitLoop]);
         }
      }
      byte++;
   }
}

int main(int argc,char *argv[])
{
   float t=8.88;
   double dest=0.0;
   char stuff[20];
   static char test[]={0xFF,0xAA};
   char bitFlags[80];
   char destBits[80];
   int loop;
   toBits((unsigned char *)&t,bitFlags,32);
  // sign...
   destBits[23]=bitFlags[31];
  // exponent
   for ( loop=23 ; loop<=30 ; loop++ )
   {
       destBits[loop+1]=bitFlags[loop];
   }
  // mantissa
   for ( loop=0 ; loop<=22 ; loop++ )
   {
       destBits[loop]=bitFlags[loop];
   }
   fromBits(destBits,stuff,32);
   printf("\nstuff=%02.2x%02.2x%02.2x%02.2x",stuff[0],stuff[1],stuff[2],stuff[3]);

}
