#include "stdio.h"
#include "stdlib.h"
#include "string.h"

extern "C" {
   char *my_malloc(int num,char *pfile,int line);
   int  my_free(char *,char *pfile,int line);
};

#include "ddffile.h"
#define EOS '\0'
int loadFields(int currentFileID,struct FIELDDDF *fields[]);
char *btrvConvert(int type,char *src,char *dst,int slen,int sdec,
                                                int dlen,int ddec);
char *pNameFromLName(char *lname,struct FILEDDF& fileDDF);
Value::Value(int l,int d)
{
   strValue=0;
   dValue=0.0;
   iValue=0L;
   len=l;
   dec=d;
}

Value::Value(char *s,int l,int d)
{
   strValue=my_malloc(l+2,__FILE__,__LINE__);
   strcpy(strValue,s);
   dValue=(atof(s));
   iValue=(atol(s));
   len=l;
   dec=d;
}
Value::Value(double t,int l,int d)
{
   strValue=my_malloc(l+2,__FILE__,__LINE__);
   sprintf(strValue,"%*.*f",l,dec,t);
   dValue=t;
   iValue=(long)t;
   len=l;
   dec=d;
}
Value::Value(long i,int l)
{
   strValue=my_malloc(l+2,__FILE__,__LINE__);
   sprintf(strValue,"%*ld",l,i);
   dValue=(double)i;
   iValue=i;
   len=l;
   dec=0;
}

void Value::setLenDec(int l,int d)
{
   if ( strValue!=0 )
   {
      my_free(strValue,__FILE__,__LINE__);
      strValue=0;
   }
   strValue=my_malloc(l+2,__FILE__,__LINE__);
   len=l;
   dec=d;
}

void Value::clear()
{
   if ( strValue!=0 )
   {
      sprintf(strValue,"%*s",len," ");
   }
   dValue=0.0;
   iValue=0;
}
void Value::setVal(char *s)
{
   if ( strValue==0 )
   {
      strValue=my_malloc(len+2,__FILE__,__LINE__);
   }
   strcpy(strValue,s);
   dValue=(atof(s));
   iValue=(atol(s));
}
void Value::setVal(double t)
{
   if ( strValue==0 )
   {
      strValue=my_malloc(len+2,__FILE__,__LINE__);
   }
   sprintf(strValue,"%*.*f",len,dec,t);
   dValue=t;
   iValue=(long)t;
}
void Value::setVal(long i)
{
   if ( strValue==0 )
   {
      strValue=my_malloc(len+2,__FILE__,__LINE__);
   }
   sprintf(strValue,"%*ld",len,i);
   dValue=(double)i;
   iValue=i;
}

ddfFile::ddfFile(char *lname,char *owner)
{
   strcpy(physicalName,pNameFromLName(lname,fileDDF));
   strcpy(logicalName,lname);
  // create the raw btrieve file object.
   theFile=new bfile(physicalName,0,owner);
   if ( theFile !=0 && theFile->get_status()==BERR_NONE )
   {
     // get fields from the FIELD.DDF file
      numFields=loadFields(fileDDF.fileID,fields);
   }
   else
   {
      numFields=0;
      fields[0]=0;
   }
}
ddfFile::~ddfFile()
{
   int loop;
   delete theFile;
   for ( loop=0 ; fields[loop]!=0 ; loop++ )
   {
      delete fields[loop];
   }
}


// given a field name, get the ID (an index into the fields[] array)
int ddfFile::getFieldID(char *name)
{
   int loop;
   for ( loop=0 ; fields[loop]!=0 && name!=0 ; loop++ )
   {
      if ( !(memicmp(name,fields[loop]->fieldName,(strlen(name)))) )
      {
         return(loop);
      }
   }
   return(255);
}

// the reverse of getFieldID()
char *ddfFile::getFieldName(int i)
{
   if ( i<numFields )
   {
      return(fields[i]->fieldName);
   }
   return(fields[255]->fieldName);
}

// given a field name, get the string value of the field.
char *ddfFile::getValue(char *fname)
{
   return((char *)fields[getFieldID(fname)]->value);
}

// given a field ID (and index into the fields[] array) return a string value.
char *ddfFile::getValue(int fnum)
{
   return((char *)fields[fnum]->value);
}

int ddfFile::get_rec(char far *keystr,int op)
{
   theFile->get_rec(keystr,op);
   dataToFields();
   return(theFile->get_status());
}

int ddfFile::put_rec(char far *keystr,unsigned tlen,int just_update)
{
   fieldsToData();
   return(theFile->put_rec(keystr,tlen,just_update));
}
int ddfFile::insert(char far *keystr,unsigned tlen)
{
   fieldsToData();
   return(theFile->insert(keystr,tlen));
}

int ddfFile::fieldsToData()
{
   int loop;
   for ( loop=0 ; loop<numFields ; loop++ )
   {
      if ( (stricmp(fields[loop]->fieldName,"N/A")) )
      {
         btrvConvert(fields[loop]->btDataType+100,(char *)fields[loop]->value,
                   theFile->get_data()+fields[loop]->offset,
                   fields[loop]->value.getLen(),fields[loop]->value.getDec(),
                   fields[loop]->fieldSize,fields[loop]->decimals);
      }
   }
   return(loop);
}

int ddfFile::dataToFields()
{
   int loop;
   char temp[255];
   for ( loop=0 ; loop<numFields ; loop++ )
   {
      memset(temp,EOS,255);
      if ( (stricmp(fields[loop]->fieldName,"N/A")) )
      {
         btrvConvert(fields[loop]->btDataType,
                   theFile->get_data()+fields[loop]->offset,temp,
                   fields[loop]->fieldSize,fields[loop]->decimals,
                   fields[loop]->value.getLen(),fields[loop]->value.getDec());
         fields[loop]->value.setVal(temp);
      }
   }
   return(loop);
}

// use this to return a record buffer to a known starting state.
void ddfFile::nullOut()
{
   int loop;
   for ( loop=0 ; loop<numFields ; loop++ )
   {
      fields[loop]->value.clear();
   }
   return;
}

// get the field information, and pack it into the raw data buffer.
void ddfFile::toData(int fnum,void *t)
{
      if ( fnum<255 )
      {
         btrvConvert(fields[fnum]->btDataType+100,(char *)fields[fnum]->value,
                   (char *)t,
                   fields[fnum]->value.getLen(),fields[fnum]->value.getDec(),
                   fields[fnum]->fieldSize,fields[fnum]->decimals);
      }
}

// the next two functions get and goto "bookmarks", allowing you to
//    "save your place" in a file.
int ddfFile::getBookmark(struct BOOKMARK *theMark)
{
   theMark->key=theFile->get_key_num();
   theFile->get_pos(theMark->pos);
   return(theFile->get_status());
}

int ddfFile::gotoBookmark(struct BOOKMARK *theMark)
{
   theFile->set_key_num(theMark->key);
   theFile->set_pos(theMark->pos);
   dataToFields();
   return(theFile->get_status());
}

