#include "realcnvt.h"

/*  converts IEEE 8-byte real to basic 4-byte real  */

void doubletobassngl(bassngl *New, double Old) {
  char    Sign;
  int     Exp;
  int     X;
  unsigned char *NewNum, *OldNum;

  NewNum = (char *) New;
  OldNum = (char *) &Old;

  Sign = OldNum[7] & 0x80;
  Exp  = ((OldNum[7] & 0x7F) << 4) + (OldNum[6] >> 4);
  if (Exp)
    Exp += 0x81 - 0x3FF;

  for (X = 2; X >= 0; X--) {
    NewNum[X] = OldNum[X+4] << 4;
    NewNum[X] |= OldNum[X+3] >> 4;
  }

  for (X = 0; X < 2; X++) {
    NewNum[X] >>= 1;
    NewNum[X] |= NewNum[X+1] << 7;
  }
  NewNum[2] >>= 1;

  NewNum[2] |=  Sign;
  NewNum[3] =   Exp;
}
