/*

      bfile.h
      Btrieve class for Borland C++
      09/06/91

      Douglas J. Reilly
      Access Microsystems Inc.
      404 Midstreams Road
      Brick, New Jersey  08724
      (908) 892-2683
      CompuServe 74040,607

      Comments?  Questions?  Suggestions?
      Have a paying C/C++ programming job you need done?
      Give me a call.

      Released into the public domain.  Do with it as you see fit, but
      if you do anything really neat with it, let me know...

10/15/91  DR  Make len default to 0 in constructor, and then set it from
                 open return.
              Set newmode in open() call to -99 by default, ensures
                 that we realize that no mode was sent.
11/11/91  DR  Multiple fixes and changes to better handle variable length
                 records.
              Add clone_file() to public interface.
11/12/91  DR  Add support for just_update parm to put_rec();

08/06/92  DR  Add allows_nulls(key_num)
*/

#ifndef BFILE_H
#define BFILE_H
#include "btrieve.h"
extern "C" {
int BTRV(int ,char *,char *,int *,char *,int );
}

class bfile {
   char pos_blk[128];        // position block
   char fname[64];           // physical file name
   char logical_name[10];    // logical file name (not used yet)
   int  mode;                // open mode
   int  file_flag;           // flag from STAT call.
   int  fixed_len;           // The non-variable length.
   unsigned  rec_len;        // record length, i.e. higher than above for
                             //    variable lenght records.
                             //    This is == to above UNLESS you pass
                             //    a length to constructor.  For variable
                             //    length records, you MUST pass a length
                             //    that is the upper limit you expect.
   unsigned  last_rec_len;   // most recent returned len
   int  key_num;             // current key number
   int  num_keys;            // number of keys in file
   int  status;              // error status
   int  opened;              // opened flag, not really essential because data
                             //   seemed like it was as natural a flag
                             //   as possible, since we don't want to write
                             //   data to null.
   char *data;               // The data, of course...
   char owner[60];           // owner of the file, used for secured files.
public:
  // file name, lenght, owner, and open mode
  // Note that constructor opens file, destructor closes.
   bfile(char far *name,unsigned len=0,char far *towner=0,int newmode=0);
   ~bfile();
  // Close file, free up data pointer above.
   int  close();
  // Open, really SB reopen I guess since only useful after close...
   int  open(int newmode=-99);
  // file name, lenght, owner, and open mode
  // Note that this opens file, destructor closes.
   newfile(char far *name,int len=0,char far *towner=0,int newmode=0);
  // Gets a record.  Uses key 0 unless you set key number (below).
   int  get_rec(char far *keystr,int op=B_GET_EQ);
  // overload ++ operator
   int  operator++()
   {
      char temp[255];
      return(get_rec(temp,B_GET_NEXT));
   }
  // overload -- operator
   int  operator--()
   {
      char temp[255];
      return(get_rec(temp,B_GET_PREV));
   }
  // overload operator++
   int  operator++(int )
   {
      char temp[255];
      return(get_rec(temp,B_GET_NEXT));
   }
  // overload  operator--
   int  operator--(int )
   {
      char temp[255];
      return(get_rec(temp,B_GET_PREV));
   }
  // Self explanatory...
   void set_key_num(int key=0)
        {
          // sanity check...
           if ( key<num_keys )
           {
              key_num=key;
           }
        }
   int  get_key_num() { return key_num; }
   int  get_key_len(int key_num=-1);
  // Get the number of keys allowed.
   int  get_num_keys() { return num_keys; }
  // take newdata and copy it into the data element.
   int  set_data(char far *newdata)
        {
           if ( data!=NULL )
           {
              memcpy(data,newdata,rec_len);
              return(1);
           }
           return(0);
        }
  // return pointer to data.
   char *get_data(int *last_len=0)
        {
           if ( last_len!=0 )
           {
              *last_len=last_rec_len;
           }
           return data;
        }
  // return pointer to COPY data.
   char *dup_data()
        {
           char *datacopy=0;
           if ( opened && data!=0 )
           {
              datacopy=new char[rec_len];
              if ( datacopy!=0 )
              {
                 memset(datacopy,'\0',rec_len);
                 memcpy(datacopy,data,rec_len);
              }
           }
           return datacopy;
        }
  // Insert or update record.  could make seperate functions to force one
  //   or the other.  I prefer this.
  //   SEE BELOW...
   int  put_rec(char far *keystr=0,unsigned tlen=0,int just_update=0);
  // Insert.  made seperate functions to force insert.
   int  insert(char far *keystr=0,unsigned tlen=0);
  // self explanatory...except that if keystr==0, positioning is not done
   int  del_rec(char far *keystr=0);
  // allow user to get status after operation.
   int  get_status(){ return status; }
  // does the specified key number allow NULLS?  Important to know..
   int allows_nulls(int test_key);
  // This is really awful, but allows user to SET status to fool others...
   void set_status(int newstat) { status=newstat; };
  // gets a full FIL_SPEC record (see btrieve.h)
   void get_bstat(struct FIL_SPEC *);
  // returns rec_len private element.
   unsigned  get_len() { return rec_len; }
  // returns fixed_len private element.
   int  get_fixed_len() { return fixed_len; }
  // returns last_rec_len private element.
   unsigned  get_last_len() { return last_rec_len; }
   int  get_pos(char far *buf)
   {
      unsigned tlen=4;
      char temp[256];
      status=BTRV(B_GET_POS,pos_blk,buf,(int *)&tlen,temp,key_num);
      return(status);
   }
   int  unlock()
   {
      unsigned tlen=128;
      char temp[256];
      char buf[256];
      status=BTRV(B_UNLOCK,pos_blk,buf,(int *)&tlen,temp,-2);
      status=BTRV(B_UNLOCK,pos_blk,buf,(int *)&tlen,temp,0);
      return(status);
   }
   int set_pos(char far *buf,char far *keystr=0);
   int get_fname(char far *tstr)
   {
      if ( tstr!=0 )
      {
         strcpy(tstr,fname);
      }
      return(tstr!=0);
   }
   int clone_file(char far *destfname,int overwrite=1);
   int variable_len() { return (file_flag&1); }
   int key_only() { return (file_flag&16); }
   int key_from_data(char far *);
   long num_links(int tkey);
   int get_pos_blk(char far *t) { memcpy(t,pos_blk,128); return(data!=0); }
   int set_pos_blk(char far *t) { memcpy(pos_blk,t,128); return(data!=0); }
};
#endif
