/*--------------------------------------------------------------------------

This module will handle the binary coded decimal requirements.  It is
      easier to please than the COBOL equivelant since it will take all
      NULLS as zero.

--------------------------------------------------------------------------*/

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "bfile.h"
#include "ctype.h"

#define EOS '\0'
#define TRUE 1
#define FALSE 0
/******
#define THIS_IS_A_TEST 1
******/
/* Takes ASCII string and converts to BCD */

int allnull(char *,int );

int asc_bcd(char *dest,char *source,int no_bytes)
{
register int loop;
register int bytes;
         int hi=1;      /* hi refers to nibble being operated upon */

    memset(dest,EOS,no_bytes);
    loop=(strlen(source))-1;
    bytes=no_bytes-1;
   /* negative number? */
    if ( (strstr(source,"-"))!=0 )
    {
       dest[bytes]=0x0D;
    }
    else
    {
       dest[bytes]=0x0F;
    }
    while ( bytes>=0 && loop>=0 )
    {
       while ( !(isdigit(source[loop])) && (loop>=0) )
       {
	  loop--;
       }
       if ( (loop>=0) )
       {
	  if ( hi )
          {
             dest[bytes]|=( (source[loop]&0x0F)<<4 );
             hi=0;
	     bytes--;
          }
          else
          {
             dest[bytes]=(source[loop]&0x0F);
             hi=1;
          }
          loop--;
       }
    }
    return(loop);
}

/* Takes BCD string and converts to ASCII */

int bcd_asc(unsigned char *source,unsigned char *dest,int no_bytes)
{
register  int loop;
          int bytes;
	  int tempi2;
	  int hi=1;
	  int negitive=0;
register  int offset;
unsigned char temp[20];

    if ( (allnull(source,no_bytes)) )
    {
       for ( loop=0 ; loop<(no_bytes*2)-1 ; loop++ )
       {
          temp[loop]='0';
       }
       temp[loop]='F';
       temp[loop+1]=EOS;
    }
    else
    {
       memset(temp,EOS,no_bytes*2);
       bytes=no_bytes-1;
      /* negative number? */
/*     tempi1=(int)(source[no_bytes-1])/0x10;
       tempi2=(source[no_bytes-1])-(tempi1*0x10);
*/     tempi2=(source[no_bytes-1])&0x0F;
       if ( tempi2==0x0D )
       {
	  negitive=TRUE;
       }
       else
       {
          negitive=FALSE;
       }
/*     printf("\ntempi2=0x%0X negitive=%d ",tempi2,negitive);
       getch();
*/
       for ( loop=bytes,hi=TRUE,offset=(bytes*2) ; offset>=0 ; offset-- )
       {
          if ( hi==TRUE )
          {
             temp[offset]=( (source[loop]&0xF0)>>4 )+'0';
   /*        printf("\ntemp[%d]='%c' or %d ",offset,temp[offset],temp[offset]);
   */        hi=FALSE;
             loop--;
          }
          else
          {
	     temp[offset]= (source[loop]&0x0F)+'0';
   /*        printf("\ntemp[%d]='%c' or %d ",offset,temp[offset],temp[offset]);
   */        hi=TRUE;
          }
       }
       temp[(no_bytes*2)+1]=EOS;
       offset=0;
       while ( temp[offset]=='0' )
          offset++;
       for ( loop=offset ; loop<no_bytes*2 ; loop++ )
       {
          dest[loop-offset]=temp[loop];
       }
       dest[no_bytes*2]=EOS;
       if ( negitive==TRUE )
       {
          sprintf(dest,"%lf",(atof(dest))*-1.0);
       }
    }
    return(0);
}

/* checks if string is NULL to num bytes.  Used to handle all NULL strings
      that C may give me, since BCD is simulated with char *, not built in
      type.
*/
int allnull(char *string,int num)
{
register int loop;

   for ( loop=0 ; !(string[loop]) && loop<num ; loop++ )
   {
      ;
   }
   return(loop==num);
}

/* BCD to long int */

long bcdtol(char *bcdstr,int no_bytes)
{
   char temp[50];
   memset(temp,EOS,50);
   bcd_asc(temp,bcdstr,no_bytes);
   return((atol(temp)));
}

/* BCD to double.  (Yes, I know that the 'f' in bcdtof seems to say that
      float will be returned, but I am just following convention within
      std. C lib.  atof(); really returns double as well...
*/

double bcdtof(char *bcdstr,int no_bytes)
{
   char temp[50];
   memset(temp,EOS,50);
   bcd_asc(bcdstr,temp,no_bytes);
   return((atof(temp)));
}

#ifdef THIS_IS_A_TEST
main()
{
    int loop;
   char temp[20];
   char temp2[20];

    printf("\nPress any key to begin");
    pause(0);
    for ( loop=0 ; loop<1 ; loop++ )
    {
       asc_bcd(temp,"-1234.56",5);
    }
    printf("\nDone!!!\n");
    for ( loop=0 ; loop<5 ; loop++ )
    {
       printf("%02X",temp[loop]);
    }
    printf("\nPress any key to see value");
    getch();
    printf("\nbcdtol=%ld ",(bcdtol(temp,5)));

    for ( loop=0 ; loop<1 ; loop++ )
    {
       asc_bcd(temp,"1234.56",5);
    }
    printf("\nDone!!!\n");
    for ( loop=0 ; loop<5 ; loop++ )
    {
       printf("%02X",temp[loop]);
    }
    printf("\nPress any key to see value");
    getch();
    printf("\nbcdtol=%ld ",(bcdtol(temp,5)));

}
#endif
