/* Extended Integer Arithmetic Library
**
** Version 1.1
** Copyright (C) 1990, by Fred Motteler
** All Rights Reserved
**
** This is a simple extended integer arithmetic package.
**
** This version should be K&R, ANSI, and C++ compatible.
**
** Format:
**
** 	byte 0	byte 1	byte 2	...	byte N
**	ms byte ...	...	...	ls byte
**
** Each routine returns a condition code value:
**
**	0 0 0 0 Z V S C
**	Where Z = result zero if 1
**	      V = overflow if 1
**	      S = result negative if 1 (if ms bit of result is 1)
**	      C = carry
*/

#define CARRY 1			/* Carry bit is ls bit */
#define SIGN 2			/* Sign bit is next ls bit */
#define OVERFLOW 4		/* Overflow bit is next bit */
#define ZERO 8			/* Zero bit is the next bit */
#define NSIGN 0x80		/* Sign bit mask */

/* Pre-declarations for all functions */
#ifdef PROTOTYPES
unsigned char itestm(unsigned char *valuePB, unsigned char condcodeB,
		     int nbyteN, int signoneN, int signtwoN);
unsigned char iaddm(unsigned char *sumPB, unsigned char *termPB, int nbyteN);
unsigned char isubm(unsigned char *sumPB, unsigned char *termPB, int nbyteN);
int ucheckm(unsigned char *termPB, int nbyteN);
int ucmpm(unsigned char *firstPB, unsigned char *secondPB, int nbyteN);
void ushftlm(unsigned char *termPB, int nbyteN);
void ushftrm(unsigned char *termPB, int nbyteN);
unsigned char umultm(unsigned char *prodPB, unsigned char *termPB, int nbyteN);
void inegm(unsigned char *valuePB, int nbyteN);
unsigned char smultm(unsigned char *prodPB, unsigned char *termPB, int nbyteN);
unsigned char udivm(unsigned char *dividPB, unsigned char *termPB, int nbyteN);
unsigned char sdivm(unsigned char *dividPB, unsigned char *termPB, int nbyteN);
#else
extern unsigned char iaddm(), isubm(), umultm(), smultm();
extern void ushftlm(), ushftrm(), inegm();
extern unsigned char udivm(), sdivm(), itestm();
extern int ucheckm(), ucmpm();
#endif

/* Some compilers may not support "stdlib.h" */
#ifdef MWC
extern char *malloc();
extern char *calloc();
extern void free();
#endif

#ifdef MEMTEST
/* Memory allocation / free test functions */

#ifdef PROTOTYPES
void fmallinit(void);
int fmallreport(void);
unsigned char *fmalloc(unsigned int sizeN, char *func_nameBP);
unsigned char *fcalloc(unsigned int sizeN, unsigned int objectN, char *func_nameBP);
void ffree(unsigned char *pntrBP);
#else
void fmallinit();		/* Initialize memory allocation table */
int fmallreport();		/* Report on memory allocated */
unsigned char *fmalloc();	/* Allocate block of memory */
unsigned char *fcalloc();	/* Allocate zeroed block of memory */
void ffree();			/* Free memory */
#endif

/* Memory allocation /free test macros.
** Use these macro in place of malloc(), calloc(), and free() to allow
** error reporting of allocated memory that has not been free'd. */
#define FMALLOC(a,b) fmalloc((a),(b))
#define FCALLOC(a,b,c) fcalloc((a),(b),(c))
#define FFREE(a) ffree((a))

#else
/* Macros that default standard memory allocation scheme. */
#define FMALLOC(a,b) malloc((a))
#define FCALLOC(a,b,c) calloc((a),(b))
#define FFREE(a) free((a))
#endif
