/* Extended IEEE Compatible Floating Point Arithmetic Library
**
** Version 1.1
** Copyright (C) 1990, by Fred Motteler
** All Rights Reserved
**
** This is part 3 of a simple extended floating point arithmetic package
** tester.
**
** This is a table driven tester.  It does a comprehensive test of:
**	1. Integer / ASCII string conversions
**	2. Float / ASCII decimal conversions
**	3. Integer / Float conversions
**	4. Float / Integer conversions
**	5. Float / Float conversions
**
** Where reasonable, all numeric input and output values are specified
** as ASCII strings.  This greatly simplifies setting up test cases, and
** provides a good test of the string conversion routines.
** Note that these routines recognize zero, but NOT infinite, not a number,
** or denormalized input parameters.  They blindly assume that the arguments
** are valid floating point numbers.
**
** These routines will return valid zero, infinite, and not a number values.
*/
#include <stdio.h>
#ifndef MWC
#include <stdlib.h>
#endif
#include "imlib.h"
#include "ffmlib.h"
#include "fmlib.h"
#include "fmtest.h"

/* Include the tables containing the tester data.  There are two data
** tables that contain test cases for:
**
**	string to integer conversions
**	string to float conversions
*/
#include "fmtest3.h"

/*
** Function:	int fmtst3(int *testPN)
**
** This is a table driven tester.  It does a comprehensive test of:
**	1. ASCII string / Integer conversions
**	2. ASCII string / Floating point conversions
**
** testPN is a pointer to an integer used to total the error count.
**
** Where reasonable, all numeric input and output values are specified
** as ASCII strings.  This greatly simplifies setting up test cases, and
** provides a good test of the string conversion routines.
*/
int
#ifdef PROTOTYPES
fmtst3(int *testPN)
#else
fmtst3(testPN)
int *testPN;
#endif
{
    int i, fracbitsN, expbitsN, totalenN, radixN;
    int intlenN;
#ifdef MEMTEST
    int memparcelN;
#endif
    unsigned char opAB[128];
    char resultAB[128];
    unsigned char condcodeB;
    int errcountN;

    errcountN = 0;

#ifdef MEMTEST
    fmallinit();
#endif

    printf("**********************************************\n");
    printf("** ASCII string to integer conversion tests **\n");
    printf("**********************************************\n");
    i = 0;
    while (sitableAH[i].operationS != NULL)
    {
	/* Determine the byte length of the output integer */
	intlenN = sitableAH[i].intolenN;

	printf("Operation %d: %s\n", (*testPN)++, (sitableAH[i].operationS));
#ifdef TEST
	printf("Output integer length: %d\n", intlenN);
#endif

	/* Convert the first operand from a string to an integer. */
	condcodeB = strtoint(sitableAH[i].intinBP,
		  strlen(sitableAH[i].intinBP), opAB, intlenN, 10);
#ifdef TEST
	printf("Integer as string: %s\n", sitableAH[i].intinBP);
	foutput("Integer in binary: ", opAB, intlenN);
#endif

	/* Convert the result back to a string. */
	intostr(opAB, intlenN, resultAB, 128, 10);
#ifdef TEST
	printf("Result as string: %s\n", resultAB);
	printf("Result should be: %s\n", sitableAH[i].intoBP);
	printf("Result condition code: 0x%x\n", condcodeB);
	printf("Condition code should be: 0x%x\n", sitableAH[i].ccresultN);
#endif
	if ((strcmp(resultAB, sitableAH[i].intoBP) == 0) &&
	    (((int) condcodeB) == sitableAH[i].ccresultN))
	{
	    printf(" [(-:} OK {:-)]\n");
	}
	else
	{
	    printf(" [)-:}***** ERROR *****{:-(]\n");
	    errcountN++;
	}
#ifdef MEMTEST
	if ((memparcelN = fmallreport()) != 0)
	{
	    printf("%d memory blocks not free'd\n", memparcelN);
	    errcountN += memparcelN;
	}
#endif
	i++;
    }

    printf("***********************************************\n");
    printf("** String to floating point conversion tests **\n");
    printf("***********************************************\n");
    i = 0;
    while (sftableAH[i].operationS != NULL)
    {
	/* Determine the length and type of the input floating point number */
	expbitsN = sftableAH[i].fltoexpN;
	fracbitsN = sftableAH[i].fltofracN;
	totalenN = sftableAH[i].fltolenN;

	printf("Operation %d: %s\n", (*testPN)++, (sftableAH[i].operationS));
#ifdef TEST
	printf("Output float exponent bits: %d, Mantissa bits: %d, Total byte length: %d\n",
		expbitsN, fracbitsN, totalenN);
#endif

	/* Convert the first operand from a string to a float. */
	condcodeB = strtoflt(sftableAH[i].fltinBP,
			     strlen( sftableAH[i].fltinBP ), opAB,
			     fracbitsN, expbitsN);
#ifdef TEST
	printf("Float as string: %s\n", sftableAH[i].fltinBP);
	foutput("Float in binary: ", opAB, totalenN);
#endif

	/* Convert the result back to a string. */
	fltostr(opAB, fracbitsN, expbitsN, resultAB, 128);
#ifdef TEST
	printf("Result as string: %s\n", resultAB);
	printf("Result should be: %s\n", sftableAH[i].fltoutBP);
	printf("Result condition code: 0x%x\n", condcodeB);
	printf("Condition code should be: 0x%x\n", sftableAH[i].ccresultN);
#endif
	if ((strcmp(resultAB, sftableAH[i].fltoutBP) == 0) &&
	    (((int) condcodeB) == sftableAH[i].ccresultN))
	{
	    printf(" [(-:} OK {:-)]\n");
	}
	else
	{
	    printf(" [)-:}***** ERROR *****{:-(]\n");
	    errcountN++;
	}
#ifdef MEMTEST
	if ((memparcelN = fmallreport()) != 0)
	{
	    printf("%d memory blocks not free'd\n", memparcelN);
	    errcountN += memparcelN;
	}
#endif
	i++;
    }

    return(errcountN);
}
