/* Extended IEEE Compatible Floating Point Arithmetic Library
**
** Version 1.1
** Copyright (C) 1990, 1992 by Fred Motteler
** All Rights Reserved
**
** This is a simple extended floating point arithmetic package.
*/

/* Bit masks for floating point condition code values */
#define FFNAN 1
#define FFINF 2
#define FFZERO 4
#define FFNEG 8

/* Floating point functions */
#ifdef PROTOTYPES
unsigned char fmultm(unsigned char *prodPB, unsigned char *termPB,
		     int expbitN, int fracbitN);
unsigned char fdivm(unsigned char *dividPB, unsigned char *termPB,
		    int expbitN, int fracbitN);
int fcmpm(unsigned char *flt1PB, unsigned char *flt2PB, int expbitN,
	  int fracbitN);
unsigned char fsubm(unsigned char *diffPB, unsigned char *termPB,
		    int expbitN, int fracbitN);
unsigned char faddm(unsigned char *sumPB, unsigned char *termPB,
		    int expbitN, int fracbitN);
#else
unsigned char fmultm();		/* Floating point multiply */
unsigned char fdivm();		/* Floating point dividend */
unsigned char faddm();		/* Floating point addition */
unsigned char fsubm();		/* Floating point subtraction */
int fcmpm();			/* Floating point comparison */
#endif

/* Numeric conversion functions */
#ifdef PROTOTYPES
unsigned char intoflt(unsigned char *intvalBP, int intlenN,
		      unsigned char *fltvalBP, int fracbitN, int expbitN);
unsigned char fltoint(unsigned char *fltvalBP, int fracbitN, int expbitN,
		      unsigned char *intvalBP, int intlenN);
unsigned char fltoflt(unsigned char *fltinBP, int mantinN, int expinN,
		      unsigned char *fltoutBP, int mantoutN, int expoutN);
#else
unsigned char intoflt();	/* Integer to float */
unsigned char fltoint();	/* Float to integer */
unsigned char fltoflt();	/* Float to float */
#endif

/* Numberic / string conversion functions */ 
#ifdef PROTOTYPES
unsigned char intostr(unsigned char *intvalBP, int intlenN,
		      char *strBP, int slenN, int radixN);
	
unsigned char fltostr(unsigned char *fltvalBP, int fracbitN, int expbitN,
		      char *strBP, int slenN);
unsigned char strtoint(char *strBP, int slenN, unsigned char *intvalBP,
		       int intlenN, int radixN);
unsigned char strtoflt(char *strBP, int slenN, unsigned char *fltvalBP,
		       int fracbitN, int expbitN);
unsigned char intopten(unsigned char *fltexpBP, int expbyteN, 
                       unsigned char *ptenfltBP, int fracbitN, int expbitN);
#else
unsigned char intostr();	/* Integer to ASCII string */
unsigned char fltostr();	/* Float to decimal ASCII string */
unsigned char strtoint();	/* ASCII string to integer */
unsigned char strtoflt();	/* ASCII string to float */
unsigned char intopten();	/* Generate float integral powers of 10 */
#endif

