/* Extended IEEE Compatible Floating Point Arithmetic Library
**
** Version 1.0
** Copyright (C) 1990, by Fred Motteler
** All Rights Reserved
**
** This is a simple extended floating point arithmetic package.
*/

/* Lookup table for bit masks to clear extra high order bits */
extern unsigned char ffclearmaskAB[];

/* Lookup table for bit masks to set/clear/test specific bits */
extern unsigned char ffsetmaskAB[];
extern unsigned char ffclrmaskAB[];

/* Functions used only by the floating point functions */
#ifdef PROTOTYPES
extern void ffbitext(unsigned char *srcPB, int srclenN, int sbitN, int bitlenN,
		     unsigned char *destPB, int destlenN);
extern void ffbitins(unsigned char *srcPB, int srclenN, int dbitN, int bitlenN,
		     unsigned char *destPB, int destlenN);
extern void ffbitset(unsigned char *srcPB, int srclenN, int nbitN);
extern void ffbitclr(unsigned char *srcPB, int srclenN, int nbitN);
extern unsigned char fftstbit(unsigned char *srcPB, int srclenN, int nbitN);
extern unsigned char ffchkzero(unsigned char *resultPB, int totalenN);
extern unsigned char ffexpchk(unsigned char *prodexpPB, int expbyteN,
			      unsigned char *expbiasPB, int expbitN,
			      unsigned char expccB);
extern unsigned char ffexpover(unsigned char *resultPB, int totalenN,
			       unsigned char expccB, unsigned char *expbiasPB,
			       int expbyteN, unsigned char *exponePB, 
			       unsigned char condcodeB, int fracbitN,
			       int expbitN);
extern unsigned char ffsetsign(unsigned char signoneB, unsigned char signtwoB,
			       unsigned char *resultPB, int totalenN,
			       int signposN, unsigned char condcodeB);
extern int fftotlen(int expbitN, int fracbitN);
extern int ffexplen(int expbitN);
extern int ffraclen(int fracbitN);
extern void ffgenbias(unsigned char *expbiasPB, int expbyteN, int expbitN);
extern void ffextall(unsigned char *fltPB, int totalenN, int fracbitN, int fracbyteN, int expbitN, int expbyteN, unsigned char *fltfracPB, unsigned char *fltexpPB, unsigned char *fltsignPB);
#else
extern void ffbitext();		/* Extract bit fields */
extern void ffbitins();		/* Insert bit fields */
extern void ffbitset();		/* Set bits */
extern void ffbitclr();		/* Clear bits */
extern unsigned char fftstbit(); /* Test bits */
extern unsigned char ffchkzero(); /* Check if floating pt value is zero */
extern unsigned char ffexpchk(); /* Check for exponent over/underflow */
extern unsigned char ffexpover(); /* Deal with over/undrflow */
extern unsigned char ffsetsign(); /* Set result sign bit */
extern int fftotlen();		/* Total byte length of floating pt value */
extern int ffexplen();		/* Byte length of floating pt exponent value */
extern int ffraclen();		/* Byte length of floating pt mantissa value */
extern void ffgenbias();	/* Generate exponent offset bias value */
extern void ffextall();		/* Extract float mantissa, exp, and sign */
#endif

