*     Extra Listing 3 - Direct Memory Access - K. G. Hamilton

      PROGRAM POPUP_DEMO_WITH_MSF
      call popup('Your Name Here')
      stop
      end

      INTERFACE TO SUBROUTINE PEEKB0(L,I)
      integer*4 L [VALUE]
      integer*1 I
      end

      INTERFACE TO SUBROUTINE CRTPUT(L,I1,I2,I3,C)
      integer*4 l [VALUE]
      integer*2 i1, i2, i3
      character*1 c 
      end

      INTERFACE TO SUBROUTINE GETBOX(L,I1,I2,I3,I4,I5)
      integer*4 l [VALUE]
      integer*2 i1, i2, i3, i4
      integer*1 i5
      end

      INTERFACE TO SUBROUTINE PUTBOX(L,I1,I2,I3,I4,I5)
      integer*4 l [VALUE]
      integer*2 i1, i2, i3, i4
      integer*1 i5
      end

      INTERFACE TO SUBROUTINE INTDOS [C] (ir1,ir2)
      integer*2 ir1 [REFERENCE]         ! Regs into INTDOS
      integer*2 ir2 [REFERENCE]         ! Regs returned
      end

      SUBROUTINE POPUP(A)
      character*(*) a                   ! String to write
      character*80 cbuf                 ! Temporary buffer
      integer*4 laddr/#00000449/        ! Address of video mode byte
      integer*1 ividmod                 ! Value at that location
      integer*4 imono/#B0000000/        ! B&W adapter address
      integer*4 ivga /#B8000000/        ! Color adapter address
      integer*4 icrt                    ! Adapter in use
      integer*2 iat1, iat2              ! Video attributes
      integer*2 iregs(7)                ! For INTDOS
      integer*1 savescrn[ALLOCATABLE](:,:,:)  ! Save screen here
c
c     Demonstration of a popup box using Microsoft Fortran
c     Kenneth G. Hamilton
c
      call peekb0(laddr,ividmod)        ! First, get the video mode
c
      if (ividmod.eq.7) then            ! Mono is video mode 7
        icrt = imono
      else                              ! All other modes are color
        icrt = ivga
        iat1 = #4F                      ! Bold white on red
        iat2 = #CF                      ! Flashing bold white on red
      endif
c
c     Figure out how big the box needs to be
c
      l = len_trim(a)
      ll = max(l,13)                    ! 'Press any key' is 13 chars long
      ilin = 11                         ! Main message half way down screen
      jcol = 38 - (ll/2)                ! Let's center the box
      n = ll+4                          ! Total width of box
c
c     Save current data on screen into SAVESCRN
c
      allocate (savescrn(2,n,4))
      call getbox(icrt, ilin, jcol, 4, n, savescrn)
c
c     Write top and bottom lines of box
c
      cbuf(1:1)=''                     ! Top line
      do i=2,n-1
        cbuf(i:i)=''
      enddo
      cbuf(n:n)=''
      call crtput(icrt, ilin, jcol, iat1, cbuf(:n))
c
      cbuf(1:1)=''                     ! Bottom line
      cbuf(n:n)=''
      call crtput(icrt, ilin+3, jcol, iat1, cbuf(:n))
c
c     Write center two lines
c
      cbuf=' '
      cbuf(1:1)=''
      cbuf(n:n)=''
      call crtput(icrt, ilin+1, jcol, iat1, cbuf(:n))
      call crtput(icrt, ilin+2, jcol, iat1, cbuf(:n))
c
c     Put message, with 'Press any key' flashing
c
      call crtput(icrt, ilin+1, jcol+2, iat1, a(:l))
      call crtput(icrt, ilin+2, jcol+2, iat2, 'Press any key')
c
c     Wait for key press
c
      iregs(1) = #0800                  ! Load into AX register
      call intdos(iregs,iregs)          ! Read from CON, no echo
c
c     Restore screen data from SAVESCRN
c
      call putbox(icrt, ilin, jcol, 4, n, savescrn)
      deallocate (savescrn)
c
      return
      end
