/**************************************************************************************************
*
*		Title:	SNOOP.H
*		Copyright (c) October 1992, Ryu Consulting
*		Written by Rahner James
*
*		This is the header file to be used for print server and NIC activities
*
**************************************************************************************************/

#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <rjuser.h>


#define	SAVE_BAD_PACKETS	1			// 0:packets with errors are discarded, 1:error packets are saved
#define	ACCEPT_RUNT_PACKETS	(1 << 1)	// 0:runts are discarded, 1:packets with < 64 bytes are accepted as one of us
#define	ACCEPT_BROADCAST	(1 << 2)	// 0:broadcasts are ignored, 1:broadcasts accepted
#define	ACCEPT_MULTICAST	(1 << 3)	// 0:multicast address not checked, 1:multicast address checked
#define	SLUT				(1 << 4)	// 0:physical address must match PAR0-PAR5, 1:accepts all packets
#define	MONITOR_MODE		(1 << 5)	// 0:accepted packets are buffered, 1:packets are checked and ACKed but not saved

#define	IPX_HEADER_SIZE		30			// Number of bytes in the IPX header area (not including the NIC header)
#define	NIC_HEADER_SIZE		18			// Number of bytes in the NIC header area (from checksum to src_socket, inclusive)


/**************************************************************************************************
*
*					ECB Flags
*
**************************************************************************************************/

#define	ECB_OWNER_DRIVER	0			// ECB is owned by the driver
#define	ECB_OWNER_APP		1			// ECB is owned by the application
#define	ECB_FREE_XMIT		(1 >> 1)	// ECB memory is to be freed once transmitted


/*
** Socket numbers
*/

#define	NCP_SOCKET			0x451		// Socket for any Netware Core Protocol requests
#define	SAP_SOCKET			0x452		// Socket for SAPping and SAP queries
#define	ROUTE_SOCKET		0x453		// Socket for routing information


/*
** Error return codes
*/

#define	NCPERR_NOERROR			0		// No error from NCP function
#define	NCPERR_NO_QJOB			-43		// No job available for the queue
#define	NCPERR_FILENAME			-128	// Bad filename or NULL filename
#define	NCPERR_ALLOC			-129	// NULL returned from memory allocation
#define	NCPERR_TIMEOUT			-130	// Timeout occurred with ACK from remote
#define	NCPERR_NOACCOUNT		-131	// Print server account not found in bindery
#define	NCPERR_NOACCESS			-132	// Print server can not log into file server
#define	NCPERR_LOST_CONNECT		-133	// Connection was lost
#define	NCPERR_MALFORMED		-134	// Malformed packet received from network


typedef struct NIC_ECB_S
{
	ui				next;		// -> next ECB in this list								(00)
	us				flags;		// General flags used by the drivers					(02)
	void (FAR		*esr)();	// -> function to call when this packet is processed	(04)
	volatile char	in_use;		// Contains the current usage value						(08)
	volatile char	completion;	// Contains the completion code							(09)
	uc				node[6];	// Destination or source ID for the packet for the NIC	(0A)
	us				NIC_length;	// Length from the NIC

/*
** The IPX structure follows:
*/
	us			checksum;		// Checksum of the entire packet (Moto, always -1)		(10)
	us			ipx_length;		// Length of the entire packet, including the IPX header(12) converted by driver from Moto
	uc			transport;		// Transport control									(14)
	uc			packet_type;	// Packet type, 0,4=IPX, 5=SPX							(15)
	ul			dest_network;	// Destination network number (Moto)					(16)
	uc			dest_node[6];	// Destination node										(1A)
	us			dest_socket;	// Destination socket (Moto)							(20)
	ul			src_network;	// Source network number (Moto)							(22)
	uc			src_node[6];	// Source node											(26)
	us			src_socket;		// Source socket (Moto)									(2C)

} NIC_ECB_T;


typedef struct TASK_S
{
	struct TASK_S FAR *next;
	struct TASK_S FAR *prev;
	uc			priority;							// Task priority (255 = highest, 0=lowest)
	uc			status;								// Current status of the task, <=0 = done with return code, 1 in list, 2 processing
	void (FAR *function)( struct TASK_S FAR * );	// Function to call, near call for now, called with ptr to TASK_T in DX:AX
	void FAR  *buffer;								// -> buffer to send to the function
} TASK_T;


extern	ui	Base_Port;
extern	ul	Int_Count;
extern	uc	IRQ_Number, DMA_Channel, NE2000_Address[6];
extern	ui	Buffer_Start, Buffer_Size, Total_Allocated, First_Free, Last_MCB;
extern	volatile ul Tick_Count;
extern	volatile ui Total_Unread_Buffers;
extern	volatile ui Total_Xmit_Buffers;
extern	volatile ui Total_Xmit_Errors;
extern	volatile ui Total_Recv_Errors;
extern	volatile ui Total_Missed_Packets;
extern	volatile ul Total_Xmit_Packets;
extern	volatile ul Total_Recv_Packets;
extern	uc NIC_Normal_Recv_Config;

extern	int init_ne2000( void );
extern	int start_ne2000_interrupts( void );
extern	int stop_ne2000_interrupts( void );
extern	int init_memory( void );
extern	void FAR *alloc_NIC_ecb( ui );
extern	int free_NIC_ecb( void FAR * );
extern	NIC_ECB_T FAR *read_packet( void );
extern	void start_time_isr( void );
extern	void stop_time_isr( void );
extern	void show_packet_body( void FAR *, int, int );
extern	void show_net_address( int, int, void FAR * );
extern	void show_node_address( int, int, uc FAR * );
extern	int is_packet_valid( NIC_ECB_T FAR * );

extern	int is_ipx( void );

extern	int add_task( TASK_T FAR * );
extern	int do_next_task( void );

extern void atoaddr( char FAR *, char FAR * );
extern void FAR *farset( void FAR *, char, unsigned int );


#ifdef __WATCOMC__
	#pragma aux init_ne2000 "_*";
	#pragma aux start_ne2000_interrupts "_*";
	#pragma aux stop_ne2000_interrupts "_*";
	#pragma aux init_memory "_*";
	#pragma aux alloc_NIC_ecb "_*" parm [cx] value [es di];
	#pragma aux free_NIC_ecb "_*" parm [es di];
	#pragma aux read_packet "_*" value [es di];
	#pragma aux start_time_isr "_*";
	#pragma aux stop_time_isr "_*";

	#pragma aux is_ipx "_*";
	#pragma aux show_packet_body "_*" parm [dx ax] [cx] [bx];
	#pragma aux show_net_address "_*" parm [di] [ax] [cx si];
	#pragma aux show_node_address "_*" parm [di] [ax] [cx si];
	#pragma aux is_packet_valid "_*" parm [es di];

	#pragma aux add_task "_*" parm [es di];
	#pragma aux do_next_task "_*";

	#pragma aux atoaddr "_*" parm [es di] [dx si];
	#pragma aux farset "_*" parm [es di] [ax] [cx] value [es bx];
#endif
