; *************************************************************************************************
; *
; *	Title:	PROCESS.ASM
; *	Copyright (c) October 1992, Ryu Consulting
; *	Written by Rahner James
; *
; *	This file contains the functions to support the process control
; *
; *************************************************************************************************

	include	ne2000.inc


.data
; *************************************************************************************************
; *
; *					Global and Static
; *
; *************************************************************************************************

Task_Count		dw	0		; Number of tasks waiting to be processed
First_Ptr		dd	0		; -> position to place new task into the queue
Last_Ptr		dd	0		; -> position to pull next task to processes from


.code
; *************************************************************************************************
; *
; *	int ADD_TASK( PROCESS_S FAR *ES:DI )
; *	Adds a task to the process queue
; *
; *	Given:
; *		ES:DI -> task packet to put in queue
; *
; *	Returns:
; *		AX = 0 if placed in queue successfully
; *		All other registers preserved
; *
; *************************************************************************************************
add_task proc

	pushf
	cli

	mov	ax, es			; See if a NULL packet
	or	ax, di
	jz	done_add_task		; Jump if NULL

	mov	es:[di].TASK_S.status, 1
	cmp	Task_Count, 0		; See if we are the first
	jnz	add10_task		; Skip if we have company

; *
; * Put a single task here
; *
	mov	Task_Count, 1
	mov	word ptr First_Ptr, di	; Place this task at the beginning
	mov	word ptr First_Ptr+2, es
	mov	word ptr Last_Ptr, di	; Place this task at the beginning
	mov	word ptr Last_Ptr+2, es
	xor	ax, ax
	mov	word ptr es:[di].TASK_S.next, ax
	mov	word ptr es:[di].TASK_S.next+2, ax
	mov	word ptr es:[di].TASK_S.prev, ax
	mov	word ptr es:[di].TASK_S.prev+2, ax
	inc	ax
done_add_task:
	popf
	dec	ax			; Good returns should come here with 1
	ret

; *
; * Insert the most recent task
; *
add10_task:
	push	bx
	push	cx
	push	dx

	inc	Task_Count			; Bump the number of task up by one
	mov	al, es:[di].TASK_S.priority
	mov	dx, es				; DX = this task packet
	les	bx, Last_Ptr			; ES:BX -> last entry in the tail
add20_task:
	cmp	es:[bx].TASK_S.priority, al	; See if we have reached one higher than us
	jnb	add40_task			; Stop if we found one
	les	bx, es:[bx].TASK_S.prev		; ES:BX -> previous task packet
	mov	cx, es				; See if it's the end of the line
	or	cx, bx
	jnz	add20_task			; Loop if it isn't

; *
; * Insert task packet at the beginning of the list
; *
	les	bx, First_Ptr			; ES:BX -> first packet
	mov	word ptr es:[bx].TASK_S.prev, di	; Point it to us
	mov	word ptr es:[bx].TASK_S.prev+2, dx
	mov	word ptr First_Ptr, di
	mov	word ptr First_Ptr+2, dx
	mov	ax, es					; AX = segment of the old first
	mov	es, dx					; ES:DI -> the new task packet
	mov	word ptr es:[di].TASK_S.prev, 0		; Clear the previous pointer
	mov	word ptr es:[di].TASK_S.prev+2, 0
	mov	word ptr es:[di].TASK_S.next, bx	; Point the new to the old
	mov	word ptr es:[di].TASK_S.next+2, ax
add30_task:
	pop	dx
	pop	cx
	pop	bx
	mov	ax, 1					; Good return value
	jmp	done_add_task

; *
; * Insert task packet (DX:DI) after the value in ES:BX
; *
add40_task:
	mov	cx, dx					; CX:AX = DX:DI
	mov	ax, di
	xchg	word ptr es:[bx].TASK_S.next, ax	; Put us in and the old one out
	xchg	word ptr es:[bx].TASK_S.next+2, cx
	push	ds
	mov	ds, dx
	mov	word ptr [di].TASK_S.prev, bx		; Point our packet to the one before us
	mov	word ptr [di].TASK_S.prev+2, es
	mov	word ptr [di].TASK_S.next, ax		; Our next packet is the old next packet
	mov	word ptr [di].TASK_S.next+2, cx
	pop	ds
	mov	bx, ax					; See if the old next one is NULL
	or	bx, cx
	jnz	add50_task				; Jump if it was not

	mov	es, dx					; Restore ES:
	mov	word ptr Last_Ptr, di
	mov	word ptr Last_Ptr+2, dx
	jmp	add30_task

add50_task:
	mov	es, cx					; ES:BX -> old next
	mov	bx, ax
	mov	word ptr es:[bx].TASK_S.prev, di	; Point the next to us as the previous
	mov	word ptr es:[bx].TASK_S.prev+2, dx
	mov	es, dx
	jmp	add30_task

add_task endp


; *************************************************************************************************
; *
; *	int DO_NEXT_TASK( void )
; *	Performs the next task in the task queue
; *
; *	Given:
; *		nothing
; *
; *	Returns:
; *		0 if no tasks were available, 1 if task done
; *		All registers preserved
; *
; *************************************************************************************************
do_next_task proc

	pushf
	cli
	mov	ax, Task_Count			; AX = number of tasks ready
	or	ax, ax				; See if there are any
	jnz	@F
	jmp	done_do_next_task

@@:	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	es
	les	bx, First_Ptr			; ES:BX -> first structure
	mov	es:[bx].TASK_S.status, 2
	cmp	es:[bx].TASK_S.priority, REPEAT_PRIORITY
	jne	do10_next_task

; *
; * Here if repetitive task
; *
	cmp	Task_Count, 1			; See if this is the only task
	je	do20_next_task			; If only one, don't worry about any bookkeeping
	mov	ax, word ptr es:[bx].TASK_S.next
	mov	dx, word ptr es:[bx].TASK_S.next+2
	mov	word ptr First_Ptr, ax
	mov	word ptr First_Ptr+2, dx
	mov	word ptr es:[bx].TASK_S.next, 0
	mov	word ptr es:[bx].TASK_S.next+2, 0
	mov	dx, es				; DX:AX -> our task structure
	mov	ax, bx
	les	bx, Last_Ptr			; ES:BX -> old last one
	mov	word ptr Last_Ptr, ax		; Place us at the end
	mov	word ptr Last_Ptr+2, dx
	mov	word ptr es:[bx].TASK_S.next, ax
	mov	word ptr es:[bx].TASK_S.next+2, dx
	mov	dx, es				; DX:AX -> old last
	mov	ax, bx
	les	bx, Last_Ptr				; ES:BX -> us
	mov	word ptr es:[bx].TASK_S.prev, ax	; Point our previous to them
	mov	word ptr es:[bx].TASK_S.prev+2, dx
	jmp	short do20_next_task

do10_next_task:
	dec	Task_Count
	jz	do20_next_task			; Skip the list upkeep if that is the last in the queue

	les	bx, es:[bx].TASK_S.next		; ES:BX -> next in line
	mov	word ptr es:[bx].TASK_S.prev, 0	; Make it's previous pointer NULL
	mov	word ptr es:[bx].TASK_S.prev+2, 0
	les	bx, First_Ptr			; ES:BX -> first structure
	mov	ax, word ptr es:[bx].TASK_S.next
	mov	dx, word ptr es:[bx].TASK_S.next+2
	mov	word ptr First_Ptr, ax
	mov	word ptr First_Ptr+2, dx

do20_next_task:
	mov	dx, es
	mov	ax, bx
	call	es:[bx].TASK_S.function

	pop	es
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	mov	ax, 1

done_do_next_task:
	popf
	ret

do_next_task endp

	end
