; *************************************************************************************************
; *
; *	Title:	MISC_ASM.ASM
; *	Copyright (c) October 1992, Ryu Consulting
; *	Written by Rahner James
; *
; *	This file contains various assembly language functions necessary for SNOOP.EXE
; *
; *************************************************************************************************

	include	ne2000.inc

NIC_ATTRIBUTE		equ	24h
START_LINE		equ	6


.data

	extern	_Screen_Height:word, _Screen_Width:word, _Screen_Segment:word
	extern	Match_ID_Count:word, Match_IDs:byte		; [20][6]
	extern	Match_Socket_Count:word, Match_Socket:word	; [20]
	extern	And_Flag:byte, Broadcast_Flag:byte

Packet_Start_Line	dw	START_LINE


.code

Last_Length	dw	0
Hex_Table	db	'0123456789ABCDEF'	; Hexidecimal digits to use for display
Number_Table	db	' 000', ' 010', ' 020', ' 030', ' 040', ' 050', ' 060', ' 070'
		db	' 080', ' 090', ' 0A0', ' 0B0', ' 0C0', ' 0D0', ' 0E0', ' 0F0'
		db	' 100', ' 110', ' 120', ' 130', ' 140', ' 150', ' 160', ' 170'
		db	' 180', ' 190', ' 1A0', ' 1B0', ' 1C0', ' 1D0', ' 1E0', ' 1F0'


; *************************************************************************************************
; *
; *	int IS_IPX( void )
; *	Determines whether IPX is installed
; *
; *	Given:
; *		nothing
; *
; *	Returns:
; *		AX = 0 if not installed, !0 if it is
; *		All other registers preserved
; *
; *************************************************************************************************
is_ipx proc uses es di

	mov	ax, 7a00h
	int	2fh
	cbw
	ret

is_ipx endp


; *************************************************************************************************
; *
; *	LOOP_OUT_HEX
; *	Displays a number of hexadecimal bytes from a stream
; *
; *	Given:
; *		DS:SI -> byte stream to display
; *		BX -> Hex_Table
; *		ES:DI -> location on screen to display
; *		DX = 2 for incrementing DI
; *
; *	Returns:
; *		Stream oif hexadecimal bytes are displayed
; *
; *************************************************************************************************
loop_out_hex proc near
	mov	al, [si]		; AL = byte to display
	shr	al, 4			; Move the upper nibble to the lower
	xlat	Hex_Table
	mov	es:[di], al
	add	di, dx
	lodsb
	and	al, 0fh
	xlat	Hex_Table
	mov	es:[di], al
	add	di, dx
	loop	loop_out_hex

	ret
loop_out_hex endp


; *************************************************************************************************
; *
; *	void SHOW_NET_ADDRESS( int DI, int AX, void FAR *CX:SI )
; *	Displays a full network address (network:node:socket)
; *
; *	Given:
; *		DI = X coordinate
; *		AX = Y coordinate
; *		CX:SI -> source of the address
; *
; *	Returns:
; *		Full network address is displayed
; *
; *	This must have access to the following global variables:
; *
; *		_Screen_Width = number collumns for the display
; *		_Screen_Height = number of rows for the display
; *		_Screen_Segment = paragraph for the start of the screen
; *
; *************************************************************************************************
show_net_address proc uses bx dx ds es

	mul	_Screen_Width		; AX = start of the row to display at
	add	di, ax
	add	di, di			; DI -> display location
	mov	es, _Screen_Segment

	mov	bx, offset Hex_Table
	mov	dx, 2			; DX = 2
	mov	ds, cx			; DS:SI -> address to display
	mov	cx, 4
	call	loop_out_hex
	mov	byte ptr es:[di], ':'
	add	di, dx
	mov	cx, 6
	call	loop_out_hex
	mov	byte ptr es:[di], ':'
	add	di, dx
	mov	ax, [si]
	xchg	ah, al
	mov	[si], ax
	mov	cx, 2
	call	loop_out_hex
	mov	ax, [si-2]
	xchg	ah, al
	mov	[si-2], ax

	ret

show_net_address endp


; *************************************************************************************************
; *
; *	void SHOW_NODE_ADDRESS( int DI, int AX, uc FAR *CX:SI )
; *	Displays a 6-byte node address
; *
; *	Given:
; *		DI = X coordinate
; *		AX = Y coordinate
; *		CX:SI -> source of the address
; *
; *	Returns:
; *		Node number is displayed
; *
; *	This must have access to the following global variables:
; *
; *		_Screen_Width = number collumns for the display
; *		_Screen_Height = number of rows for the display
; *		_Screen_Segment = paragraph for the start of the screen
; *
; *************************************************************************************************
show_node_address proc uses bx dx ds es

	mul	_Screen_Width		; AX = start of the row to display at
	add	di, ax
	add	di, di			; DI -> display location
	mov	es, _Screen_Segment

	mov	bx, offset Hex_Table
	mov	dx, 2			; DX = 2
	mov	ds, cx			; DS:SI -> address to display
	mov	cx, 6
	call	loop_out_hex

	ret

show_node_address endp


; *************************************************************************************************
; *
; *	void SHOW_PACKET_BODY( void FAR *DX:AX, int CX, int BX )
; *	Displays the packet body
; *
; *	Given:
; *		DX:AX -> packet data area
; *		CX = length of the entire IPX packet
; *		BX = length of the entire NIC packet (should be greater than CX)
; *
; *	Returns:
; *		nothing
; *		Packet is displayed in a debugging format if CX > 30
; *
; *	This must have access to the following global variables:
; *
; *		_Screen_Width = number collumns for the display
; *		_Screen_Height = number of rows for the display
; *		_Screen_Segment = paragraph for the start of the screen
; *
; *************************************************************************************************
show_packet_body proc uses di si ds es
local	NIC_residue:word
local	screen_height:word
local	row_number:word
local	column_number:word
local	row_offset:word
local	this_length:word

	mov	this_length, bx		; Save the current maximum
	sub	bx, cx			; Get the residue
	jae	@F			; Skip if it is
	xor	bx, bx
	mov	this_length, cx
@@:	mov	NIC_residue, bx		; Save it for later
	sub	cx, IPX_HEADER_SIZE	; See if we have some IPX packet data to show
	jbe	show_residue		; Show the residue

	mov	si, ax			; SI = offset of buffer to display
	mov	di, dx			; DI = segment of same

	mov	ax, _Screen_Height	; Get the screen rows so we can use it locally
	mov	screen_height, ax
	mov	ax, _Screen_Width
	sub	ax, 16*3+8		; 16 numbers plus the midway marker
	add	ax, ax
	mov	row_offset, ax

	mov	ax, _Screen_Width	; AX = width of screen in collumns
	add	ax, ax			; AX = width of screen in bytes
	mul	Packet_Start_Line
	add	ax, 2			; Make it start at column 1 rather than 0

	mov	es, _Screen_Segment	; ES = start of the display memory
	mov	ds, di			; DS:SI -> source data
	mov	di, ax			; ES:DI -> destination of the ASCII data

	mov	row_number, 0
	mov	dx, offset Hex_Table	; Use for temporary storage of the hexadecimal values
	mov	ah, es:[di+1]		; AH = current screen attribute
show10_packet:
	mov	bx, row_number		; BX = row number
	add	bx, bx			; BX *= 4
	add	bx, bx

	mov	al, Number_Table[bx]
	stosw
	mov	al, Number_Table[bx+1]
	stosw
	mov	al, Number_Table[bx+2]
	stosw
	mov	al, Number_Table[bx+3]
	stosw

	add	di, 4			; DI -> start of the hex display area
	mov	bx, 54*2		; Collumn offset of the first character

	mov	column_number, 16	; DH = number of values to display
show20_packet:
	cmp	column_number, 8	; See if we have come midway
	jne	@F			; Skip if not

	mov	byte ptr es:[di], '-'	; Do the middle one
	add	di, 4
	sub	bx, 4

@@:	mov	al, [si]		; AL = byte to display
	or	al, al			; See if it's a 0 - the most common value
	jnz	@F			; Skip if it isn't

	mov	al, '.'			; Display a '.' instead (for a placeholder)
	mov	es:[di+bx], ax
	mov	al, '0'
	stosw				; Display '00'
	stosw
	inc	si
	sub	bx, 4
	jmp	short show30_packet

@@:	mov	es:[di+bx], ax		; Display the value in the character area
	xchg	bx, dx			; DX = offset, BX = hex table
	shr	al, 4			; Move the upper nibble to the lower
	xlat	Hex_Table
	stosw
	lodsb
	and	al, 0fh
	xlat	Hex_Table
	stosw
	xchg	dx, bx
	sub	bx, 4

show30_packet:
	add	di, 2			; Space between each hex number
	dec	column_number
	loopne	show20_packet

	jcxz	show_residue		; Skip if done with this chunk
	inc	row_number		; Next row down
	add	di, row_offset
	mov	bx, screen_height
	sub	bx, START_LINE
	cmp	row_number, bx
	jc	show10_residue
done_show_packet:
	mov	ax, this_length		; AX = total length we just did
	xchg	Last_Length, ax		; Make it the new last length
	sub	ax, Last_Length		; See if we have some left on the screen
	ja	clear_leftover		; Skip if we don't
done10_show_packet:
	ret

show_residue:
	mov	ah, NIC_ATTRIBUTE
	xchg	NIC_residue, cx		; CX = residue count and NIC_residue = 0
	jcxz	done_show_packet
	cmp	column_number, 0	; See if we were done
	jne	show20_packet
show10_residue:
	jmp	show10_packet

clear_leftover:
	mov	si, ax
	add	bx, di			; BX -> character side
	mov	cx, column_number	; Do the rest of the column
	jcxz	@F
	mov	dx, cx
	add	cx, cx
	inc	dx
	add	cx, dx			; CX *= 3 + 1

	mov	ah, es:[di-1]
	mov	al, ' '
	rep	stosw
	mov	di, bx
	mov	cx, dx			; Remainder + 1
	rep	stosw

	sub	si, column_number	; See if that did it
	jbe	done10_show_packet

; *
; * Now do the remaining rows
; *
@@:	mov	ax, @Data		; Restore DS
	mov	ds, ax
	mov	ax, di
	xor	dx, dx
	shr	ax, 1
	add	ax, _Screen_Width
	dec	ax
	div	_Screen_Width

	add	si, 15			; See how many rows we have left
	shr	si, 4
	add	ax, si
	sub	ax, _Screen_Height	; See if it's beyond the fringe
	jc	@F
	add	si, ax
	jbe	done10_show_packet

@@:	mov	ax, si			; AX = number of rows left to clear
	mul	_Screen_Width
	add	ax, ax
	mov	cx, ax
	mov	ah, es:[di-1]
	mov	al, ' '
	rep	stosw

	jmp	done10_show_packet

show_packet_body endp


; *************************************************************************************************
; *
; *	int IS_PACKET_VALID( NIC_ECB_T FAR *ES:DI )
; *	Determines whether an ECB is valid for display
; *
; *	Given:
; *		ES:DI -> packet to validate
; *
; *	Returns:
; *		!0 if packet is valid for display
; *		0 if it is an invalid
; *
; *	This must have access to the following global variables:
; *
; *		Broadcast_Flag
; *		And_Flag
; *
; *************************************************************************************************
is_packet_valid proc

	cmp	Broadcast_Flag, 0	; See if we accept broadcasts
	jz	@F			; Skip this check if so

; *
; * Check for a broadcast packet
; *
	mov	ax, word ptr es:[di].NIC_ECB_S.dest_node
	and	ax, word ptr es:[di].NIC_ECB_S.dest_node+2
	and	ax, word ptr es:[di].NIC_ECB_S.dest_node+4
	inc	ax
	jnz	@F			; Skip if not a broadcast

	dec	ax			; Set the valid return
	ret

; *
; * See if we are in AND or OR mode
; *
@@:	push	bx
	push	cx

	mov	cx, Match_ID_Count	; CX = number of ID's we have to match

	jcxz	is20_valid		; Skip if we don't have any ID's to match
	cmp	And_Flag, 0		; Check the AND flag
	jz	check_ors		; Make sure they are in the water

is10_valid:
	mov	ax, [bx]		; Compare against the destination node ID
	cmp	word ptr es:[di].NIC_ECB_S.dest_node, ax
	jne	@F
	mov	ax, [bx+2]
	cmp	word ptr es:[di].NIC_ECB_S.dest_node+2, ax
	jne	@F
	mov	ax, [bx+4]
	cmp	word ptr es:[di].NIC_ECB_S.dest_node+4, ax
	je	is20_valid		; Got a match here, so look for socket match

@@:	mov	ax, [bx]		; Compare against the destination node ID
	cmp	word ptr es:[di].NIC_ECB_S.src_node, ax
	jne	@F
	mov	ax, [bx+2]
	cmp	word ptr es:[di].NIC_ECB_S.src_node+2, ax
	jne	@F
	mov	ax, [bx+4]
	cmp	word ptr es:[di].NIC_ECB_S.src_node+4, ax
	je	is20_valid		; Quit with good return

@@:	add	bx, 6			; BX -> next match node value
	loop	is10_valid

done_invalid:
	xor	ax, ax			; Quit indicating invalid packet
	pop	cx
	pop	bx
	ret

; *
; * Now check the sockets
; *
is20_valid:
	mov	cx, Match_Socket_Count	; CX = number of sockets
	jcxz	done_valid		; Quit with valid set
is30_valid:
	mov	ax, es:[di].NIC_ECB_S.dest_socket	; AX = destination socket number
	mov	bx, ds					; ES:DI -> Match_Socket array
	mov	es, bx
	mov	di, offset Match_Socket
	repne	scasw
	jne	done_invalid

done_valid:
	or	ax, -1			; Say this is valid
	pop	cx
	pop	bx
	ret

; *
; * Check the OR route, CX = number of ID's in match array
; *
check_ors:
	mov	ax, [bx]		; Compare against the destination node ID
	cmp	word ptr es:[di].NIC_ECB_S.dest_node, ax
	jne	@F
	mov	ax, [bx+2]
	cmp	word ptr es:[di].NIC_ECB_S.dest_node+2, ax
	jne	@F
	mov	ax, [bx+4]
	cmp	word ptr es:[di].NIC_ECB_S.dest_node+4, ax
	je	done_valid		; Got a match here, so quit valid

@@:	mov	ax, [bx]		; Compare against the destination node ID
	cmp	word ptr es:[di].NIC_ECB_S.src_node, ax
	jne	@F
	mov	ax, [bx+2]
	cmp	word ptr es:[di].NIC_ECB_S.src_node+2, ax
	jne	@F
	mov	ax, [bx+4]
	cmp	word ptr es:[di].NIC_ECB_S.src_node+4, ax
	je	done_valid

@@:	add	bx, 6			; BX -> next match node value
	loop	check_ors

; *
; * Now check the sockets
; *
	mov	cx, Match_Socket_Count	; CX = number of sockets
	jcxz	done_invalid		; Quit with invalid set
	jmp	is30_valid

is_packet_valid endp


; *************************************************************************************************
; *
; *	void far *FARSET( void far *ES:DI, char AL, unsigned int CX )
; *	Sets a buffer to bytes of VALUE
; *
; *	Given:
; *		ES:DI -> buffer to set
; *		AL = byte to set the buffer to
; *		CX = number of bytes to do
; *
; *	Returns:
; *		ES:BX -> buffer
; *
; *	Note:
; *		This function assumes that the buffers in question will start on even boundaries
; *		because they all deal with allocated far memory buffers
; *		It also assumes that the buffer resides within one 64K segment
; *
; *************************************************************************************************
farset proc

	mov	bx, di			; Return pointer in ES:BX

	mov	ah, al
	shr	cx, 1			; CX = number of words to set
	rep	stosw
	adc	cx, cx
	rep	stosb

	ret

farset endp


; *************************************************************************************************
; *
; *	void ATOADDR( char FAR *ES:DI, char FAR *DX:SI )
; *	Converts an ASCII string into an IPX/SPX node address
; *
; *	Given:
; *		ES:DI -> IPX/SPX 6-byte node address 
; *		DX:SI -> ASCII string to convert, assumed to be 6 bytes or end with a 0
; *
; *	Returns:
; *		ASCII string converted into a node address
; *
; *	Note:
; *		This function was written for those of you who have a need for speed.
; *		This does not range checking.  You must be sure of the values provided
; *		otherwise you will get bizarro binary
; *
; *************************************************************************************************
atoaddr proc uses ax cx ds

	mov	ds, dx
	mov	cx, 604h		; CH = loop counter, CL = shifter
atoaddr10:
	lodsw				; Get two digits at a time
	sub	al, '0'			; Convert to binary
	cmp	al, 10			; See if < 10
	jc	@F			; Skip if we are < 10
	and	al, 7			; Get rid of the upper
	add	al, 9			; Dwell on the lower, no matter if it is upper or lower case

@@:	sub	ah, '0'			; Convert to upper nibble
	cmp	ah, 10			; See if < 10
	jc	@F			; Skip if we are < 10
	and	ah, 7			; Get rid of the upper
	add	ah, 9			; Dwell on the lower, no matter if it is upper or lower case

@@:	shl	al, cl			; Move lower byte bits into upper nibble
	or	al, ah			; Bring on Mr. Low Nibble
	stosb				; Store them together, like peas with a STOSB
	dec	ch
	jnz	atoaddr10		; Loop if this is a National Socialist

	ret

atoaddr endp

	end

