// ------- testappl.cpp

#include <stdio.h>

#include "dflatpp.h"
#include "testappl.h"

TestAppl    *ApWnd = NULL;
ListBox     *LsWnd = NULL;
TextBox     *TxWnd = NULL;
TextBox     *EdWnd = NULL;
PushButton  *PBWnd = NULL;
CheckBox    *CBWnd = NULL;
RadioButton *RBWnd1 = NULL;
RadioButton *RBWnd2 = NULL;

extern MenuBarItem MainMenu[];
extern MenuSelection TextBoxCommand;
extern MenuSelection ListBoxCommand;
extern MenuSelection EditBoxCommand;
extern MenuSelection PushButtonCommand;
extern MenuSelection CheckBoxCommand;
extern MenuSelection RadioButtonCommand;
extern MenuSelection InsertCommand;

extern unsigned _stklen = 8192;

void main()
{
	// ------- application window
	ApWnd = new TestAppl("Testing D-Flat++", MainMenu);
	ApWnd->SetAttribute(SIZEABLE | MOVEABLE);
	ApWnd->BuildInsertMode();
	// ---- initiate processing
	while (desktop.DispatchEvents())
		;
	delete ApWnd;
	delete LsWnd;
	delete TxWnd;
	delete EdWnd;
	delete PBWnd;
	delete CBWnd;
	delete RBWnd1;
	delete RBWnd2;
}

void TestAppl::BuildListBox()
{
	ListBoxCommand.Disable();
	// --------- build a listbox
	LsWnd = new ListBox("Listbox 1", 23, 7, 10, 20, ApWnd);
	LsWnd->SetAttribute(BORDER |
						CONTROLBOX |
						MINBOX |
						MAXBOX |
						MOVEABLE | SIZEABLE |
						SHADOW | VSCROLLBAR);
	char *le = "List Entry #  ";
	for (int i = 0; i < 100; i++)	{
		sprintf(le+12, "%d", i+1);
		LsWnd->AddText(le);
	}
	LsWnd->SetFocus();
}

void TestAppl::BuildTextBox()
{
	TextBoxCommand.Disable();
	// ------- build a textbox
	TxWnd = new TextBox("Textbox", 20, 10, 12, 45, ApWnd);
	TxWnd->SetAttribute( BORDER | CONTROLBOX |
						MINBOX | MAXBOX | MOVEABLE |
						SIZEABLE | SHADOW | HSCROLLBAR | VSCROLLBAR);
	TxWnd->Show();
	TxWnd->AddText("Now is the time for all good men");
	TxWnd->AddText("to come to the aid of their party");
	TxWnd->AddText("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
	TxWnd->AddText("bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb");
	TxWnd->AddText("cccccccccccccccccccccccccccccccccccccccc");
	TxWnd->AddText("dddddddddddddddddddddddddddddddddddddddd");
	TxWnd->AddText("eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee");
	TxWnd->AddText("ffffffffffffffffffffffffffffffffffffffff");
	TxWnd->AddText("gggggggggggggggggggggggggggggggggggggggg");
	TxWnd->AddText("hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh");
	TxWnd->AddText("iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii");
	TxWnd->AddText("jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj");
	TxWnd->AddText("kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk");
	TxWnd->AddText("llllllllllllllllllllllllllllllllllllllll");
	TxWnd->AddText("mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm");
	TxWnd->AddText("nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn");
	TxWnd->AddText("oooooooooooooooooooooooooooooooooooooooo");
	TxWnd->AddText("pppppppppppppppppppppppppppppppppppppppp");
	TxWnd->AddText("qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq");
	TxWnd->AddText("rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr");
	TxWnd->AddText("ssssssssssssssssssssssssssssssssssssssss");
	TxWnd->AddText("tttttttttttttttttttttttttttttttttttttttt");
	TxWnd->AddText("uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu");
	TxWnd->SetFocus();
}

void TestAppl::BuildEditBox()
{
	EditBoxCommand.Disable();
	// ------- build an editbox
	EdWnd = new EditBox("Editbox", 5, 15, 3, 20, ApWnd);
	EdWnd->SetAttribute( BORDER | CONTROLBOX |
						MINBOX | MOVEABLE |
						SIZEABLE | SHADOW );
	EdWnd->SetFocus();
}

void TestAppl::BuildPushButton()
{
	PushButtonCommand.Disable();
	// ------- build a pushbutton
	PBWnd = new PushButton("~Test Button", 5, 15, ApWnd);
	PBWnd->SetAttribute( SHADOW );
	PBWnd->SetButtonFunction(this, APWND::ButtonPushed);
	PBWnd->SetFocus();
}

void TestAppl::ButtonPushed()
{
	desktop.speaker().Beep();
}

void TestAppl::BuildCheckBox()
{
	CheckBoxCommand.Disable();
	// ------- build a check box
	CBWnd = new CheckBox("~Check Box", 5, 17, ApWnd);
	CBWnd->SetFocus();
}

void TestAppl::BuildRadioButton()
{
	RadioButtonCommand.Disable();
	// ------- build a check box
	RBWnd1 = new RadioButton("Radio Button ~1", 5, 19, ApWnd);
	RBWnd2 = new RadioButton("Radio Button ~2", 5, 20, ApWnd);
	RBWnd1->SetFocus();
	RBWnd2->Show();
	RBWnd1->PushRadioButton();
}

void TestAppl::BuildInsertMode()
{
	if (InsertCommand.isToggled())
		desktop.keyboard().SetInsertMode();
	else 
		desktop.keyboard().ClearInsertMode();
}

void TestAppl::Exit()
{
	ApWnd->CloseWindow();
}


