// ------------ applicat.cpp

#include "dflatpp.h"

void Application::OpenWindow(MenuBarItem *menu)
{
    extern DeskTop desktop;
    desktop.SetApplication(this);
    windowtype = ApplicationWindow;
    if (windowstate == CLOSED)
        DFWindow::OpenWindow();
    SetAttribute(BORDER | SAVESELF | CONTROLBOX | STATUSBAR);
    SetColors();
    if (menu != NULL)       {
        SetAttribute(MENUBAR);
        menubar = new MenuBar(menu, this);
    }
    else
        menubar = NULL;
    statusbar = new StatusBar(this);
    desktop.mouse().Show();
    DFWindow::SetFocus();
    takingfocus = False;
}

void Application::CloseWindow()
{
    if (menubar != NULL)
        delete menubar;
    if (statusbar != NULL)
        delete statusbar;
    desktop.SetApplication(NULL);
    DFWindow::CloseWindow();
}

// -------- set the fg/bg colors for the window 
void Application::SetColors()
{
    colors.fg = 
    colors.sfg = 
    colors.ffg = 
    colors.hfg = LIGHTGRAY;
    colors.bg = 
    colors.sbg = 
    colors.fbg = 
    colors.hbg = BLUE;
}

void Application::AdjustBorders()
{
    DFWindow::AdjustBorders();
    if (attrib & MENUBAR)
        TopBorderAdj++;
    if (attrib & STATUSBAR)
        BottomBorderAdj = 1;
}

Bool Application::SetFocus()
{
    takingfocus = True;
    DFWindow::SetFocus();
    takingfocus = False;
    return True;
}

void Application::Show()
{
    if (!takingfocus || !isVisible())
        DFWindow::Show();
    else
        Border();
}

void Application::Keyboard(int key)
{
    switch (key)    {
        case CTRL_F4:
        case ALT_F4:
            CloseWindow();
            break;
        default:
            // ---- forward unprocessed keys to the menubar
            if (menubar != NULL)
                menubar->Keyboard(key);
            break;
    }
}

void Application::ClockTick()
{
    if (statusbar != NULL)
        statusbar->ClockTick();
}

void Application::StatusMessage(String& Msg)
{
    if (statusbar != NULL)
        statusbar->StatusMessage(Msg);
}

