/****************************************************************************/
/*                                UNPACK.C                                  */
/* by James Sylvester -- From DDJ for February 1993 -- Last Updated 9/22/92 */
/****************************************************************************/

#include <stdio.h>


void main(int argc, char *argv[])
{
  const blockfactor = 1;              /* adjust as desired */
  const blocksize = blockfactor * 8;
  char  buffer [257] [8];             /* enter blocksize for second index */

  int   i, j;
  FILE  *sf, *tf;        /* sourcefile & targetfile respectively */
  int   bestblock = -1;  /* best matching block in buffer */
  int   changeindex;


/* Verify and perform error handling for opening both the input file   */
/* and the output file as binary files.  Note, the input file contains */
/* the encoded/compressed data and the output file should contain an   */
/* exact copy of the original data.                                    */

  if (argc != 3)
  {
    printf("Correct usage is  >unpack source_filename target_filename\n");
    exit(1);
  }
  if ((sf = fopen(argv[1], "rb"))==NULL)  /* read only mode for input file */
  {
    printf("Unable to open source file %s\n", argv[1]);
    exit(2);
  }
  if ((tf = fopen(argv[2], "wb"))==NULL)  /* write only mode for output file */
  {
    printf("Unable to open target file %s\n", argv[2]);
    exit(3);
  }


/* Initialize buffer with exactly the same information as done */
/* in the PACK.C program.                                      */

  for (i = 0; i < 256; i++)
    for (j = 0; j < blocksize; j++)
      buffer [i] [j] = i;


/* Reconstruct original data from encoded data in sourcefile. */

  while (1)  /* while true ==> stay in loop until internal exit */
  {
    if (bestblock == -1)     /* input data yet to be loaded */
    {
      bestblock = getc(sf);
      if (bestblock == EOF)  /* original and encoded files had 0 bytes */
      {
        printf("%s now contains reconstructed original data!\n", argv[2]);
        exit(4);
      }
      changeindex = getc(sf);
    }
    else
    {
      bestblock = getc(sf);
      if (bestblock == EOF)    /* input data ended with previous full block */
      {
        for (j = 0; j < blocksize; j++)  /* output full block */
          putc(buffer [256] [j], tf);
        printf("%s now contains reconstructed original data!\n", argv[2]);
        exit(5);
      }
      changeindex = getc(sf);
      if (changeindex == EOF)  /* input data ended with unfull block */
      {
        for (j = 0; j < bestblock; j++)  /* reinterpret bestblock as  */
                                         /* last blocksize and output */
                                         /* this last, partial block  */
          putc(buffer [256] [j], tf);
        printf("%s now contains reconstructed original data!\n", argv[2]);
        exit(6);
      }
      for (j = 0; j < blocksize; j++)  /* output full block */
        putc(buffer [256] [j], tf);
    }
    for (i = 0; i < blockfactor; i++)
    {
      if (i > 0)
        changeindex = getc(sf);
      for (j = i*8; j < i*8+8; j++)
      {
        if (changeindex % 2 == 1)
          buffer [bestblock] [j] = getc(sf);  /* directly load changes */
                                              /* into buffer bestblock */
        changeindex /= 2;
        buffer [256] [j] = buffer [bestblock] [j];  /* copy block info */
      }
    }
  }
}