/* V592X480.H */

#define SCREEN_SEGMENT 0xA000
#define SCREEN_HEIGHT  400
#define SCREEN_WIDTH_IN_BYTES 74
#define INPUT_STATUS_1 0x3DA /* color-mode address of Input Status 1
																register */
/* The page start addresses must be even multiples of 256, because page
flipping is performed by changing only the upper start address byte */
#define PAGE_0_START 0x1720
#define PAGE_1_START 0x8b20
#define PAGE_0			0
#define PAGE_1			1
#define STATIC_PAGE	2
#define BLACK				0
#define BLUE				1
#define LT_RED			2
#define CYAN				3
#define RED					4
#define MAGENTA			5
#define OLIVE				6
#define PALE_YELLOW	7
#define BLUE_1			8
#define YELLOW_1		9
#define BLUE_2			10
#define YELLOW_2		11
#define DK_GRAY			12
#define YELLOW_3		13
#define LT_GRAY			14
#define YELLOW_4		15

void Set592x480(void);
void DrawObject(int page, int A[][5]);
void DrawGraph(int left, int top, int right, int bot, double *data,
									double magnitude, int length, int color, int barsize);
int DrawChar(int page, int row, int col, int color, int c);
int DrawString(int page, int row, int col, int color, char *c);
void ColorRectangle(int page, int left, int top, int right, int bot,
																														int color);
void ShiftWaveTraces(unsigned int src, unsigned int dest);
void GetDSPimage(unsigned int dest, unsigned int io_addr);
