#include "dsp_type.h"
#if DSP32
#include "dspregs.h"
#endif

.extern DECOMP, DRAWIMAG
.extern WAVEADRS, WAVELVLS, IMAGSHOW, LVLADDRS
.extern SIG_DRAW, DRAW_CNT, H_FILTER, L_FILTER
.extern RST_DATA, IM0_PTRS, IM1_PTRS, IMAGE_0
.extern STACKEND, SIGNALIN, DATA_OUT

        /*  ANALYZER
            main control program for the wavelet analyzer
            registers used: r1 r2 r3 r4 r5 r6 r8 r9
                            r11 r12 r13 r14 r15 r16 r17
            accumulators used: a0 a1 a2 a3
        */
.rsect ".bank0"
          dauc = 0x0000;  /* initialize DAU formats */
          r1e = WAVELVLS; /* point to jump address for wavelet filter size */
          r2e = SIGNALIN; /* point to approximation data storage */
          r3 = *r1++;     /* load number of levels in wavelet transform */
          r4 = 8;         /* load number of unit intervals per image */
          r1e = r1 + 2;   /* point to the unit interval count storage */
          *r1++ = r4;     /* store the unit interval count value */
          r4 = r4 - r4;   /* zero the register */
          *r1++ = r4;     /* set active image flag storage to 0 (IMAGE 0) */
          a3 = a3 - a3;   /* intial data value is zero */
#if DSP32C
          r3 = r3 - 1;    /* number of levels in wavelet transform - 1 */
          do 8, r3;       /* repeat next nine instructions r5+1 times */
#else
          r3 = r3 - 2;    /* number of levels in wavelet transform - 2 */
#endif
INITAPPX: *r1++ = r2e;   /* store base address of each approximation level */
          *r2++ = a3 = a3; /* zero storage for approximation level */
          *r2++ = a3 = a3; /* r2 ends up pointing to first location .... */
          *r2++ = a3 = a3; /* in the next approximation level */
          *r2++ = a3 = a3;
          *r2++ = a3 = a3;
          *r2++ = a3 = a3;
#if DSP32C
          nop;
          *r1++ = r2e;    /* store the next location */
          ioc = 0x40987;  /* initialize the serial I/O to the codec */
          r1e = RST_DATA; /* point to reset pointer initialization storage */
          r2e = SIG_DRAW; /* point to signal drawing data sets */
          r3 = 26;        /* integer pointer index, 4 bytes per pointer */
          r2e = r2 + 22;  /* point to bit pointer storage */
          do 3, 7;        /* perform next 4 instructions eight times */
          r4e = *r1++;    /* load initial bit pointer */
          r5e = *r1++;    /* load initial byte column pointer */
          *r2++ = r4;     /* store initial bit pointer */
          *r2++r3 = r5e;  /* store initial byte column pointer */
#else
          if (r3-- >=0) goto INITAPPX; /* repeat for all arrays */
          *r1++ = r2e;   /* store the next location */
          ioc = 0x0987;  /* initialize the serial I/O to the codec */
          r1 = RST_DATA; /* point to reset pointer initialization storage */
          r2 = SIG_DRAW; /* point to signal drawing data storage */
          r3 = 26;       /* integer pointer index, 2 bytes per pointer */
          r2 = r2 + 22;  /* point to bit pointer storage */
          r4 = 6;        /* initialize loop counter for eight loops */
INIT_PTR: r5 = *r1++;    /* load initial bit pointer */
          r6 = *r1++;    /* load initial byte column pointer */
          *r2++ = r5;    /* store initial bit pointer */
          if (r4-- >=0) goto INIT_PTR; /* repeat for all pointers */
          *r2++r3 = r6;  /* store initial byte column pointer */
#endif
          r12e = WAVEADRS; /* load pointer to filter jump address */
          r13e = STACKEND; /* load pointer to top of stack memory */
          r11e = *r12++;   /* load jump address for filter size */
          r16e = *r12++;   /* load coefficient pointer wrap back index */
          r17 = *r12++;    /* load number of levels */
          r15 = *r12;      /* load image data space size / 4 */
          r3e = IMAGE_0;   /* point to the detail level float output */
#if DSP32C
          r15 = r15 - 1;   /* number of data points minus one */
          do 0, r15;       /* repeat next instruction r15+1 times */
          *r3++ = a3 = a3; /* clear four bytes in IMAGE_0 array */
#else
          r15 = r15 - 2;   /* number of data points minus two */
CLR_IMAG: if (r15-- >=0) goto CLR_IMAG; /* repeat until all image cleared */
          *r3++ = a3 = a3; /* clear four bytes in IMAGE_0 array */
#endif
          goto ENTRY_PT;   /* jump to the entry point */
          nop;

MAINLOOP: r8 = DATA_OUT;        /* point to output data array */
          r12e = SIG_DRAW;      /* point to signal drawing data sets */
          r9e = DRAW_CNT;       /* point to draw count array */
          a0 = *r8++;           /* load first signal data point */
          r9e = r9 + r15;       /* index into draw count array */
          call DRAWIMAG (r14);  /* draw the first input sample point */
          r9l = *r9;            /* load the draw loop counter */
          r12e = SIG_DRAW;      /* point to signal drawing data sets */
DRWLOOP1: if (ibf) goto SAMPL_IN; /* if true, next sample available */
          nop;
          a0 = *r8++;           /* load data point */
          call DRAWIMAG (r14);  /* draw data point */
          nop;
          if (r9-- >= 0) goto DRWLOOP1; /* repeat for all levels of xfrm */
#if DSP32C
          nop;
#else
          r12 = r12 + 2;        /* point to data set for next level */
#endif
WAITIBF1: if (ibe) goto WAITIBF1; /* wait until next data sample arrives */
          nop;
          goto TEST_LVL;
SAMPL_IN: a3 = float(ibuf);      /* load the new signal sample */
DRWLOOP2: a0 = *r8++;            /* load data point */
          call DRAWIMAG (r14);   /* draw data point */
          nop;
          if (r9-- >= 0) goto DRWLOOP2;
#if DSP32C
          nop;
#else
          r12 = r12 + 2;         /* point to data set for next level */
#endif
TEST_LVL: r15 - 0;               /* test for process of all levels */
          if (ne) goto ENTRY_PT; /* if true, all levels have not been done */
          r12e = IMAGSHOW;       /* point to the unit interval count down */
          nop;
          r3 = *r12++;           /* load the unit interval count down */
          r4 = *r12--;           /* load the image draw flag */
          r3 = r3 - 1;           /* decrement the unit interval count */
          if (ne) goto ENTRY_PT; /* if true, not done with new data set */
          *r12++ = r3;           /* save the new count */
          r3 = 8;                /* reset count to eight unit intervals */
          r12 = r12 - 2;         /* point to unit interval count storage */
          *r12++ = r3;           /* save the reset count */
          pir = r4;              /* interrupt host processor for new image */
          r4 = r4;               /* tickle CAU flags for image set */
          if (ne) goto IM0_NEXT; /* if true, set up for drawing on IMAGE 0 */
          nop;
          r4 = 1;                /* next image displayed is IMAGE 1 */
          goto PNTRINIT;         /* go to image pointer initialization */
          r2e = IM1_PTRS;        /* set up for drawing on IMAGE 1 */

IM0_NEXT: r4 = 0;          /* next image displayed is IMAGE 0 */
          r2e = IM0_PTRS;  /* set up for drawing on IMAGE 0 */
PNTRINIT: r1 = SIG_DRAW;   /* point to signal drawing data sets */
          *r12++ = r4;     /* save the image draw flag */
          r1e = r1 + 24;   /* point to byte column pointer storage */
#if DSP32C
          r15e = 28;       /* set up post increment value */
          do 0, 7;         /* perform next instruction eight times */
          a0 = (*r1++r15 = *r2++) + a0; /* moves four bytes at once! */
#else
          r3 = 28;         /* set up post increment value */
          r4 = 6;          /* set up loop counter for eight iterations */
REINIPTR: r5 = *r2++;      /* load image array pointer */
          if (r4-- >= 0) goto REINIPTR; /* repeat for all pointers */
          *r1++r3 = r5;    /* store image array pointer */
#endif
WAIT_PIE: if (pif) goto WAIT_PIE; /* wait for pif flag to be cleared */
          nop;
ENTRY_PT: r3e = SIGNALIN;           /* point to input signal storage array */
WAITIBF2: if (ibe) goto WAITIBF2;   /* wait until next data sample arrives */
          r15 = r17;                /* inititialize the recursion counter */
          *r3++ = a2 = float(ibuf); /* output second data sample first */
          r6e = DATA_OUT;    /* point to output data array */
          *r3 = a3 = a3;     /* output first data sample last */
          *r6++ = a3 = a3;   /* place first sample in data output array */
          *r6++ = a2 = a2;   /* place second sample in data output array */
          r1e = H_FILTER;    /* point to detail filter coefficients */
          r2e = L_FILTER;    /* point to approx. filter coefficients */
          r12e = LVLADDRS;   /* point to data level address pointers */
          a0 = a0 - a0;      /* zero the accumulators */
          call DECOMP (r14); /* start the recursive decomposition */
          a1 = a0;
          goto MAINLOOP;
          nop;
