
Creation date: Fri Apr 17 11:36:20 1992	analyzer.s	page 1


Address	Instruction	Line #	Source line
			1	#include "dsp_type.h"
			1	#define DSP32 1
			2	#if DSP32
			3	#include "dspregs.h"
			1	/* dspregs.h */
			2	/* register file redefinition */
			3	#define  r1e   r1
			4	#define  r2e   r2
			5	#define  r3e   r3
			6	#define  r4e   r4
			7	#define  r5e   r5
			8	#define  r6e   r6
			9	#define  r7e   r7
			10	#define  r8e   r8
			11	#define  r9e   r9
			12	#define  r10e  r10
			13	#define  r11e  r11
			14	#define  r12e  r12
			15	#define  r13e  r13
			16	#define  r14e  r14
			17	#define  r15e  r15
			18	#define  r16e  r16
			19	#define  r17e  r17
			20	#define  r18e  r18
			21	#define  r19e  r19
			22	#define  r20e  r20
			23	#define  r21e  r21
			24	
			25	/* integer and float redefinition */
			26	#define  int24  int
			27	#define  float24  float
			4	#endif
			5	
			6	.extern DECOMP, DRAWIMAG
			7	.extern WAVEADRS, WAVELVLS, IMAGSHOW, LVLADDRS
			8	.extern SIG_DRAW, DRAW_CNT, H_FILTER, L_FILTER
			9	.extern RST_DATA, IM0_PTRS, IM1_PTRS, IMAGE_0
			10	.extern STACKEND, SIGNALIN, DATA_OUT
			11	
			12	        /*  ANALYZER
			13	            main control program for the wavelet analyzer
			14	            registers used: r1 r2 r3 r4 r5 r6 r8 r9
			15	                            r11 r12 r13 r14 r15 r16 r17
			16	            accumulators used: a0 a1 a2 a3
			17	        */
			18	.rsect ".bank0"
0000	17400000	19	          dauc = 0x0000;  /* initialize DAU formats */
0004	14200000	20	          r1e = WAVELVLS; /* point to jump address for wavelet filter size */
0008	14400000	21	          r2e = SIGNALIN; /* point to approximation data storage */
000c	1ea30037	22	          r3 = *r1++;     /* load number of levels in wavelet transform */
0010	14800008	23	          r4 = 8;         /* load number of unit intervals per image */
0014	14210002	24	          r1e = r1 + 2;   /* point to the unit interval count storage */
0018	1fa40037	25	          *r1++ = r4;     /* store the unit interval count value */
001c	18840080	26	          r4 = r4 - r4;   /* zero the register */
0020	1fa40037	27	          *r1++ = r4;     /* set active image flag storage to 0 (IMAGE 0) */
0024	34e0c187	28	          a3 = a3 - a3;   /* intial data value is zero */
			32	#else
0028	1a830002	33	          r3 = r3 - 2;    /* number of levels in wavelet transform - 2 */
			34	#endif
002c	1fa20037	35	INITAPPX: *r1++ = r2e;   /* store base address of each approximation level */


Creation date: Fri Apr 17 11:36:21 199	analyzer.s	page 2


Address	Instruction	Line #	Source line
0030	30600197	36	          *r2++ = a3 = a3; /* zero storage for approximation level */
0034	30600197	37	          *r2++ = a3 = a3; /* r2 ends up pointing to first location .... */
0038	30600197	38	          *r2++ = a3 = a3; /* in the next approximation level */
003c	30600197	39	          *r2++ = a3 = a3;
0040	30600197	40	          *r2++ = a3 = a3;
0044	30600197	41	          *r2++ = a3 = a3;
			55	#else
0048	0c60002c	56	          if (r3-- >=0) goto INITAPPX; /* repeat for all arrays */
004c	1fa20037	57	          *r1++ = r2e;   /* store the next location */
0050	17600987	58	          ioc = 0x0987;  /* initialize the serial I/O to the codec */
0054	14200000	59	          r1 = RST_DATA; /* point to reset pointer initialization storage */
0058	14400000	60	          r2 = SIG_DRAW; /* point to signal drawing data storage */
005c	1460001a	61	          r3 = 26;       /* integer pointer index, 2 bytes per pointer */
0060	14420016	62	          r2 = r2 + 22;  /* point to bit pointer storage */
0064	14800006	63	          r4 = 6;        /* initialize loop counter for eight loops */
0068	1ea50037	64	INIT_PTR: r5 = *r1++;    /* load initial bit pointer */
006c	1ea60037	65	          r6 = *r1++;    /* load initial byte column pointer */
0070	1fa50057	66	          *r2++ = r5;    /* store initial bit pointer */
0074	0c800068	67	          if (r4-- >=0) goto INIT_PTR; /* repeat for all pointers */
0078	1fa60043	68	          *r2++r3 = r6;  /* store initial byte column pointer */
			69	#endif
007c	15800000	70	          r12e = WAVEADRS; /* load pointer to filter jump address */
0080	15a00000	71	          r13e = STACKEND; /* load pointer to top of stack memory */
0084	1eab0197	72	          r11e = *r12++;   /* load jump address for filter size */
0088	1eb20197	73	          r16e = *r12++;   /* load coefficient pointer wrap back index */
008c	1eb30197	74	          r17 = *r12++;    /* load number of levels */
0090	1eb10190	75	          r15 = *r12;      /* load image data space size / 4 */
0094	14600000	76	          r3e = IMAGE_0;   /* point to the detail level float output */
			81	#else
0098	1a910002	82	          r15 = r15 - 2;   /* number of data points minus two */
009c	0e20009c	83	CLR_IMAG: if (r15-- >=0) goto CLR_IMAG; /* repeat until all image cleared */
00a0	3060019f	84	          *r3++ = a3 = a3; /* clear four bytes in IMAGE_0 array */
			85	#endif
00a4	00200188	86	          goto ENTRY_PT;   /* jump to the entry point */
00a8	00000000	87	          nop;
			88	
00ac	15000000	89	MAINLOOP: r8 = DATA_OUT;        /* point to output data array */
00b0	15800000	90	          r12e = SIG_DRAW;      /* point to signal drawing data sets */
00b4	15200000	91	          r9e = DRAW_CNT;       /* point to draw count array */
00b8	30002387	92	          a0 = *r8++;           /* load first signal data point */
00bc	18090220	93	          r9e = r9 + r15;       /* index into draw count array */
00c0	11c00000	94	          call DRAWIMAG (r14);  /* draw the first input sample point */
00c4	1e690130	95	          r9l = *r9;            /* load the draw loop counter */
00c8	15800000	96	          r12e = SIG_DRAW;      /* point to signal drawing data sets */
00cc	042000f4	97	DRWLOOP1: if (ibf) goto SAMPL_IN; /* if true, next sample available */
00d0	00000000	98	          nop;
00d4	30002387	99	          a0 = *r8++;           /* load data point */
00d8	11c00000	100	          call DRAWIMAG (r14);  /* draw data point */
00dc	00000000	101	          nop;
00e0	0d2000cc	102	          if (r9-- >= 0) goto DRWLOOP1; /* repeat for all levels of xfrm */
			105	#else
00e4	158c0002	106	          r12 = r12 + 2;        /* point to data set for next level */
			107	#endif
00e8	040000e8	108	WAITIBF1: if (ibe) goto WAITIBF1; /* wait until next data sample arrives */
00ec	00000000	109	          nop;
00f0	0020010c	110	          goto TEST_LVL;
00f4	79600207	111	SAMPL_IN: a3 = float(ibuf);      /* load the new signal sample */
00f8	30002387	112	DRWLOOP2: a0 = *r8++;            /* load data point */
00fc	11c00000	113	          call DRAWIMAG (r14);   /* draw data point */
0100	00000000	114	          nop;


Creation date: Fri Apr 17 11:36:23 199	analyzer.s	page 3


Address	Instruction	Line #	Source line
0104	0d2000f8	115	          if (r9-- >= 0) goto DRWLOOP2;
			118	#else
0108	158c0002	119	          r12 = r12 + 2;         /* point to data set for next level */
			120	#endif
010c	1af10000	121	TEST_LVL: r15 - 0;               /* test for process of all levels */
0110	00800188	122	          if (ne) goto ENTRY_PT; /* if true, all levels have not been done */
0114	15800000	123	          r12e = IMAGSHOW;       /* point to the unit interval count down */
0118	00000000	124	          nop;
011c	1ea30197	125	          r3 = *r12++;           /* load the unit interval count down */
0120	1ea40196	126	          r4 = *r12--;           /* load the image draw flag */
0124	1a830001	127	          r3 = r3 - 1;           /* decrement the unit interval count */
0128	00800188	128	          if (ne) goto ENTRY_PT; /* if true, not done with new data set */
012c	1fa30197	129	          *r12++ = r3;           /* save the new count */
0130	14600008	130	          r3 = 8;                /* reset count to eight unit intervals */
0134	1a8c0002	131	          r12 = r12 - 2;         /* point to unit interval count storage */
0138	1fa30197	132	          *r12++ = r3;           /* save the reset count */
013c	1f840016	133	          pir = r4;              /* interrupt host processor for new image */
0140	14840000	134	          r4 = r4;               /* tickle CAU flags for image set */
0144	00800158	135	          if (ne) goto IM0_NEXT; /* if true, set up for drawing on IMAGE 0 */
0148	00000000	136	          nop;
014c	14800001	137	          r4 = 1;                /* next image displayed is IMAGE 1 */
0150	00200160	138	          goto PNTRINIT;         /* go to image pointer initialization */
0154	14400000	139	          r2e = IM1_PTRS;        /* set up for drawing on IMAGE 1 */
			140	
0158	14800000	141	IM0_NEXT: r4 = 0;          /* next image displayed is IMAGE 0 */
015c	14400000	142	          r2e = IM0_PTRS;  /* set up for drawing on IMAGE 0 */
0160	14200000	143	PNTRINIT: r1 = SIG_DRAW;   /* point to signal drawing data sets */
0164	1fa40197	144	          *r12++ = r4;     /* save the image draw flag */
0168	14210018	145	          r1e = r1 + 24;   /* point to byte column pointer storage */
			150	#else
016c	1460001c	151	          r3 = 28;         /* set up post increment value */
0170	14800006	152	          r4 = 6;          /* set up loop counter for eight iterations */
0174	1ea50057	153	REINIPTR: r5 = *r2++;      /* load image array pointer */
0178	0c800174	154	          if (r4-- >= 0) goto REINIPTR; /* repeat for all pointers */
017c	1fa50023	155	          *r1++r3 = r5;    /* store image array pointer */
			156	#endif
0180	04e00180	157	WAIT_PIE: if (pif) goto WAIT_PIE; /* wait for pif flag to be cleared */
0184	00000000	158	          nop;
0188	14600000	159	ENTRY_PT: r3e = SIGNALIN;           /* point to input signal storage array */
018c	0400018c	160	WAITIBF2: if (ibe) goto WAITIBF2;   /* wait until next data sample arrives */
0190	16330000	161	          r15 = r17;                /* inititialize the recursion counter */
0194	7940021f	162	          *r3++ = a2 = float(ibuf); /* output second data sample first */
0198	14c00000	163	          r6e = DATA_OUT;    /* point to output data array */
019c	30600198	164	          *r3 = a3 = a3;     /* output first data sample last */
01a0	306001b7	165	          *r6++ = a3 = a3;   /* place first sample in data output array */
01a4	30400137	166	          *r6++ = a2 = a2;   /* place second sample in data output array */
01a8	14200000	167	          r1e = H_FILTER;    /* point to detail filter coefficients */
01ac	14400000	168	          r2e = L_FILTER;    /* point to approx. filter coefficients */
01b0	15800000	169	          r12e = LVLADDRS;   /* point to data level address pointers */
01b4	34800007	170	          a0 = a0 - a0;      /* zero the accumulators */
01b8	11c00000	171	          call DECOMP (r14); /* start the recursive decomposition */
01bc	30200007	172	          a1 = a0;
01c0	002000ac	173	          goto MAINLOOP;
01c4	00000000	174	          nop;


d3as:warning:analyzer.s line 84: Use output pointer reg only as output pointer 
		in DAU inst at dest after branch instruction
d3as:warning:analyzer.s line 95: branch dest can't start with inst referencing 
		reg being loaded



Symbol Table
.file	analyzer.s
.bank0	(section 1)	size 0x1c8
CLR_IMAG	section 1	defined	value 0x9c
TEST_LVL	section 1	defined	value 0x10c
DATA_OUT	section 255	external	value 0x0
SIGNALIN	section 255	external	value 0x0
STACKEND	section 255	external	value 0x0
IMAGSHOW	section 255	external	value 0x0
IM0_PTRS	section 255	external	value 0x0
H_FILTER	section 255	external	value 0x0
IM0_NEXT	section 1	defined	value 0x158
DECOMP	section 255	external	value 0x0
SAMPL_IN	section 1	defined	value 0xf4
WAITIBF1	section 1	defined	value 0xe8
WAVEADRS	section 255	external	value 0x0
WAITIBF2	section 1	defined	value 0x18c
REINIPTR	section 1	defined	value 0x174
RST_DATA	section 255	external	value 0x0
ENTRY_PT	section 1	defined	value 0x188
WAVELVLS	section 255	external	value 0x0
DRAWIMAG	section 255	external	value 0x0
INITAPPX	section 1	defined	value 0x2c
LVLADDRS	section 255	external	value 0x0
WAIT_PIE	section 1	defined	value 0x180
DRWLOOP1	section 1	defined	value 0xcc
DRWLOOP2	section 1	defined	value 0xf8
PNTRINIT	section 1	defined	value 0x160
IMAGE_0	section 255	external	value 0x0
MAINLOOP	section 1	defined	value 0xac
IM1_PTRS	section 255	external	value 0x0
DRAW_CNT	section 255	external	value 0x0
SIG_DRAW	section 255	external	value 0x0
INIT_PTR	section 1	defined	value 0x68
L_FILTER	section 255	external	value 0x0
