/* ANALYZER.C */

#include <dos.h>
#include <bios.h>
#include <stdlib.h>

#include "dsp_ctrl.h"
#include "v592x480.h"
#include "wave_bld.h"
#include "analyzer.h"

int CopyString(char *src_str, char *dest_str, int maxlen);
emtype StartEntry(char *src_str, char *dest_str, int top, int *cur_pos);
void main(void);


int CopyString(char *src_str, char *dest_str, int maxlen)
{
	int i;
	i = 0;
	do
	{
		dest_str[i] = src_str[i];
		i++;
	} while ((src_str[i] != '\0') && (i < maxlen));

	dest_str[i] = '\0'; /* add null to end of destination */
	return i;
}


emtype StartEntry(char *src_str, char *dest_str, int top, int *cur_pos)
{
	DrawString(STATIC_PAGE, top, 11, BLACK, src_str); /* draw current string */
	*cur_pos = CopyString(src_str, dest_str, 12);    /* make copy for editing */
	DrawChar(STATIC_PAGE, top, *cur_pos+11, BLACK, '_'); /* draw cursor */
	return START;
}


void main()
{
	tftype quit, DSPrunning, hold;
	curpos cursor_at, bottom_control;
	emtype entry_mode;
	int count, i, s, c, looking_at, cursor_pos, DSPfiltlen;
	unsigned new_image, source_page;
	unsigned long image_location;
	union REGS regset;
	double entry;
	float wavefilters[12];

	union
	{
		char c[2];
		int i;
	} key;

	/* initialize the configuration of the DSP board */
	DSPboardConfigure();

	/* download default parameters and coefficients for wavelet transform */
	SetupWaveletConstruction();
	BuildDSPfilterArray(alpha, beta, wavefilters); /* initial wavelet is DAUB4 */
	DownloadDecompCoeffs(FILTER_LENGTH_4);
	DownloadFiltCoeffs(wavefilters);

	/* download initial image scalling factors */
	for (i = 0; i < 8; i++)
		DownloadTraceScale(i, trace_scale[i]);

	Set592x480(); /* set to 592x480 16-color mode */

	/* initialize screen colors for Page 0 */
	DrawObject(PAGE_0, flip_screens);
	DrawString(PAGE_0, 8, 3, BLACK, "INPUT");
	DrawString(PAGE_0, 58, 2, BLACK,  "DETAIL");
	DrawString(PAGE_0, 66, 2, BLACK,  "LEVEL 5");
	DrawString(PAGE_0, 108, 2, BLACK, "LEVEL 4");
	DrawString(PAGE_0, 158, 2, BLACK, "LEVEL 3");
	DrawString(PAGE_0, 208, 2, BLACK, "LEVEL 2");
	DrawString(PAGE_0, 258, 2, BLACK, "LEVEL 1");
	DrawString(PAGE_0, 308, 2, BLACK, "LEVEL 0");
	DrawString(PAGE_0, 358, 2, BLACK, "APPROX");
	DrawString(PAGE_0, 366, 2, BLACK, "LEVEL 0");

	/* initialize screen colors for Page 1 */
	DrawObject(PAGE_1, flip_screens);
	DrawString(PAGE_1, 8, 3, BLACK, "INPUT");
	DrawString(PAGE_1, 58, 2, BLACK,  "DETAIL");
	DrawString(PAGE_1, 66, 2, BLACK,  "LEVEL 5");
	DrawString(PAGE_1, 108, 2, BLACK, "LEVEL 4");
	DrawString(PAGE_1, 158, 2, BLACK, "LEVEL 3");
	DrawString(PAGE_1, 208, 2, BLACK, "LEVEL 2");
	DrawString(PAGE_1, 258, 2, BLACK, "LEVEL 1");
	DrawString(PAGE_1, 308, 2, BLACK, "LEVEL 0");
	DrawString(PAGE_1, 358, 2, BLACK, "APPROX");
	DrawString(PAGE_1, 366, 2, BLACK, "LEVEL 0");

	for(i = 0; i < 8; i++)
	{
		s = trace_scale[i];
		DrawString(PAGE_0, control_loc[i], 4, BLACK, trace_scale_str[s]);
		DrawString(PAGE_1, control_loc[i], 4, BLACK, trace_scale_str[s]);
		DrawChar(PAGE_0, control_loc[i], 2, BLACK, 0x10);
		DrawChar(PAGE_1, control_loc[i], 2, BLACK, 0x10);
	}

	/* initialize screen colors for Page 2 */
	DrawObject(STATIC_PAGE, static_screen);

	s = control_loc[i++];
	DrawString(STATIC_PAGE, s, 4, BLACK, "HOLD");
	DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
	s = control_loc[i++];
	DrawString(STATIC_PAGE, s, 4, BLACK, "RUN");
	DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
	s = control_loc[i++];
	DrawString(STATIC_PAGE, s, 4, BLACK, "ALPHA");
	DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
	s = control_loc[i++];
	DrawString(STATIC_PAGE, s, 4, BLACK, "BETA");
	DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
	s = control_loc[i++];
	DrawString(STATIC_PAGE, s, 4, BLACK, "QUIT");
	DrawChar(STATIC_PAGE, s, 2, RED, 0x10);

	/* initialize scaling and wavelet function windows */
	DrawObject(STATIC_PAGE, wavelet_window);
	DrawGraph(209, 5, 531, 65, PhiData + offset, magnitude, 320, OLIVE, 1);
	DrawGraph(209, 5, 531, 65, PsiData + offset, magnitude, 320, CYAN, 1);
	DrawString(STATIC_PAGE, 70, 29, BLACK, "SCALLING FUNCTION");
	DrawString(STATIC_PAGE, 70, 51, BLACK, "WAVLET FUNCTION");
	ColorRectangle(STATIC_PAGE, 215, 72, 225, 74, OLIVE);
	ColorRectangle(STATIC_PAGE, 391, 72, 401, 74, CYAN);
	DrawString(STATIC_PAGE, control_loc[ALPHA], 11, BLACK, alpha_str);
	DrawString(STATIC_PAGE, control_loc[BETA], 11, BLACK, beta_str);

	quit = FALSE;
	DSPrunning = FALSE;
	hold = FALSE;
	cursor_at = QUIT;     /* all controls are accessible */
	bottom_control = QUIT;
	looking_at = PAGE_0;
	do                    /* enter control loop */
	{
		if (bioskey(1))
		{
			key.i = bioskey(0);
			if (!key.c[0])
			{
				switch (key.c[1])
				{
					case 0x48:	/* Up Arrow */
						if (cursor_at == INPUT)  /* can't go any further */
							break;

						s = control_loc[cursor_at];
						if (cursor_at < HOLDCONT) /* turn off marker on both pages */
						{
							DrawChar(PAGE_0, s, 2, BLACK, 0x10);
							DrawChar(PAGE_1, s, 2, BLACK, 0x10);
						}
						else /* turn off marker on single page */
						{
							if (cursor_at == ALPHA) /* disable alpha entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, alpha_str);
							}
							else if (cursor_at == BETA) /* disable beta entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, beta_str);
							}

							DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
						}

						cursor_at--; /* move cursor and get vertical positioning */
						s = control_loc[cursor_at];
						if (cursor_at < HOLDCONT) /* turn on marker on both pages */
						{
							DrawChar(PAGE_0, s, 2, RED, 0x10);
							DrawChar(PAGE_1, s, 2, RED, 0x10);
						}
						else /* turn on marker for single page */
						{
							if (cursor_at == ALPHA) /* enable alpha entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s - 2, 191, s + 8, LT_GRAY);
								entry_mode = StartEntry(alpha_str, entry_str, s, &cursor_pos);
							}

							else if (cursor_at == BETA) /* enable beta entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s - 2, 191, s + 8, LT_GRAY);
								entry_mode = StartEntry(beta_str, entry_str, s, &cursor_pos);
							}

							DrawChar(STATIC_PAGE, s, 2, RED, 0x10);
						}

						break;

					case 0x49:	/* PGUP */
						s = control_loc[cursor_at];
						if (cursor_at < HOLDCONT) /* turn off marker on both pages */
						{
							DrawChar(PAGE_0, s, 2, BLACK, 0x10);
							DrawChar(PAGE_1, s, 2, BLACK, 0x10);
						}
						else /* turn off marker on single page */
						{
							if (cursor_at == ALPHA) /* disable alpha entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, alpha_str);
							}
							else if (cursor_at == BETA) /* disable beta entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, beta_str);
							}

							DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
						}

						cursor_at = INPUT; /* place cursor at top */
						DrawChar(PAGE_0, control_loc[INPUT], 2, RED, 0x10);
						DrawChar(PAGE_1, control_loc[INPUT], 2, RED, 0x10);
						break;

					case 0x4b:	/* Left Arrow */
						if ((cursor_at < HOLDCONT) && (trace_scale[cursor_at] > 0))
						{                              /* increase vertical scale */
							trace_scale[cursor_at] -= 1;
							s = trace_scale[cursor_at];
							i = control_loc[cursor_at];
							c = control_color[cursor_at];
							ColorRectangle(PAGE_0, 32, i, 71, i + 8, c);
							ColorRectangle(PAGE_1, 32, i, 71, i + 8, c);
							DrawString(PAGE_0, i, 4, BLACK, trace_scale_str[s]);
							DrawString(PAGE_1, i, 4, BLACK, trace_scale_str[s]);
							DownloadTraceScale(cursor_at, s);
						}
						break;

					case 0x4d:	/* Right Arrow */
						if ((cursor_at < HOLDCONT) && (trace_scale[cursor_at] < 9))
						{                              /* decrease vertical scale */
							trace_scale[cursor_at] += 1;
							s = trace_scale[cursor_at];
							i = control_loc[cursor_at];
							c = control_color[cursor_at];
							ColorRectangle(PAGE_0, 32, i, 71, i + 8, c);
							ColorRectangle(PAGE_1, 32, i, 71, i + 8, c);
							DrawString(PAGE_0, i, 4, BLACK, trace_scale_str[s]);
							DrawString(PAGE_1, i, 4, BLACK, trace_scale_str[s]);
							DownloadTraceScale(cursor_at, s);
						}
						break;

					case 0x50:	/* Dn Arrow */
						if (cursor_at == bottom_control)  /* can't go any further */
							break;

						s = control_loc[cursor_at];
						if (cursor_at < HOLDCONT) /* turn off marker on both pages */
						{
							DrawChar(PAGE_0, s, 2, BLACK, 0x10);
							DrawChar(PAGE_1, s, 2, BLACK, 0x10);
						}
						else /* turn off marker on single page */
						{
							if (cursor_at == ALPHA) /* disable alpha entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, alpha_str);
							}
							else if (cursor_at == BETA) /* disable beta entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, beta_str);
							}

							DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
						}

						cursor_at++; /* move cursor and get vertical positioning */
						s = control_loc[cursor_at];
						if (cursor_at < HOLDCONT) /* turn on marker on both pages */
						{
							DrawChar(PAGE_0, s, 2, RED, 0x10);
							DrawChar(PAGE_1, s, 2, RED, 0x10);
						}
						else /* turn on marker for single page */
						{
							if (cursor_at == ALPHA) /* enable alpha entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s - 2, 191, s + 8, LT_GRAY);
								entry_mode = StartEntry(alpha_str, entry_str, s, &cursor_pos);
							}
							else if (cursor_at == BETA) /* enable beta entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s - 2, 191, s + 8, LT_GRAY);
								entry_mode = StartEntry(beta_str, entry_str, s, &cursor_pos);
							}

							DrawChar(STATIC_PAGE, s, 2, RED, 0x10);
						}

						break;

					case 0x51:	/* PGDN */
						s = control_loc[cursor_at];
						if (cursor_at < HOLDCONT) /* turn off marker on both pages */
						{
							DrawChar(PAGE_0, s, 2, BLACK, 0x10);
							DrawChar(PAGE_1, s, 2, BLACK, 0x10);
						}
						else /* turn off marker on single page */
						{
							if (cursor_at == ALPHA) /* disable alpha entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, alpha_str);
							}
							else if (cursor_at == BETA) /* disable beta entry field */
							{
								ColorRectangle(STATIC_PAGE, 88, s-2, 191, s+8, PALE_YELLOW);
								DrawString(STATIC_PAGE, s, 11, BLACK, beta_str);
							}

							DrawChar(STATIC_PAGE, s, 2, BLACK, 0x10);
						}

						cursor_at = bottom_control; /* place cursor at bottom */
						DrawChar(STATIC_PAGE, control_loc[bottom_control], 2, RED, 0x10);
						break;
				}
			}
			else
			{
				switch (key.c[0])
				{
					case '1': /* number entry */
					case '2':
					case '3':
					case '4':
					case '5':
					case '6':
					case '7':
					case '8':
					case '9':
					case '0':
						if ((cursor_at == ALPHA) || (cursor_at == BETA))
						{
							s = control_loc[cursor_at];
							DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY, '_');
							if (entry_mode == START)
							{     /* first action upon entering field is typing a number */
								cursor_pos = 1;
								entry_mode = EDIT_NEW;
								DrawString(STATIC_PAGE, s, 11, LT_GRAY, entry_str);
								for (i = 0; i < 11; i++)
									entry_str[i] = ' ';
							}
							else if (cursor_pos == 12) /* end of entry field */
							{
								DrawChar(STATIC_PAGE, s, cursor_pos + 11, BLACK, '_');
								break;
							}
							else if (!cursor_pos)
							{ /* no numbers allowed as first character position in field */
								entry_str[0] = ' ';
								cursor_pos = 1;
							}

							DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY,
																							entry_str[cursor_pos]);
							entry_str[cursor_pos] = key.c[0];
							DrawChar(STATIC_PAGE, s, cursor_pos++ + 11, BLACK, key.c[0]);
							DrawChar(STATIC_PAGE, s, cursor_pos + 11, BLACK, '_');
							entry_str[cursor_pos] = '\0'; /* pad in new null */
						}
						break;

					case '-':
					case '.':
						if ((cursor_at == ALPHA) || (cursor_at == BETA))
						{
							s = control_loc[cursor_at];
							DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY, '_');
							if (entry_mode == START)
							{ /* first action upon entering field is typing a '.' or '-' */
								entry_mode = EDIT_NEW;
								DrawString(STATIC_PAGE, s, 11, LT_GRAY, entry_str);
								for (i = 0; i < 11; i++)
									entry_str[i] = ' ';

								if (key.c[0] == '.') /* insert leading '0' first */
								{
									cursor_pos = 2;
									entry_str[1] = '0';
									DrawChar(STATIC_PAGE, s, 12, BLACK, '0');
								}
								else
									cursor_pos = 0;
							}
							else if ((key.c[0] == '-') && (cursor_pos != 0))
							{
								DrawChar(STATIC_PAGE, s, cursor_pos + 11, BLACK, '_');
								break;
							}
							else if (key.c[0] == '.')
							{
								if (cursor_pos > 2)
								{               /* only allow '.' entry at position 0 or 1 */
									DrawChar(STATIC_PAGE, s, cursor_pos + 11, BLACK, '_');
									break;
								}
								else
								{
									switch (cursor_pos)
									{
										case 0: /* insert leading blank */
											DrawChar(STATIC_PAGE, s, 11, LT_GRAY, entry_str[0]);
											DrawChar(STATIC_PAGE, s, 12, BLACK, ' ');
											entry_str[0] = ' ';
										case 1: /* insert leading '0' */
											DrawChar(STATIC_PAGE, s, 12, LT_GRAY, entry_str[1]);
											DrawChar(STATIC_PAGE, s, 12, BLACK, '0');
											entry_str[1] = '0';
											cursor_pos = 2;
									}
								}
							}

							DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY,
																							entry_str[cursor_pos]);
							entry_str[cursor_pos] = key.c[0];
							DrawChar(STATIC_PAGE, s, cursor_pos++ + 11, BLACK, key.c[0]);
							DrawChar(STATIC_PAGE, s, cursor_pos + 11, BLACK, '_');
							entry_str[cursor_pos] = '\0';
						}
						break;

					case '\b': /* backspace and delete character */
						if (((cursor_at == ALPHA) || (cursor_at == BETA)) && cursor_pos)
						{
							s = control_loc[cursor_at];
							DrawChar(STATIC_PAGE, s, cursor_pos-- + 11, LT_GRAY, '_');
							DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY,
																							entry_str[cursor_pos]);
							DrawChar(STATIC_PAGE, s, cursor_pos + 11, BLACK, '_');
							entry_str[cursor_pos] = '\0';
							if (entry_mode == START)
								entry_mode = EDIT_OLD;
						}
						break;

					case '\r': /* enter key */
						switch(cursor_at)
						{
							case HOLDCONT: /* toggle HOLD and CONTINUE modes */
								if (hold)
								{
									hold = FALSE; /* resume page flipping */
									i = control_loc[cursor_at];
									DrawString(STATIC_PAGE, i, 4, PALE_YELLOW, "CONT");
									DrawString(STATIC_PAGE, i, 4, BLACK, "HOLD");
								}
								else
								{
									hold = TRUE; /* stop page flipping */
									i = control_loc[cursor_at];
									DrawString(STATIC_PAGE, i, 4, PALE_YELLOW, "HOLD");
									DrawString(STATIC_PAGE, i, 4, BLACK, "CONT");
									if (looking_at == PAGE_0)
										source_page = PAGE_0_START+0xe74;
									else
										source_page = PAGE_1_START+0xe74;
								}

								break;

							case RUNHALT: /* toggle RUN and HALT modes */
								if (DSPrunning)
								{
									HaltDSP(); /* stop real-time fast wavelet transform */
									i = control_loc[cursor_at];
									DrawString(STATIC_PAGE, i, 4, PALE_YELLOW, "HALT");
									DrawString(STATIC_PAGE, i, 4, BLACK, "RUN");

									/* restore access to ALPHA, BETA, and QUIT controls */
									i = control_loc[ALPHA];
									DrawString(STATIC_PAGE, i, 4, BLACK, "ALPHA");
									DrawChar(STATIC_PAGE, i, 2, BLACK, 0x10);

									i = control_loc[BETA];
									DrawString(STATIC_PAGE, i, 4, BLACK, "BETA");
									DrawChar(STATIC_PAGE, i, 2, BLACK, 0x10);

									i = control_loc[QUIT];
									DrawString(STATIC_PAGE, i, 4, BLACK, "QUIT");
									DrawChar(STATIC_PAGE, i, 2, BLACK, 0x10);
									bottom_control = QUIT; /* all controls accessible */
  								DSPrunning = FALSE;
								}
								else /* start real-time fast wavelet transform */
								{
									DSPrunning = TRUE;
									bottom_control = RUNHALT;
									if (looking_at == PAGE_0) /* setup for page flipping */
										source_page = PAGE_0_START+0xe74;
									else
										source_page = PAGE_1_START+0xe74;

									i = control_loc[cursor_at];
									DrawString(STATIC_PAGE, i, 4, PALE_YELLOW, "RUN");
									DrawString(STATIC_PAGE, i, 4, BLACK, "HALT");

									/* block access to ALPHA, BETA, and QUIT controls */
									i = control_loc[ALPHA];
									DrawString(STATIC_PAGE, i, 4, LT_GRAY, "ALPHA");
									DrawChar(STATIC_PAGE, i, 2, LT_GRAY, 0x10);

									i = control_loc[BETA];
									DrawString(STATIC_PAGE, i, 4, LT_GRAY, "BETA");
									DrawChar(STATIC_PAGE, i, 2, LT_GRAY, 0x10);

									i = control_loc[QUIT];
									DrawString(STATIC_PAGE, i, 4, LT_GRAY, "QUIT");
									DrawChar(STATIC_PAGE, i, 2, LT_GRAY, 0x10);
									RunDSP();
								}
								break;

							case ALPHA:
								if (cursor_pos < 2) /* some value must be available */
									break;

								entry = atof(entry_str);
								if (entry != alpha) /* take only new values */
								{
									entry_mode = START;
									i = 0;
									if ((entry > pi) || (entry < -pi)) /* rejection range */
									{
										DrawString(STATIC_PAGE, s, 11, LT_GRAY, entry_str);
										DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY, '_');
										entry_mode =
														StartEntry(alpha_str, entry_str, s, &cursor_pos);
										break; /* reinstate the original value */
									}

									alpha = entry; /* accept new value */
									CopyString(entry_str, alpha_str, 12);
									/* make new filters and functions */
									BuildDSPfilterArray(alpha, beta, wavefilters);
									switch(filtlen)
									{
										case 2:
											DSPfiltlen = FILTER_LENGTH_2;
											break;

										case 4:
											DSPfiltlen = FILTER_LENGTH_4;
											break;

										case 6:
											DSPfiltlen = FILTER_LENGTH_6;
									}

									/* download new values to DSP board */
									DownloadDecompCoeffs(DSPfiltlen);
									DownloadFiltCoeffs(wavefilters);
									DrawObject(STATIC_PAGE, wavelet_window);
									DrawGraph(209, 5, 531, 65, PhiData + offset, magnitude,
																															320, OLIVE, 1);
									DrawGraph(209, 5, 531, 65, PsiData + offset, magnitude,
																															320, CYAN, 1);
								}
								break;

							case BETA:
								if (cursor_pos < 2) /* some value must be available */
									break;

								entry = atof(entry_str);
								if (entry != beta) /* take only new values */
								{
									entry_mode = START;
									i = 0;
									if ((entry > pi) || (entry < -pi)) /* rejection range */
									{
										DrawString(STATIC_PAGE, s, 11, LT_GRAY, entry_str);
										DrawChar(STATIC_PAGE, s, cursor_pos + 11, LT_GRAY, '_');
										entry_mode =
														StartEntry(beta_str, entry_str, s, &cursor_pos);
										break; /* reinstate the original value */
									}

									beta = entry;
									CopyString(entry_str, beta_str, 12);
									/* make new filters and functions */
									BuildDSPfilterArray(alpha, beta, wavefilters);
									switch(filtlen)
									{
										case 2:
											DSPfiltlen = FILTER_LENGTH_2;
											break;

										case 4:
											DSPfiltlen = FILTER_LENGTH_4;
											break;

										case 6:
											DSPfiltlen = FILTER_LENGTH_6;
									}

									/* download new values to DSP board */
									DownloadDecompCoeffs(DSPfiltlen);
									DownloadFiltCoeffs(wavefilters);
									DrawObject(STATIC_PAGE, wavelet_window);
									DrawGraph(209, 5, 531, 65, PhiData + offset, magnitude,
																															320, OLIVE, 1);
									DrawGraph(209, 5, 531, 65, PsiData + offset, magnitude,
																															320, CYAN, 1);
								}
								break;

							case QUIT:
								quit = TRUE;
						}
						break;
				}
			}
		}

		if (DSPrunning)
		{
			count = WaitDSP(32767);    /* wait for new image to be created */
			new_image = ACKpir16bit(); /* get indicator for image location */
			switch(new_image)          /* determine location of image */
			{
				case IMAGE_0:
					image_location = _bitmap0;
					break;
				case IMAGE_1:
					image_location = _bitmap1;
					break;
				case NO_NEW_IMAGE:
					break;
				default:
					break;
			}

			if (looking_at == PAGE_0)
			{
				ShiftWaveTraces(source_page, PAGE_1_START+0xe74);
				SetDMAaddr(image_location);
				GetDSPimage(PAGE_1_START, _pdr_addr);
				source_page = PAGE_1_START+0xe74;
				/* Flip to page 1 */
				/* adjust the Start Address High register to start
					 screen display on new page */
				if(!hold)
				{
					outport(0x3D4, 0x8b0c);
					looking_at = PAGE_1;
				}
			}
			else
			{
				ShiftWaveTraces(source_page, PAGE_0_START+0xe74);
				SetDMAaddr(image_location);
				GetDSPimage(PAGE_0_START, _pdr_addr);
				source_page = PAGE_0_START+0xe74;
				/* Flip to page 0 */
				/* adjust the StartgAddress High and Start Address Low registers
					 to start screen display on page 0 */
				if(!hold)
				{
					outport(0x3D4, 0x170c);
					looking_at = PAGE_0;
				}
			}
		}
	} while (!quit);


	/* Return to text mode and exit */
	regset.x.ax = 0x0003;  /* AL = 3 selects 80x25 text mode */
	int86(0x10, &regset, &regset);
}
