// ---------- desktop.h

#ifndef DESKTOP_H
#define DESKTOP_H

#include "screen.h"
#include "cursor.h"
#include "keyboard.h"
#include "mouse.h"
#include "speaker.h"
#include "clock.h"

class DFWindow;

class DeskTop {
    DFWindow *apwnd;        // application window
    DFWindow *infocus;      // current window with the focus
    DFWindow *firstcapture; // first window to capture the focus
    DFWindow *focuscapture; // current window with captured focus
    // ------- the desktop devices
    Screen   sysscreen;     // the system screen
    Mouse    sysmouse;      // the system mouse
    Keyboard syskeyboard;   // the system keyboard
    Cursor   syscursor;     // the system cursor
    Clock    sysclock;      // the system clock
    Speaker  sysspeaker;    // the system speaker
public:
    DeskTop();
    ~DeskTop();
    DFWindow *ApplWnd() { return apwnd; }
    void SetApplication(DFWindow *ApWnd) { apwnd = ApWnd; }
    Bool DispatchEvents();
    DFWindow *InFocus()      { return infocus; }
    DFWindow *FocusCapture() { return focuscapture; }
    DFWindow *FirstCapture() { return firstcapture; }
    void SetFocus(DFWindow *wnd) { infocus = wnd; }
    void SetFocusCapture(DFWindow *wnd) { focuscapture = wnd; }
    void SetFirstCapture(DFWindow *wnd) { firstcapture = wnd; }
    // ------- the desktop devices
    Mouse&    mouse()       { return sysmouse;    }
    Screen&   screen()      { return sysscreen;   }
    Keyboard& keyboard()    { return syskeyboard; }
    Cursor&   cursor()      { return syscursor;   }
    Clock&    clock()       { return sysclock;    }
    Speaker&  speaker()     { return sysspeaker;  }
};

extern DeskTop desktop;

#endif

