/* POPWIN.I: Routines for pop-up windows                           */
/* Externally defined are gotoxy(), wrtcha(), window(), chattr(),  */
/*        and videomode().                                         */
/* Notes: Programmer is responsible for assuring that the pop-up   */
/*          defined in the POPDESCR structure is large enough to   */
/*          contain the text.                                      */
/*        Save your cursor position before calling these routines. */
/*          They don't preserve or restore caller's cursor.        */
/*        Unlike menubar, the POPDESCR structure doesn't contain a */
/*          pointer to the text elements. Thus, you can use the    */
/*          routines to create dialog boxes and help windows.      */
/* --------------------------------------------------------------- */
typedef struct {            /* window descriptor/control structure */
  int   left, top, right, bottom;    /* window location, inclusive */
  char  textAttr;                      /* text attribute in window */
  int   border;                /* 0 = none, 1 = single, 2 = double */
} POPDESCR;
 
static bord[][6] = {                          /* border characters */
           { 196, 179, 218, 191, 217, 192 },
           { 205, 186, 201, 187, 188, 200 }
};
 
void popMake (POPDESCR *win)               /* create pop-up window */
/* Must initialize the POPDESCR structure before calling.          */
/* Does not write text to the window, but only creates it. After   */
/*   this fcn returns, you can write text using popPuts() and      */
/*   control the cursor with popxy(), both given below.            */
{
int  x, y, style, a;
 
  a = win->textAttr;
  window (win->left, win->top, win->right, win->bottom,
          win->textAttr);                           /* open window */
  if ((style = win->border-1) >= 0)       { /* draw border outside */
    gotoxy (win->left-1, win->top-1, 0);
    wrtcha (bord [style][2], a, 0);         /* corners: upper left */
    gotoxy (win->right+1, win->top-1, 0);
    wrtcha (bord [style][3], a, 0);                 /* upper right */
    gotoxy (win->right+1, win->bottom+1, 0);
    wrtcha (bord [style][4], a, 0);                 /* lower right */
    gotoxy (win->left-1, win->bottom+1, 0);
    wrtcha (bord [style][5], a, 0);                  /* lower left */
    for (x = win->left; x <= win->right; x++) {     /* horizontals */
      gotoxy (x, win->top-1, 0);
      wrtcha (bord [style][0], a, 0);
      gotoxy (x, win->bottom+1, 0);
      wrtcha (bord [style][0], a, 0);
    }
    for (y = win->top; y <= win->bottom; y++) {       /* verticals */
      gotoxy (win->left-1, y, 0);
      wrtcha (bord [style][1], a, 0);
      gotoxy (win->right+1, y, 0);
      wrtcha (bord [style][1], a, 0);
    }
  }
  gotoxy (win->left, win->top, 0);
} /* ------------------------ */
void popScroll (POPDESCR *win)           /* scroll pop up one line */
{
  winScroll (win->left, win->top, win->right, win->bottom,
             win->textAttr);
  gotoxy (wherex (0), wherey (0) - 1, 0);
} /* ------------------------ */
void popxy (int x, int y, POPDESCR *w)  /* gotoxy for popup window */
/* Allows you to express text coordinates relative to upper left   */
/* corner of the window in video page 0                            */
{
int  row, col;
 
  row = w->top + y;
  col = w->left + x;
  gotoxy (col, row, 0);
} /* ------------------------ */
void popPuts (int x, int y, char string[],      /* write string to */
              POPDESCR *win)                   /* specified window */
{
int   len, ch, p;
 
  popxy (x, y, win);                  /* position cursor in window */
  len = strlen (string);
  for (ch = 0; ch < len; ch++) {
    if (string [ch] == '\n') {                   /* handle newline */
      x = 0;
      ++y;
      popxy (x, y, win);
      if ((y + win->top) > win->bottom) {    /* scroll if required */
        popScroll (win);
        --y;
      }
    } else {
        if ((x + win->left) > win->right) {      /* outside window */
          x = 0;                                 /* so wrap cursor */
          ++y;
          popxy (x, y, win);
          if ((y + win->top) > win->bottom){ /* scroll if required */
            popScroll (win);
            --y;
          }
        }
        wrtcha (string [ch], win->textAttr, 0); /* write next char */
        ++x;
        popxy (x, y, win);                       /* advance cursor */
    }
  }
} /* ------------------------ */
char *saveScrn (void)                        /* saves screen image */
/* Call this routine before popMake(). It saves the current screen */
/*  image at a location pointed to by the returned value. You must */
/*  pass the same pointer back to restScrn() later in order to     */
/*  make the pop-up go away.                                       */
{
int      c;
unsigned srcSeg;
char     *saveArea;
 
  saveArea = (char *) malloc (4096);             /* allocate space */
  if (videomode (&c) == 7)
    srcSeg = 0xB000;                         /* &monochrome buffer */
  else
    srcSeg = 0xB800;                      /* &text graphics buffer */
  movedata (srcSeg, 0, _SS, (unsigned) saveArea, 4096);    /* save */
  return (saveArea);                             /* return pointer */
} /* ------------------------ */
void restScrn (char *saveArea)            /* restores screen image */
/* Call this routine when you want the pop up window to go away.   */
/* It restores the screen to its appearance before the window. It  */
/*   does NOT restore the cursor. That is your responsibility.     */
/* This routine does not worry about snow on IBM's poorly designed */
/*   CGA board. Snow may result when restoring the screen.         */
{
int      c;
unsigned destSeg;
 
  if (videomode (&c) == 7)
    destSeg = 0xB000;                        /* &monochrome buffer */
  else
    destSeg = 0xB800;                      /* text graphics buffer */
  movedata (_SS,(unsigned) saveArea, destSeg, 0, 4096); /* restore */
  free (saveArea);                            /* de-allocate space */
} /* ------------------------ */
 
 
