/* MENUBAR.I: Constructs a menu bar per MENUBARSPEC structure      */
/* Externally defined are activepage(), videomode(), wrtstra()     */
/* Notes: Preserve your cursor position before calling this fcn.   */
/*          It does not save or restore caller's cursor.           */
/*        The 'sel' pointer points to a solid string of menu       */
/*          selections in the form "sel1\0sel2\0sel3\0...seln\0"   */
/* --------------------------------------------------------------- */
typedef struct {
  int      background, foreground;      /* colors used in menu bar */
  int      nsels;                          /* number of selections */
  char     *sel;       /* pointer to static selections (see above) */
} MENUBARSPEC;                 /* caller sets up as many as needed */
                     /* does not remember previous cursor position */
 
void menubar (MENUBARSPEC *spec)
{
int   p, i, ncols, start, interval, page;
char  attr;
 
  page = activepage ();                         /* get active page */
  videomode (&ncols);                          /* get screen width */
  gotoxy (0, 0, page);                                  /* go home */
  attr = chattr(spec->foreground, spec->background); /* attributes */
  for (p = 0; p < (ncols-1); p++) {
    wrtcha (' ', attr, page);                    /* blank menu bar */
    gotoxy (wherex (page)+1, 0, page);                  /* advance */
  }
  interval = ncols / spec->nsels;       /* spacing between entries */
  start = i = 0;
  for (p = 0; p < spec->nsels; p++) {          /* write selections */
    gotoxy (start, 0, page);                       /* place cursor */
    wrtstra (&(spec->sel[i]), attr, page);
    i += strlen (&(spec->sel[i])) + 1;         /* find next string */
    start += interval;                  /* next position for entry */
  }
}
