#include <stdio.h>                                                                           
#include <stdlib.h>                                                                          
#include <string.h>                                                                          
                                                                                             
#include "loc.h"                                                                             
#include "externs.h"                                                                         
                                                                                             
int   process_class_keyword(), process_order_keyword(), process_null() ;                     
int   process_rom_keyword(), process_dup_keyword(), process_comment() ;                      
                                                                                             
                                                                                             
static   struct   CFG_COMMANDS   {                                                           
         char  *cmd ;                                                                        
         int   (*command)() ;                                                                
      }  cfg_cmds[] = {                                                                      
            "CLASS",    process_class_keyword,                                               
            "ORDER",    process_order_keyword,                                               
            "ROM",      process_rom_keyword,                                                 
            "DUP",      process_dup_keyword,                                                 
            ";",        process_comment                                                      
         } ;                                                                                 
                                                                                             
                                                                                             
int   process_locate_file(seg_list)                                                          
SEG_DESCRIPTOR *seg_list ;                                                                   
{                                                                                            
   int   i, error = OK;                                                                      
   char  *tok, *buf ;                                                                        
                                                                                             
   /*                                                                                        
      This function reads the configuration file and performs the parsing                    
      and control transfer to routines which perform the desired action.                     
   */                                                                                        
                                                                                             
   /* Allocate some memory for the line buffer */                                            
   if ((buf = malloc(256)) == NULL)   {                                                      
      perror(__FILE__) ;                                                                     
      exit(1) ;                                                                              
   }                                                                                         
                                                                                             
   /* Read and categorize a token from the configuration file */                             
   while (fgets(buf, 256, config_file) != NULL)   {                                          
      /* Extract the first token (read the next line if none is found */                     
      if ((tok = strtok(buf, " \t\n")) == NULL)                                              
         continue ;                                                                          
                                                                                             
      for (i = 0; i < dim(cfg_cmds); i++)   {                                                
         if (stricmp(cfg_cmds[i].cmd, tok) == 0)   {                                         
            error = (*cfg_cmds[i].command)() ;                                               
            break ;                                                                          
         }                                                                                   
      }                                                                                      
                                                                                             
      if (i == dim(cfg_cmds))   {                                                            
         fprintf(stderr, "Illegal input - <%s>\n", tok) ;                                    
         exit(1) ;                                                                           
      }                                                                                      
   }                                                                                         
   free(buf) ;                                                                               
   return   error ;                                                                          
}                                                                                            
                                                                                             
                                                                                             
int   process_comment()                                                                      
{                                                                                            
   return   OK ;                                                                             
}                                                                                            
                                                                                             
                                                                                             
int   process_class_keyword()                                                                
{                                                                                            
   char  *tok, name[32], *p ;                                                                
   unsigned int   seg ;                                                                      
                                                                                             
   /*                                                                                        
      This function parses the remainder of the CLASS directive.                             
   */                                                                                        
                                                                                             
   /* Read the class name */                                                                 
   strcpy(name, strupr(strtok(NULL, " \t\n="))) ;                                            
                                                                                             
   /* Verify that an equal sign is present */                                                
   if (strcmp((tok = strtok(NULL, " \t\n")), "=") != 0)   {                                  
      fprintf(stderr, "\"=\" expected instead found <%s>\n", tok) ;                          
      return   ERROR ;                                                                       
   }                                                                                         
                                                                                             
   /* Read the segment number for the class */                                               
   tok = strtok(NULL, " \t\n") ;                                                             
   seg = (unsigned int) strtol(tok, &p, 0) ;                                                 
   if (*p)   {                                                                               
      fprintf(stderr, "Unrecognized token <%s>\n", p) ;                                      
      return   ERROR ;                                                                       
   }                                                                                         
                                                                                             
   /* Assign the physical segment number to the specified class */                           
   if (assign_physical_segment(name, seg) == ERROR)   {                                      
      fprintf(stderr, "Undefined class <%s>\n", name);                                       
      return   ERROR;                                                                        
   }                                                                                         
                                                                                             
   return   OK ;                                                                             
}                                                                                            
                                                                                             
                                                                                             
int   process_order_keyword()                                                                
{                                                                                            
   char  *tok, pclass[32], class[32] ;                                                       
   unsigned int   next_seg ;                                                                 
   BOOLEAN  found = FALSE ;                                                                  
                                                                                             
                                                                                             
   /*                                                                                        
      This function processes the ORDER directive.                                           
   */                                                                                        
                                                                                             
   /* Read the leading class name from the command */                                        
   strcpy(pclass, strupr((tok = strtok(NULL, " \t\n")))) ;                                   
                                                                                             
   /* Process the remaining class names in the command */                                    
   while ((tok = strtok(NULL, " \t\n")) != NULL)   {                                         
      if (*tok == ';')                                                                       
         break ;                                                                             
                                                                                             
      found = TRUE ;                                                                         
      strcpy(class, strupr(tok)) ;                                                           
                                                                                             
      /* Compute the segment address for this class to be made                               
         contiguous with the previous class */                                               
      if (get_next_segment(pclass, class, &next_seg) == ERROR)   {                           
         fprintf(stderr, "Undefined class <%s>\n", pclass) ;                                 
         return   ERROR ;                                                                    
      }                                                                                      
                                                                                             
      /* Assign the computed segment number to the class */                                  
      if (assign_physical_segment(class, next_seg) == ERROR)   {                             
         fprintf(stderr, "Undefined class <%s>\n", class) ;                                  
         return   ERROR ;                                                                    
      }                                                                                      
                                                                                             
      /* Setup to process the next class */                                                  
      strcpy(pclass, class) ;                                                                
   }                                                                                         
                                                                                             
   return   (found == FALSE) ? ERROR : OK ;                                                  
}                                                                                            
                                                                                             
                                                                                             
int   process_dup_keyword()                                                                  
{                                                                                            
   char  *tok, old_class[32], new_class[32] ;                                                
                                                                                             
                                                                                             
   /*                                                                                        
      This function is responsible for processing the DUP directive.                         
   */                                                                                        
                                                                                             
   /* Read the existing class name */                                                        
   strcpy(old_class, strupr((tok = strtok(NULL, " \t\n")))) ;                                
                                                                                             
   /* Read the name of the class to be created */                                            
   strcpy(new_class, strupr((tok = strtok(NULL, " \t\n")))) ;                                
                                                                                             
   /* Duplicate the existing class */                                                        
   if (dup_class(old_class, new_class) == ERROR)   {                                         
      fprintf(stderr, "Undefined class <%s>\n", old_class);                                  
      return   ERROR ;                                                                       
   }                                                                                         
                                                                                             
   return   OK ;                                                                             
}                                                                                            
                                                                                             
                                                                                             
int   process_rom_keyword()                                                                  
{                                                                                            
   char  *tok, class[32] ;                                                                   
                                                                                             
   /*                                                                                        
      This function processes the ROM keyword and marks all specified                        
      classes as ROMable.                                                                    
   */                                                                                        
                                                                                             
   /* Read all of the tokens on the line */                                                  
   while ((tok = strtok(NULL, " \t\n")) != NULL)   {                                         
      if (*tok == ';')                                                                       
         break ;                                                                             
                                                                                             
      strcpy(class, strupr(tok)) ;                                                           
                                                                                             
      if (rom_class(class) == ERROR)   {                                                     
         fprintf(stderr, "Undefined class <%s>\n", class) ;                                  
         return   ERROR ;                                                                    
      }                                                                                      
   }                                                                                         
                                                                                             
   return   OK ;                                                                             
}                                                                                            