/* -*- Mode: C -*- */
/* PrintCards.cc - Main program
 * Created by Robert Heller on Tue Feb 25 18:53:40 1992
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Print card records from a librarian data file
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <stream.h>
#include <ctype.h>
#include <vBTree.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#include <PTree.h>
#define VERSION "V1.0Beta"
#ifdef MESSYDOS
#include "PrtCards.h"
#else
#include "PrintCards.h"
#endif

extern Tree* ParseOnly(char*);
extern Boolean EvalExpr(Card*, Tree*);
static Boolean Large_P = false;
static vBTree *lTree;
static Tree* onlyexpr = 0;

void PrintCardRecord3x5(CoreItem* item,int level,char* heading)
{
	int column;
	int lines = 0;
	cout << item->key;
	for(int space = ((50-strlen(heading))/2) - strlen(item->key);space > 0;space--) cout << ' ';
	cout << heading << "\n\n";
	if (item->data.size <= 0) {
		cout << "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	} else {
		CardRecord rec(&item->data);
		register Card *c = &rec;
		char* tn = TypeName(c->type);
		cout << c->author << ", " << c->year << "\n";
		cout << "    " << c->title << "\n";
		cout << "    " << tn << "\n";
		cout << "    Published by " << c->publisher <<
			" " << c->city << "\n";
		if (c->vol != 0) cout << "    Volume: " << c->vol;
		cout << "\n\n"; column = 0;
		for (char* p = c->description; lines < 10 && *p != 0; p++) {
			if (*p != '\n' && column < 4) {
				cout << "    ";
				column = 4;
			}
			if (*p == '\n') {
				cout << "\n";
				lines++;
				column = 0;
			} else if (column > 48) {
				cout << "\\\n";
				lines++;
				column = 0;
				p--;
			} else if (*p == '\t') {
				do {
					cout << " ";
					column++;
				} while ((column % 8) != 0);
			} else {
				cout << *p;
				column++;
			}
		}
		if (column > 0) {
			cout << "\n";
			lines++;
		}
		while (lines++ < 10) cout << "\n";
	}
}

void PrintCardRecord5x8(CoreItem* item,int level,char* heading)
{
	int column;
	int lines = 0;
	cout << item->key;
	for(int space = ((80-strlen(heading))/2) - strlen(item->key);space > 0;space--) cout << ' ';
	cout << heading << "\n\n";
	if (item->data.size <= 0) {
		cout << "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
	} else {
		CardRecord rec(&item->data);
		register Card *c = &rec;
		char* tn = TypeName(c->type);
		cout << c->author << ", " << c->year << "\n";
		cout << "    " << c->title << "\n";
		cout << "    " << tn << "\n";
		cout << "    Published by " << c->publisher <<
			" " << c->city << "\n";
		if (c->vol != 0) cout << "    Volume: " << c->vol;
		cout << "\n\n"; column = 0;
		for (char* p = c->description; lines < 22 && *p != 0; p++) {
			if (*p != '\n' && column < 4) {
				cout << "    ";
				column = 4;
			}
			if (*p == '\n') {
				cout << "\n";
				lines++;
				column = 0;
			} else if (column > 78) {
				cout << "\\\n";
				lines++;
				column = 0;
				p--;
			} else if (*p == '\t') {
				do {
					cout << " ";
					column++;
				} while ((column % 8) != 0);
			} else {
				cout << *p;
				column++;
			}
		}
		if (column > 0) {
			cout << "\n";
			lines++;
		}
		while (lines++ < 22) cout << "\n";
	}
}

void PrintCardRecord1(CoreItem* item,int level,char* heading)
{
	if (item->data.size <= 0) return;
	if (onlyexpr != 0) {
		CardRecord rec(&item->data);
		register Card* c = &rec;
		if (!EvalExpr(c,onlyexpr)) return;
	}
	if (Large_P) PrintCardRecord5x8(item,level,heading);
	else PrintCardRecord3x5(item,level,heading);
}

void PrintCardRecord(CoreItem* item,int level)
{
	PrintCardRecord1(item,level,"Shelf List");
}

static Boolean strequ(char* a,char* b)
{
	Boolean eqp;
	char aa, bb;
	do {
		aa = *a++;
		bb = *b++;
		if (islower(aa)) aa = toupper(aa);
		if (islower(bb)) bb = toupper(bb);
		eqp = aa == bb;
	} while (eqp && aa != 0 && bb != 0);
	return(eqp);
}

void PrintListRecord(CoreItem *item,int level)
{
	if (item->data.size > 0) {
		ListRecord rec(&item->data);
		int numitems = rec.ElementCount();
		static CoreItem temp;
		for (int i = 0;i < numitems; i++) {
			if (lTree->SearchId(rec[i],&temp) &&
			    strlen(rec[i]) == strlen(temp.key)) 
			    	PrintCardRecord1(&temp,level,item->key);
		}
	}
}

static void ErrorHandler(ErrKind err,char* msg)
{
	if (err == sysErr) {
		int error = errno;
		cerr << form("Error: System:%d %s %s\n",error,strerror(error),
				msg);
	} else {
		cerr << form("Error: %s %s\n",
			(err == termErr ? "Terminal" : "Memory"),
			msg);
	}
}
	
int main(int argc,char **argv)
{
	PrintCards args(argc,argv);
	vBTree vtree(args.infile,(OpenMode)(ReadOnly));
	if (vtree.OpenStat() == failure) {
		int error = errno;
		cerr << "Could not open " << args.infile
		     << ": " << strerror(error) << "\n";
		exit(error);
	}
	vtree.ErrorFun() = ErrorHandler;
	if (args.largep_passed) Large_P = args.largep;
	lTree = &vtree;
	
	if (args.only_passed) {
		onlyexpr = ParseOnly(args.only);
		if (onlyexpr == 0) exit(1);
	}
			
	if (args.by_passed) {
		if (strequ(args.by,"ID")) vtree.TraverseId(PrintCardRecord);
		else if (strequ(args.by,"TITLE")) vtree.TraverseTitle(PrintListRecord);
		else if (strequ(args.by,"AUTHOR")) vtree.TraverseAuthor(PrintListRecord);
		else if (strequ(args.by,"SUBJECT")) vtree.TraverseSubj(PrintListRecord);
		else {
			cout << "Bad -by value: " << args.by << "\n";
			args.Usage();
			exit(1);
		}
	} else vtree.TraverseId(PrintCardRecord);
}

	

