/* -*- Mode: C -*- */
/* CommandScreen.cc - CommandScreen class - command menu loop
 * Created by Robert Heller on Wed Dec 11 19:40:03 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#ifdef MESSYDOS
#include <cmdscren.h>
#else
#include <CommandScreen.h>
#endif

void CommandScreen::HiliteCommand(int command,Boolean hilite)
{
	int lineo = CommandSpecs[command-1].LineNumber;
	Terminal::term->PenPos(lineo,1);
	if (hilite) Terminal::term->RevsPen();
	else Terminal::term->PlainPen();
	Terminal::term->PutStrAt(lineo,1,CommandSpecs[command-1].Text);
	if (!hilite) Terminal::term->RevsPen();
	else Terminal::term->PlainPen();
	Terminal::term->PenPos(lineo,1);
}

CommandScreen::CommandScreen(const char* title,int numcommands,
			     CommandDescr *commands)
{
	strcpy(Title,title);
	if (numcommands > MaxNumCommands) {
		Terminal::term->Error(termErr,"Too many commands on a command screen!");
		numcommands = MaxNumCommands;
	}
	for (int i = 0; i < numcommands; i++) {
		CommandSpecs[i] = commands[i];
		CommandSpecs[i].LineNumber = i + 3;
	}
	NumCommands = numcommands;
	currentCommand = 1;
}
			     
void CommandScreen::RePaint()
{
	int c = (Terminal::term->colms - strlen(Title)) >> 1;
	Terminal::term->Clear();
	Terminal::term->RevsPen();
	Terminal::term->PutStrAt(1,c,Title);
	Terminal::term->PlainPen();
	for (int i = 0;i < NumCommands;i++) {
		if ((i+1) == currentCommand) Terminal::term->RevsPen();
		Terminal::term->PutStrAt(CommandSpecs[i].LineNumber,1,CommandSpecs[i].Text);
		if ((i+1) == currentCommand) Terminal::term->PlainPen();
	}
	Terminal::term->PenPos(CommandSpecs[currentCommand-1].LineNumber,1);
}

int CommandScreen::RunScreen()
{
	RePaint();
	for (;;) {
		int commd = 0;
		int n = 0;
		switch (Terminal::term->GetKey()) {
			case upCmd :
			    commd = (currentCommand == 1 ? 0 : currentCommand-1);
			    break;
			case downCmd :
			    commd = (currentCommand == NumCommands ? 0 : currentCommand+1);
			    break;
			case '\r':
#ifdef OSK
			case '\l':
#else
			case '\n':
#endif
			    n = currentCommand-1;
			    n = (*CommandSpecs[n].Function)();
			    if (n == 0) return(1);
			    else if (n < 0) RePaint();
			    continue;
			case escCmd : return(0);
		}
		if (commd == 0) Terminal::term->Bell();
		else {
			HiliteCommand(currentCommand,false);
			HiliteCommand(currentCommand = commd,true);
		}
	}
}

