/* -*- Mode: C -*- */
/* CardRecord.cc - Implementation of CardRecords
 * Created by Robert Heller on Sat Dec  7 00:01:57 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifdef MESSYDOS
#include <cardrec.h>
#else
#include <CardRecord.h>
#endif
#include <stdio.h>
// #include <stream.h>

extern Card defCard;	// prototypical Card

// CardRecord constructor, given an existing CardRecord
CardRecord::CardRecord(CardRecord& cardrecord)
{
	RawData = cardrecord.RawData;
	card = RecordToCard();
}
// CardRecord copier function
CardRecord& CardRecord::operator = (CardRecord& cardrecord)
{
	RawData = cardrecord.RawData;
	if (card != 0) delete card;
	card = RecordToCard();
	return *this;
}
// CardRecord constructor, given a CoreItem
CardRecord::CardRecord(CoreItem* coreitem)
{
	RawData = coreitem->data;
	card = RecordToCard();
}
// CardRecord constructor, given a Record*
CardRecord::CardRecord(Record* record)
{
	RawData = *record;
	card = RecordToCard();
}
// CardRecord constructor, given a Card*
CardRecord::CardRecord(Card* card)
{
	CardRecord::card = new Card;
	memcpy(CardRecord::card,card,sizeof(Card));
	RawData.NewBuffer(0);
}
// CardRecord destructor
CardRecord::~CardRecord()
{
	delete card;
	RawData.NewBuffer(0);
}
// Conversion function - convert from a Record to a Card
// derived from the code for RawBook::RawToBook() on page 91 of
// "C++, a guide for C programmers", by Sharam Hekmatpour
Card*  CardRecord::RecordToCard ()
{
	register char* str = RawData.buffer;	// Data string
	register int   bytesleft = RawData.size; // Number of bytes
	register Card *cd = new Card;		// allocate a fresh Card
	*cd = defCard;				// default Card
	// while bytes remain...
	while (bytesleft > 0) {
		// scan for field specifier
		while (*str != '%' && bytesleft > 0) { str++; bytesleft--; }
		// skip over specified prefix
		str++; bytesleft--;
		// while there still are bytes...
		if (bytesleft <= 0) break;
		// fan out based on field key
		switch (*str++) {
			case 'A': cd->author = str;  break;
			case 'T': cd->title  = str;  break;
			case 'P': cd->publisher = str;  break;
			case 'C': cd->city = str;    break;
			case 'V': cd->vol = atoi(str); break;
			case 'Y': cd->year = atoi(str); break;
			case 'D': cd->description = str; break;
			case 't': cd->type = (enum CardType) *str;
		}
		// count specifier
		bytesleft--;
		// find strlen plus nul byte
		int slen = strlen(str) + 1;
		// update counter and pointer
		bytesleft -= slen;
		str += slen;
		// EOR marker?
		if (*str == '\n') break;
	}
	// return new Card* pointer
	return cd;
}

// Create a fresh record from a Card
void CardRecord::UpdateRecord()
{
	static char vstr[20], ystr[20];		// temp strings for numerics

	// form numeric strings
	sprintf(vstr,"%d",card->vol);
	sprintf(ystr,"%d",card->year);
	// compute buffer size
	int rsize = 4 +				// "%tT\0"
		strlen(card->author) + 3 +	// "%Aauthor\0"
		strlen(card->title) + 3 +	// "%Ttitle\0"
		strlen(card->publisher) + 3 +	// "%Ppublisher\0"
		strlen(card->city) + 3 +	// "%Ccity\0"
		strlen(card->description) + 3 +	// "%Ddescription\0"
		strlen(vstr) + 3 +		// "%Vnnnn\0"
		strlen(ystr) + 3 +		// "%Ynnnn\0"
		strlen("\n") + 1;		// "\n\0"
	// allocate a string
	char* str = new char[rsize]; char* p = str;
	// pack data into the string
	*p++ = '%'; *p++ = 't'; *p++ = card->type;  *p++ = 0;
	*p++ = '%'; *p++ = 'A'; strcpy(p,card->author); card->author = p;
	p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'T'; strcpy(p,card->title); card->title = p;
	p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'P'; strcpy(p,card->publisher); card->publisher = p;
	p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'C'; strcpy(p,card->city); card->city = p;
	p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'D'; strcpy(p,card->description);
	card->description = p; p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'V'; strcpy(p,vstr); p += strlen(p) + 1;
	*p++ = '%'; *p++ = 'Y'; strcpy(p,ystr); p += strlen(p) + 1;
//	cerr.form("*** before *p++ = '\\n'; *p++ = 0;: p = 0x%08x\n",(long) p);
	*p++ = '\n'; *p++ = 0;
//	cerr.form("*** after  *p++ = '\\n'; *p++ = 0;: p = 0x%08x\n",(long) p);
	// free up old buffer
	RawData.NewBuffer(0);
	// paste in new buffer
	RawData.size = rsize;
	RawData.buffer = str;
}
