/* -*- Mode: C -*- */
/* Card.cc - Card class implementation
 * Created by Robert Heller on Fri Dec  6 23:52:08 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#include <Card.h>
#include <ctype.h>

Card defCard;			// default prototypical card
int Card::numblocks = 0;	// current number of allocated blocks
Card* Card::blocks[maxblocks]; // allocated cards
Card* Card::freelist = NULL;	// linked list of available cards

// Helper function to allocate an additional block of 100 Cards
void Card::moreblocks ()
{
	// Have we run out of blocks?
	if (numblocks < maxblocks) {
		// if not...  bump block counter
		int iblock = numblocks++;
		// snarf some memory
		Card* p = blocks[iblock] = (Card*) new char[sizeof(Card)*blocksize];
		// build linked list.  author field doubles as next pointer.
		for (int ic = 1; ic < blocksize; ic++) {
			p->author = (char*) (p+1);
			p++;
		}
		// point last tail at current freelist
		p->author = (char*) freelist;
		// and set freelist head to first Card in fresh block
		freelist = blocks[iblock];
	}
}
			
// overloaded new operator for Cards
void* Card::operator new (long bytes)
{
	// if freelist is empty, get more memory
	if (defCard.freelist == 0) defCard.moreblocks();
	// if freelist is still empty, return null
	if (defCard.freelist == 0) return(0);
	// get pointer to head of list
	Card* newcard = defCard.freelist;
	// set freelist to next card in the list
	defCard.freelist = (Card*) newcard->author;
	// unlink new card from the list
	newcard->author = 0;
	// retun new card
	return(newcard);
}

// overloaded delete operator for Cards
void Card::operator delete(void* vptr)
{
	// convert pointer to a Card*
	Card* ptr = (Card*) vptr;
	// if a null pointer, just return
	if (ptr == 0) return;
	// has this card already be freed?
	for (Card* p = defCard.freelist; p != 0; p = (Card*) p->author) {
		if (p == ptr) return;	// if so, don't free it again
	}
	// link onto head of free list
	ptr->author = (char*) defCard.freelist;
	defCard.freelist = ptr;
}

static struct {
	CardType t;
	char* n;
} cardtypenames[] = 
	{ {Book,"Book"}, {Magazine,"Magazine"}, {CD,"CD"},
	  {AudioCassette,"AudioCassette"}, {Album,"Album"}, 
	  {LaserDisk,"LaserDisk"}, {VHSVideo,"VHSVideo"}, 
	  {BetaVideo,"BetaVideo"}, {EightMM,"EightMM"},
	  {EightTrack,"EightTrack"}, {DAT,"DAT"}, {Other,"Other"}
	};
const NumCardTypes = sizeof(cardtypenames) / sizeof(cardtypenames[0]);


char* TypeName(CardType type)
{
	for (int i = 0; i < NumCardTypes; i++) {
		if (type == cardtypenames[i].t) return(cardtypenames[i].n);
	}
	static char* dummy = "???";
	return dummy;
}
	
static int cfstrcmp(char* a,char* b)
{
	int comp = 0;
	int ca,cb;
	for (comp = 0;comp == 0;a++,b++) {
		ca = *a; cb = *b;
		if (islower(ca)) ca = toupper(ca);
		if (islower(cb)) cb = toupper(cb);
		comp = ca - cb;
		if (ca == 0 || cb == 0) break;
	}
	return (comp);
}

CardType NameType(char* name)
{
	for (int i = 0; i < NumCardTypes; i++) {
		if (cfstrcmp(name,cardtypenames[i].n) == 0) 
		    return(cardtypenames[i].t);
	}
	return Other;
}

Boolean CardTypeNameP(char* name)
{
	for (int i = 0; i < NumCardTypes; i++) {
		if (cfstrcmp(name,cardtypenames[i].n) == 0) 
		    return(true);
	}
	return false;
}


