/* -*- Mode: C -*- */
/* ListRecord.h - A record as a list
 * Created by Robert Heller on Fri Dec  6 20:25:42 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifndef _LRECORD_
#define _LRECORD_
#include <common.h>

// This class maps between the list on disk (as a record) and the list
// in memory (as a vector).
// RawData is the disk record.  elems is the vector in memory.
// numelts is the number of elements
// dummy is returned for out of bounds references
class ListRecord {
	Record RawData;
	int numelts;
	char** elems;
	static char* dummy;
	void UpdateRecord();	// make a record from a vector
public:
	// Constructors and type conversions:
	      ListRecord(Record* record);	// a ListRecord from a Record
	      ListRecord(CoreItem* coreitem);	// a ListRecord from a CoreItem
	      ListRecord(int numitems,char* inelems[]);	// a ListRecord from a vector
	// descructor.  clean things up
	     ~ListRecord() { RawData.NewBuffer(0); delete elems; }
	// Index operator
	char*& operator [] (int index)
			{ if (index >= 0 && index < numelts)
			       return elems[index];
			  else return dummy;}
	// Convert a ListRecord to a plain Record
	operator Record ()
		{
			UpdateRecord();
			Record record = RawData;
			return record;
		}
	// Return number of elements
	int ElementCount ()		{ return numelts; }
};
#endif
