/* -*- Mode: C -*- */
/* Card.h - Structure for representing catalog cards
 * Created by Robert Heller on Fri Dec  6 20:11:05 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Header Files
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifndef _CARD_
#define _CARD_
#include <common.h>		// common defs

// Card class.  This class is really just a structure pointing to
// various pieces of data describing an item in the library.
// To avoid pounding on the simple heap memory management,  Cards are
// allocated 100 at a time (upto a max of 100,000 cards), and "old"
// cards are reused, rather than returned to the general heap.
class Card {
	const blocksize = 100;	// number of cards to allocate at a time
	const maxblocks = 1000;	// maximum number blocks to allocate
	static int numblocks;	// current number of allocated blocks
	static Card* blocks[maxblocks]; // allocated cards
	static Card* freelist;	// linked list of available cards
	void   moreblocks();	// internal function to get another block of cards
public:
	CardType type;		// Type of item (book, magazine, etc.)
	char* author;		// Who wrote it.
	char* title;		// What it is called
	char* publisher;	// Who published it
	char* city;		// Where it was published
	char* description;	// What is it really??
	int vol;		// If multi-volume
	int year;		// Year it was published
	      Card()		// New blank card
		{Card(Other,"Unknown","Unknown","Unknown","Unknown","",0,0);}
				// New initialized card
	      Card(CardType type,char* author,char* title,char* publisher,
	           char* city,char* description,int vol,int year)
			{
				Card::type = type;
				Card::author = author;
				Card::title = title;
				Card::publisher = publisher;
				Card::city = city;
				Card::description = description;
				Card::vol = vol;
				Card::year = year;
			}
	void* operator new (long bytes);	// dyn. allocated card
	void  operator delete  (void* ptr);	// free a dyn. allocated card
};

extern char* TypeName(CardType);
extern CardType NameType(char*);
extern Boolean CardTypeNameP(char*);
#endif
