/* -*- Mode: C -*- */
/* DeleteStuff.cc - Delete functions
 * Created by Robert Heller on Sat Dec 14 00:11:12 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Edit a Librarian Card Catalog file
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <stream.h>
#include <ctype.h>
#include <vBTree.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#include <Terminal.h>
#ifdef MESSYDOS
#include <CmdScren.h>
#include <ScrPmt.h>
#else
#include <CommandScreen.h>
#include <ScrollPrompt.h>
#endif
#include "EditDefs.h"
#include "EditGlob.h"

const DescrSize = 4096;
static char SubjList[DescrSize];

extern void UpdateSubjs(const char* subjs,const char* osubjs,const Key key);
extern void UpdateAuthor(const char* auth,const char* oauth,const Key key);
extern void UpdateTitle(const char* title,const char* otitle,const Key key);
extern void FetchSubjs(char* subjbuffer,const Key key);

static Boolean DeleteCard1(const Key deletekey)
{
	CoreItem item;
	if (Tree->SearchId((Key)deletekey,&item) &&
	    strlen(deletekey) == strlen(item.key)) {
		CardRecord rec(&item.data);
		UpdateAuthor("",rec->author,item.key);
		UpdateTitle("",rec->title,item.key);
		FetchSubjs(SubjList,deletekey);
		UpdateSubjs("",SubjList,item.key);
	    	Tree->DeleteId((Key)deletekey);
	    	return true;
	} else return false;
}
int DeleteCard()
{
	Key deletekey;
	Term->PromptLine(18,0,"Id of card to delete: ",deletekey,KeySize);
	if (!DeleteCard1(deletekey)) Term->Message("No Such Card");
	return(-1);
}
int DeleteByAuthor()
{
	Key author;
	Term->PromptLine(16,0,"Author to delete by: ",author,KeySize);
	CoreItem item;
	if (Tree->SearchAuthor(author,&item) &&
	    strlen(author) == strlen(item.key)) {
		static char line[60];
		ListRecord rec(&item.data);
		int icount = rec.ElementCount();
		for (int i = 0; i < icount;i++) {
			sprintf(line,"Delete %s?",rec[i]);
			if (Term->YorNp(17,0,line)) DeleteCard1(rec[i]);
		}
	} else Term->Message("No such author");
	return(-1);
}
int DeleteByTitle()
{
	Key title;
	Term->PromptLine(16,0,"Title to delete by: ",title,KeySize);
	CoreItem item;
	if (Tree->SearchTitle(title,&item) &&
	    strlen(title) == strlen(item.key)) {
		static char line[60];
		ListRecord rec(&item.data);
		int icount = rec.ElementCount();
		for (int i = 0; i < icount;i++) {
			sprintf(line,"Delete %s?",rec[i]);
			if (Term->YorNp(17,0,line)) DeleteCard1(rec[i]);
		}
	} else Term->Message("No such title");
	return(-1);
}
int DeleteBySubj()
{
	Key subject;
	Term->PromptLine(16,0,"Subject to delete by: ",subject,KeySize);
	CoreItem item;
	if (Tree->SearchSubj(subject,&item) &&
	    strlen(subject) == strlen(item.key)) {
		static char line[60];
		ListRecord rec(&item.data);
		int icount = rec.ElementCount();
		for (int i = 0; i < icount;i++) {
			sprintf(line,"Delete %s?",rec[i]);
			if (Term->YorNp(17,0,line)) DeleteCard1(rec[i]);
		}
	} else Term->Message("No such subject");
	return(-1);
}

