/* -*- Mode: C -*- */
/* Ascii2Libr.cc - Read in an ASCII text file representing a library
 *		   into a libr file
 * Created by Robert Heller on Mon Dec  9 19:04:45 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Progam to read in an Ascii text file describing a library into a
 * Library Card Catalog file.
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */

#include <stream.h>
#include <ctype.h>
#include <vBTree.h>
#ifdef MESSYDOS
#include <CardRec.h>
#include <ListRec.h>
#else
#include <CardRecord.h>
#include <ListRecord.h>
#endif
#define VERSION "V1.0Beta"
#ifdef MESSYDOS
#include "Asc2Libr.h"
#else
#include "Ascii2Libr.h"
#endif

const initbuffsize = 2048;
const buffergrowth = 2048;

char* ReadQuotedString(istream& in)
{
	char* outbuffer;
	char* newbuffer;
	char* p;
	char  ch;
	int   buffsize, charsleft, chindex;

	//cerr << "*** Entering ReadQuotedString\n";
	do {
		in.get(ch);
		//cerr << "*** Skiping '" << ch << "'\n";
	} while (ch != '"');
	outbuffer = new char[initbuffsize];
	buffsize = initbuffsize;
	charsleft = initbuffsize;
	chindex = 0;
	p = outbuffer;
	while (true) {
		in.get(ch);
		if (ch == '"') break;
		else if (ch == '\\') {
			in >> ch;
			//cerr << "*** Inserting '" << ch << "' (was escaped)\n";
			*p++ = ch;
			charsleft--;
			chindex++;
		} else {
			//cerr << "*** Inserting '" << ch << "'\n";
			*p++ = ch;
			charsleft--;
			chindex++;
		}
		if (charsleft < 1) {
			newbuffer = new char[buffsize+buffergrowth];
			strcpy(newbuffer,outbuffer);
			delete outbuffer;
			outbuffer = newbuffer;
			buffsize += buffergrowth;
			p = outbuffer+chindex;
			charsleft = buffergrowth;
		}
	}
	*p = 0;
	return outbuffer;
}

main(int argc,char** argv)
{
	int numpages,numkeys;
	char* p;
	Key key;
	char ch;
	static char wordbuffer[80];
	static char* vector[2048];
	int ielt;
	Card tempcard(Other,0,0,0,0,0,0,0);
	static Ascii2Libr args(argc,argv);
	cin >> numpages;
	if (args.minpages_passed && args.minpages > numpages)
	    numpages = args.minpages;
	vBTree outtree(args.outfile,(OpenMode)(ReadWrite|Create),numpages);
	switch (outtree.OpenStat()) {
		case failure: int error = errno;
			      cerr << "Could not create " << args.outfile
				   << ": " << strerror(error) << "\n";
			      exit(error);
		case openold: cerr << args.outfile << " already exists!\n";
			      exit(1);
	}			      
	cin >> numkeys;
	for (int i = 0;i < numkeys;i++) {
		p = ReadQuotedString(cin);
		strncpy(key,p,36);
		key[35] = 0;
		delete p;
		//cerr << "*** Key = |" << key << "|\n";
		do {
			cin >> ch;
		} while (ch != '#');
		cin >> ch;
		if (ch != 'C') {
			cerr << form("Syntax error reading Card %d: expected a C, saw a %c\n",
				     i,ch);
			exit(1);
		}
		cin >> ch;
		if (ch != '(') {
			cerr << form("Syntax error reading Card %d: expected a (, saw a %c\n",
				     i,ch);
			exit(1);
		}
		while (true) {
			while (true) {
				cin >> ch;
				//cerr << "*** ch = '" << ch << "'\n";
				if (ch == ')') break;
				else if (ch > ' ') {
					//cerr << "*** putting back '" << ch << "'\n";
					cin.putback(ch);
					break;
				}
			}
			if (ch == ')') break;
			cin >> wordbuffer;
			//cerr << "*** wordbuffer = |" << wordbuffer << "|\n";
			for (p = wordbuffer;*p != 0;p++) {
				ch = *p;
				if (islower(ch)) ch = toupper(ch);
				*p = ch;
			}
			if (strcmp(wordbuffer,":TYPE") == 0) {
				cin >> wordbuffer;
				tempcard.type = NameType(wordbuffer);
			} else if (strcmp(wordbuffer,":AUTHOR") == 0) {
				tempcard.author = ReadQuotedString(cin);
			} else if (strcmp(wordbuffer,":TITLE") == 0) {
				tempcard.title = ReadQuotedString(cin);
			} else if (strcmp(wordbuffer,":PUBLISHER") == 0) {
				tempcard.publisher = ReadQuotedString(cin);
			} else if (strcmp(wordbuffer,":CITY") == 0) {
				tempcard.city = ReadQuotedString(cin);
			} else if (strcmp(wordbuffer,":DESCRIPTION") == 0) {
				tempcard.description = ReadQuotedString(cin);
			} else if (strcmp(wordbuffer,":VOLUME") == 0) {
				cin >> tempcard.vol;
			} else if (strcmp(wordbuffer,":YEAR") == 0) {
				cin >> tempcard.year;
			} else {
				cerr << form("Bad key in Card #%d: %s\n",i,wordbuffer);
			}
		}
		CardRecord crec(&tempcard);
		Record rawrec = crec;
		outtree.InsertId(key,&rawrec);
		if (tempcard.author != 0) {
			delete tempcard.author;
			tempcard.author = 0;
		}
		if (tempcard.title != 0) {
			delete tempcard.title;
			tempcard.title = 0;
		}
		if (tempcard.publisher != 0) {
			delete tempcard.publisher;
			tempcard.publisher = 0;
		}
		if (tempcard.city != 0) {
			delete tempcard.city;
			tempcard.city = 0;
		}
		if (tempcard.description != 0) {
			delete tempcard.description;
			tempcard.description = 0;
		}
	}
	cin >> numkeys;
	for (i = 0;i < numkeys;i++) {
		p = ReadQuotedString(cin);
		strncpy(key,p,36);
		key[35] = 0;
		delete p;
		do {
			cin >> ch;
		} while (ch != '#');
		cin >> ch;
		if (ch != '(') {
			cerr << form("Syntax error reading Title %d: expected a (, saw a %c\n",
				     i,ch);
			exit(1);
		}
		for (ielt = 0;ielt < 2048;ielt++) {
			while (true) {
				cin >> ch;
				if (ch == ')') break;
				else if (ch > ' ') {
					cin.putback(ch);
					break;
				}
			}
			if (ch == ')') break;
			vector[ielt] = ReadQuotedString(cin);
		}
		ListRecord lrec(ielt,vector);
		Record rawrec = lrec;
		outtree.InsertTitle(key,&rawrec);
		for (;ielt > 0;ielt--) delete vector[ielt-1];
	}
	cin >> numkeys;
	for (i = 0;i < numkeys;i++) {
		p = ReadQuotedString(cin);
		strncpy(key,p,36);
		key[35] = 0;
		delete p;
		do {
			cin >> ch;
		} while (ch != '#');
		cin >> ch;
		if (ch != '(') {
			cerr << form("Syntax error reading Author %d: expected a (, saw a %c\n",
				     i,ch);
			exit(1);
		}
		for (ielt = 0;ielt < 2048;ielt++) {
			while (true) {
				cin >> ch;
				if (ch == ')') break;
				else if (ch > ' ') {
					cin.putback(ch);
					break;
				}
			}
			if (ch == ')') break;
			vector[ielt] = ReadQuotedString(cin);
		}
		ListRecord lrec(ielt,vector);
		Record rawrec = lrec;
		outtree.InsertAuthor(key,&rawrec);
		for (;ielt > 0;ielt--) delete vector[ielt-1];
	}
	cin >> numkeys;
	for (i = 0;i < numkeys;i++) {
		p = ReadQuotedString(cin);
		strncpy(key,p,36);
		key[35] = 0;
		delete p;
		do {
			cin >> ch;
		} while (ch != '#');
		cin >> ch;
		if (ch != '(') {
			cerr << form("Syntax error reading Subject list %d: expected a (, saw a %c\n",
				     i,ch);
			exit(1);
		}
		for (ielt = 0;ielt < 2048;ielt++) {
			while (true) {
				cin >> ch;
				if (ch == ')') break;
				else if (ch > ' ') {
					cin.putback(ch);
					break;
				}
			}
			if (ch == ')') break;
			vector[ielt] = ReadQuotedString(cin);
		}
		ListRecord lrec(ielt,vector);
		Record rawrec = lrec;
		outtree.InsertSubj(key,&rawrec);
		for (;ielt > 0;ielt--) delete vector[ielt-1];
	}
}

