/* WXDCLIST.CXX */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
#include "dcdlist.hpp"
#include "dcerror.hpp"

void dczDList::cleanup() 
{ 
if (purge) while (size()) delete linkout();
Clear(); current=NULL; 
}

dczDList::dczDList(int p) 
{ purge=p; current=NULL; err=0; }

dczDList::dczDList(void* a, int p)
{ purge=p; current=NULL; err=0; linkin(a); }

void *dczDList::linkout()
{
if (!current)
  { dcerror(err=DCDLIST_EMPTY,"dlist is empty (linkout)"); return NULL; }
void *temp=current->Data();
wxNode *old=current;
if (current)
  {
  if (current->Next()) current=current->Next();
  else current=current->Previous();
  }
DeleteNode(old);
return temp;
}

int dczDList::linkin(void *data)
{
if (!current)
  current=Insert((wxObject*)data);
else
  {
  wxObject *temp=current->Data();
  current->SetData((wxObject*)data);
  Insert(current,temp); // put new current before new node
  }
if (current==NULL) 
  { dcerror(err=ENOMEM); return ENOMEM; }
else return 0; // 0 indicates success
}

int dczDList::fwd()
{
if (current==NULL || current->Next()==NULL) return DCDLIST_ATEND; // just a warning
else { current=current->Next(); return 0; }
}

int dczDList::bkwd()
{
if (current==NULL || current->Previous()==NULL) return DCDLIST_ATEND; // just a warning
else { current=current->Previous(); return 0; }
}

int dczDList::start()
{
if ((current=First())==NULL) return DCDLIST_EMPTY;
else return 0;
}

int dczDList::end()
{
if ((current=Last())==NULL) return DCDLIST_EMPTY;
else return 0;
}

void *dczDList::get()
{
if (current==NULL) 
  { dcerror(err=DCDLIST_EMPTY,"dlist is empty (get)"); return NULL; }
else return current->Data();
}

void *dczDList::update(void *newdata)
{
if (current==NULL) 
  { dcerror(err=DCDLIST_EMPTY,"dlist is empty (update)"); return NULL; }
else
  {
  void *old=current->Data();
  current->SetData((wxObject*)newdata);
  return old;
  }

}

