/* DCWINDOW.HPP */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
#ifndef DCWINDOWHPP
#define DCWINDOWHPP
#if defined wx_msw || defined wx_xview || defined wx_motif
#include "allwx.hpp"
#else
#include "dcsedit.hpp"
#include <disp.h>
#endif
#include <stdio.h>
#include <stdarg.h>
#include "dcdlist.hpp"

declare (dczGDList,char);

#ifdef using_wx
#define wxDIALOG_DEFAULT_X 300
#define wxDIALOG_DEFAULT_Y 300
class dcButton: public wxButton
{
 public:
  wxDialogBox *d;
  dcButton(wxDialogBox *dd,wxPanel *panel, wxFunction func, char *label,
               int x = -1, int y = -1, int width = -1, int height = -1);
};

void dcDialogOkButton(wxButton& button, wxEvent& event);
void dcDialogCancelButton(wxButton& button, wxEvent& event);
void dcDialogHistoryButton(wxButton& button, wxEvent& event);
extern int dcDialogButtonPressed;
extern float xscale,yscale;
extern void set_scale(wxWindow *w);

class dcwindow
{
dczGDList(char) *old_lines;
int history_size,history_used;
wxTextWindow *textwin;
wxFrame *frame,**parentptr;
char inited;
int r1,r2,c1,c2;
init();
char title_str[100];
public:
    int get_r1() { return r1; }  // get top left corner for wx
    int get_c1() { return c1; }
    dcwindow(wxFrame **p=(wxFrame **)&mainframeptr,char *title="");
    dcwindow(wxFrame **p,char *title,int r1,int c1,int r2,int c2);
    void set_history(int sz);
    void set_scrolling(int l) {;}
    void clear() { if (!inited) init(); textwin->Clear(); }
    void chat(int, int) {;}
    int title(char *s) { strcpy(title_str,s); return 1; }
    void modify(int att, int frame, int fa = -1) {;}
    void suspend();
    void select();
    void locate(int, int) {;}
    void putch(char c);
    void print(char *s);
    void puts(char *s);
    int printf(char *,...);
    int vprintf(char *,va_list arg_ptr);
    char *fgets(char *s,int len=-1,FILE *fp=NULL);
    int gets(char *s,int len=-1,char *pr=NULL);
    int close();
    ~dcwindow();
};

#else
// for DOS
class dcwindow 
{
    dczGDList(char) *old_lines;
    int history_size,history_used;
    friend class dcwindow_set;
    dcwindow_set *ws;
    int suspended;
    unsigned short *buffer;
    void redisplay();
    void swap();
    void outc(char);
protected:
    dcstring_editor se;
    int tlr,tlc,brr,brc;
    int attribute, frameatt;
    int border;
    int toscroll;
    int wide, high, cr, cc;
    create(dcwindow_set *ws,int r1,int c1,int r2,int c2,int att,int fr,int fratt=-1,PFC hf=0);
public:
    dcwindow(dcwindow_set *ws,char *t,int r1,int c1,int r2,int c2,int att=DISP_NORMAL,int fr=0,int fratt=-1,PFC hf=0);
    dcwindow(dcwindow_set *ws,int r1,int c1,int r2,int c2,int att=DISP_NORMAL,int fr=0,int fratt=-1,PFC hf=0);
    dcwindow() {;}
    void set_history(int sz);
    void set_scrolling(int l);
    void clear();
    void chat(int, int);
    int title(char *);
    void modify(int att, int frame, int fa = -1) {
        frameatt = fa == -1? att: fa;
        attribute = att; border = frame;
        redisplay();
    }
    void suspend();
    void select();
    void locate(int, int);
    void putch(char c);
    void puts(char *s);
    int printf(char *,...);
    int vprintf(char *,va_list arg_ptr);
    char *fgets(char *s,int len=-1,FILE *fp=stdin);
    int gets(char *s,int len=-1,char *pr=NULL);
    int close();
    ~dcwindow() { close(); }
    void set_attr(int at) { attribute=at; }
};

typedef dcwindow* pdcwindow;
declare(dczGDList,dcwindow);

class dcwindow_set {
    friend class dcwindow;
    int overlapped;
    dczGDList(dcwindow) wl;
    int add(pdcwindow);
    void purge();
public:
    dcwindow_set(int tiled) {
        overlapped = tiled;
        if (!disp_inited) disp_open();
    }
    ~dcwindow_set() { purge(); }
};
#endif

#endif


