/* DCDLIST.HPP */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
#ifndef __DCDLIST_HPP
#define __DCDLIST_HPP
#if defined wx_xview || defined wx_msw || defined wx_motif
#include "allwx.hpp"
#endif
#include <stdio.h>
#include <generic.h>
#include <stddef.h>
#include <errno.h>

enum dcDList_errors {
    DCDLIST_OK,
    DCDLIST_EMPTY = 60,
    DCDLIST_ATEND
};

#ifndef using_wx

//. First we need to define the building block for the double linked
//. list, class dczDLNode.  This has pointers to the next and to the
//. previous nodes as well as the pointer to the associated object.
class dczDLNode {
    friend class dczDList;
    friend class dczDLCursor;
    dczDLNode *next, *prev;    // pointers to next and previous items in list
    void *body;             // points to whatever is associated with this node
};

class dczDList {
    friend class dczDLCursor;

public:

//. The optional integer argument to the constructors enables purging
//. of the items on the list by the list destructor.  If the default
//. zero argument is used,  the destructor deletes only the list nodes.
    dczDList(int = 0);
    dczDList(void* a, int = 0);

//. linkin adds a new item to the list after the current item, and
//. IdczDList;linkin moves the currency onto the new item.
    int linkin(void *);

//. linkout removes the current item from the list, and returns a
//. IdczDList;linkout pointer to it.
    void* linkout();

//. Four functions provide for moving about the list. fwd and bkwd
//. move one item forwards or backwards.  If the currency
//. was already at the end or the beginning respectively, then these
//. functions have no effect. Functions start and end move the
//. IdczDList;fwd IdczDList;bkwd IdczDList;start IdczDList;end currency to
//. either end of the list.
    int fwd();
    int bkwd();
    int start();
    int end();

//. The get function removes an item from the list, and returns a
//. IdczDList;get pointer to it.
    void *get();

//. update exchanges the object pointed at by its argument with the
//. one already in the list at the current position.  A pointer to
//. IdczDList;update the displaced object is returned.

//DC note that used to be void, now have to delete displaced object

    void *update(void *);

//. IdczDList;size size gets the number of items which are present in
//. the list.
    long size(void) const { return count; }
   ~dczDList() { cleanup(); }
//DC
    int atstart() { return lpos==1; }
    int atend() { return lpos==count; }
//DC following was private:
    void cleanup();
//DC must have this so can use default constructor
    void setflush(int p) { purge=p; }
    int error() { int e = err; err = 0; return e; }

private:
    dczDLNode *root;           // root->next is head of list *root is tail
    dczDLNode *current;        // remembers current context
    long count;              // how many items in the list
    long lpos;               // where are we now
    unsigned char purge;     // delete objects as well as nodes?
    unsigned char err;
};

#else

class dczDList : public wxList{
private:
    wxNode *current;        // remembers current context
    unsigned char err;
    unsigned char purge;     // delete objects as well as nodes?
public:
    dczDList(int p = 0);
    dczDList(void* a, int p = 0);
    int linkin(void *);
    void* linkout();
    int fwd();
    int bkwd();
    int start();
    int end();
    void *get();
    void *update(void *);
    long size(void) { return Number(); }
    ~dczDList() { cleanup(); }
    int atstart() { return current!=NULL && (current->Previous()==NULL); }
    int atend() { return current!=NULL && (current->Next()==NULL); }
    void cleanup();    
    void setflush(int p) { purge=p; }
    int error() { int e = err; err = 0; return e; }
} ;
#endif
    
//. Given the base dczDList class we can then privately derive from it
//. the generic case.  In this we overload various operators to make
//. the use of dczGDLists more succinct.

//. Operators += and -= move up or down the list by a specified number
//. of items. The increment and decrement operators ++ and -- move the
//. currency to the next or previous item respectively.  Operator *
//. resolves to a pointer to the object which is attached to the curent
//. node, linking the object out of the list.  Operator() passively
//. returns a pointer to the current object.

//DC note that following is declared with type, not type*
//e.g. dczGDListdeclare(int) not dczGDListdeclare(pint)

#define dczGDList(type) name2(dczGDList,type)

// DC note that list will not be cleaned up properly because type destructor
// will not be called. Fixing this would add an overhead that is 
// probably unnecessary.
// If you want one then { while glist.size() delete glist.linkout(); }

#define dczGDListdeclare(type)\
struct dczGDList(type) : dczDList {\
    dczGDList(type)(int p = 0) : dczDList(p) {;}\
    dczGDList(type)(type *a, int p = 0) : dczDList(a,p) {;}\
    int linkin(type *a)\
        { return dczDList::linkin(a); }\
    int operator+=(int n)\
        { int r; while (n--) r = fwd(); return r; }\
    int operator-=(int n)\
        { int r; while (n--) r = bkwd(); return r; }\
    int operator++() { return fwd(); }\
    int operator--() { return bkwd(); }\
    type *update(type *a)\
        { return (type *) dczDList::update(a); }\
    type *operator*()\
        { return (type *) linkout(); }\
/* DC would you believe this was missing? */\
    type *linkout()\
        { return (type *) dczDList::linkout(); }\
    type *operator()() { return (type *) dczDList::get(); }\
    type *get() { return (type *) dczDList::get(); }\
    int operator<<(type *a) { return dczDList::linkin(a); }\
    int start() { return dczDList::start(); }\
    int end() { return dczDList::end(); }\
    long size() { return dczDList::size(); }\
    int error() { return dczDList::error(); }\
}

#endif
