/* DCARRAY.HPP */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
/* DCARRAY.HPP */ 
/* Copyright Dave Curtis 1991 */ 
#ifndef DCARRAYHPP
#define DCARRAYHPP 1

#if defined wx_msw || defined wx_xview || defined wx_motif
#include "allwx.hpp"
#endif

#include <stdlib.h>
#include <generic.h>
#include "datafile.hpp"

class db_editor;
class winmenu;
class dcwindow;
class dcarray;

class dcarray
{
int maxdim,diminc;
virtual data_object *new_own_type()=0;
protected:
char is_case_sensitive;
int count;
data_object **mem;
public:
dcarray(int md=100);
virtual ~dcarray(); // only virtual so no warning
remove(int i);
move_to_start(int i);
move_to_end(int i);
select(dcwindow &input_window,char *lab,winmenu &l,char *emptymess=0,int start=0);
int select(winmenu &wm,int start=0);
int add_member(data_object *temp);
virtual int which(char *name);
char *get_name(int i) { return mem[i]->label(); }
int save(data_file &file);
int load(data_file &file);
int size() { return count; }
void clear();
int edit(int i,db_editor *editing_object);
void make_case_sensitive() { is_case_sensitive=1; }
};

extern "C" { typedef int (*FCMP_T)(const void *,const void*); }

#define gdcarray(type) name2(type,gdcarray) 

#if 0
old attempt to try and allow assignment to an array element
 - I do not think it would have worked on any architecture,
and Sun CC complained about it
#define gdcarraydeclare(type) \
class name2(editable_,type);\
extern "C" { int name2(type,_compare)(type **,type **); }\
struct gdcarray(type) : public dcarray { \
void sort() { qsort(mem,count,sizeof(mem[0]),(FCMP_T)name2(type,_compare)); }\
int edit(int i,name2(editable_,type) &editing_object)  \
{ return dcarray::edit(i,(db_editor *) &editing_object) ; } \
gdcarray(type)(int md=100) : (md) {;} \
protected: \
data_object *new_own_type() { return (data_object *) new type; } \
type *&member(int i) { return (type*)mem[i]; } \
public: \
type *&operator[](int i) { return (type*)mem[i];  } \
};
#else
#define gdcarraydeclare(type) \
class name2(editable_,type);\
extern "C" { int name2(type,_compare)(type **,type **); }\
struct gdcarray(type) : public dcarray { \
void sort() { qsort(mem,count,sizeof(mem[0]),(FCMP_T)name2(type,_compare)); }\
int edit(int i,name2(editable_,type) &editing_object)  \
{ return dcarray::edit(i,(db_editor *) &editing_object) ; } \
gdcarray(type)(int md=100) : dcarray(md) {;} \
protected: \
data_object *new_own_type() { return (data_object *) new type; } \
type *member(int i) { return (type*)mem[i]; } \
public: \
type *operator[](int i) { return (type*)mem[i];  } \
};
#endif

#endif

