/* DBSTATE.HPP */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
#include "dbexpr.hpp"

class db_report_output_device {
protected:
int where_in_line;
public:
virtual output(char *s)=0;
virtual int tab_to(int t)=0;
virtual int new_line(int n=1)=0;
db_report_output_device();
virtual ~db_report_output_device();
};

class db_report_outfile : public db_report_output_device {
data_file *file;
public:
output(char *s);
int tab_to(int t);
int new_line(int n=1);
db_report_outfile(data_file *f);
};

class db_statement {
protected:
db_report_output_device *dev;
public:
db_statement(db_report_output_device *d);
virtual int execute()=0;
virtual ~db_statement();
};

declare (dczGDList,db_statement);

typedef dczGDList(db_statement) db_state_list;

class db_state_block {
db_state_list lines;
public:
db_state_block();
~db_state_block();
add_line(db_statement *d) { return !lines.linkin(d); } // goes at the end
execute();
};

enum db_rep_state { DBREP_ERROR=0,DBREP_OK=1,DBREP_NOTSTARTED,
DBREP_COVER,DBREP_TOTAL,DBREP_DETAIL,DBREP_IF,DBREP_ENDIF,
DBREP_ELSE,DBREP_STARTING,DBREP_EOF };

class db_report {
db_state_block *cover,*total,*detail,*current_block;
db3_record_buffer *buffer;
int line;
public:
db_report();
~db_report();
db_rep_state set_up(db_report_output_device *o,db3_record_buffer *b,
   data_file *i,db_rep_state st=DBREP_NOTSTARTED);
run(dc_index *i,char *cond=NULL);
};


