/* DBEXPR.HPP */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
#ifndef DBEXPR_HPP
#define DBEXPR_HPP
#include "dbf.hpp"
#include "dcexpr.hpp"

class db_express : public express
{
db3_record_buffer *buffer;
char *vprimitive(char *s,vnode**br);
static int inited;
int init();
char *get_next(char *s);
public:
db_express(db3_record_buffer *b);
~db_express();
int parse(char *s);
};

class named_variable
{
char *name;
public:
char *label() { return name; }
virtual assign(dcexpr_val *v)=0;
named_variable(char *n);
virtual ~named_variable();
virtual dcexpr_val *eval()=0; // not same as vnode->eval(), etc.
};

class double_variable : public named_variable
{
double val;
public:
assign(dcexpr_val *v);
double_variable(char *n);
~double_variable();
dcexpr_val *eval();
};

class string_variable : public named_variable
{
char *val;
public:
vnode *copy();
assign(dcexpr_val *v);
string_variable(char *n);
~string_variable();
dcexpr_val *eval();
};

declare (dczGDList,named_variable);

class dbexpr_variable_list : public dczGDList(named_variable)
{
public:
named_variable *get_match(char *s);
dbexpr_variable_list();
~dbexpr_variable_list();
void clear();
};

extern dbexpr_variable_list var_list;

#endif
