{

  Copyright 1994-1995 by Salvatore Besso, mc8505@mclink.it

  This software is freeware.

  You are free to modify the source code for your personal use and to
  redistribute this software only if you leave the copyright notices
  unmodified everywhere in the code, also in the comments.

  In case of problems contact me via e-mail at address:

  mc8505@mclink.it

}

program DbDesc;

{ Prints Paradox 4 tables structure and indexes informations }

{
  Errorlevels returned:

  1  = File error (not found or other DOS error)
  2  = Paradox Engine error
  3  = Printer error
  99 = Command line parameter wrong or missing
}

{
  Note: Unfortunately there is no way to determine if a secondary index
  is maintained or not, so pxIncSecondary is always used
}

{$V-}

uses
  Dos,Printer,
  Objects,
  PXEngine,OOPxEng;

const

  Version = '1.04';

  Engine  : PEngine   = NIL;
  Database: PDataBase = NIL;

  OnPrinter: Boolean = True;
  Path     : PathStr = '';

  PXEPrimary   = 100;
  PXEComposite = 101;

type

  PExtendedFieldDesc = ^TExtendedFieldDesc;
  TExtendedFieldDesc = object (TObject)
    FldNum    : FieldNumber;
    FldName   : String[MaxNameLen];
    FldType   : pxFieldType;
    FldSubType: pxFieldSubType;
    FldLen    : Integer;
    CaseSens  : Boolean;
    FldArray  : FieldNumberArray;
  end;

  PExtFieldCollection = ^TExtFieldCollection;
  TExtFieldCollection = object (TSortedCollection)
    function Compare (Key1,Key2: Pointer): Integer; virtual;
  end;

var
  I,J        : Integer;
  S          : String;
  Line,Spaces: String[128];
  Header     : array[1..10] of String;

{ TExtFieldCollection }

function TExtFieldCollection.Compare (Key1,Key2: Pointer): Integer;

var
  FD1: PExtendedFieldDesc absolute Key1;
  FD2: PExtendedFieldDesc absolute Key2;

begin
  if FD1^.FldNum < FD2^.FldNum then
    Compare := -1
  else if FD1^.FldNum = FD2^.FldNum then
    Compare := 0
  else Compare := 1
end;

procedure ReleaseEngine;

begin
  if Database <> NIL then Dispose (Database,Done);
  if Engine <> NIL then Dispose (Engine,Done)
end;

procedure ShutDown (Code: RetCode);

begin
  WriteLn (#7#13#10'Paradox Engine Database Framework error:');
  WriteLn (Engine^.GetErrorMessage (Code));
  ReleaseEngine;
  Halt (2)
end;

procedure OpenEngine;

begin
  Engine := New (PEngine,defInit (pxLocal));
  if Engine^.LastError <> PXSuccess then
    ShutDown (Engine^.LastError);
  Database := New (PDataBase,Init (Engine));
  if Database^.LastError <> PXSuccess then
    ShutDown (Database^.LastError)
end;

procedure PrinterError;

begin
  WriteLn (#7#13#10'Printer error');
  ReleaseEngine;
  Halt (3)
end;

function CenteredStr (S: String; Width: Integer): String;

begin
  CenteredStr := Copy (Spaces,1,(Width - Length (S)) div 2) + S
end;

procedure PrintStructure;

var
  Dir            : DirStr;
  Name           : NameStr;
  Ext            : ExtStr;
  DirInfo        : SearchRec;
  I              : Integer;
  TableDescriptor: PTableDesc;

procedure PrintInfo (P: PFieldDesc); far;

var
  S,T     : String;
  Len,Size: LongInt;

begin
  Str (P^.FldNum:0,T);
  S := Copy (T + Spaces,1,6) + ':  ' + Copy (P^.FldName + Spaces,1,27);
  case P^.FldType of
    fldChar  : T := 'Alpha';
    fldShort : T := 'Short';
    fldDate  : T := 'Date';
    fldDouble: T := 'Number';
    fldBlob  : T := 'Blob'
  end;
  S := S + Copy (T + Spaces,1,11);
  case P^.FldSubType of
    fldStNone   : T := 'None';
    fldStMoney  : T := 'Currency';
    fldStMemo   : T := 'Memo';
    fldStBinary : T := 'Binary';
    fldStFmtMemo: T := 'Fmt Memo';
    fldStOleObj : T := 'OLE';
    fldStGraphic: T := 'Graphic'
  end;
  S := S + Copy (T + Spaces,1,11);
  case P^.FldType of
    fldChar  : Len := P^.FldLen;
    fldShort : Len := 2;
    fldDate  : Len := 4;
    fldDouble: Len := 8;
    fldBlob  : Len := P^.FldLen
  end;
  Str (Len:0,T);
  S := S + Copy (T + Spaces,1,8);
  Size := Len;
  if P^.FldType = fldBlob then Inc (Size,10);
  Str (Size:0,T);
  S := S + T;
  {$I-}
  if OnPrinter then WriteLn (Lst,S) else WriteLn (S);
  {$I+}
  if IOResult > 0 then PrinterError
end;

procedure PrintIndexInfo (Dir: DirStr; Name: NameStr);

var
  Cur    : PCursor;
  Coll   : PStringCollection;
  FldColl: PExtFieldCollection;
  I      : Integer;

function GetKeyFiles (TblName: PathStr): PStringCollection;

var
  P   : PStringCollection;
  Dir : DirStr;
  Name: NameStr;
  Ext : ExtStr;
  SR  : SearchRec;

begin
  P := New (PStringCollection,Init (10,10));
  FSplit (TblName,Dir,Name,Ext);
  FindFirst (Dir + Name + '.PX',AnyFile,SR);
  if DosError = 0 then
  begin
    P^.Insert (NewStr (Dir + SR.Name));
    FindFirst (Dir + Name + '.X??',AnyFile,SR);
    while DosError = 0 do
    begin
      P^.Insert (NewStr (Dir + SR.Name));
      FindNext (SR)
    end
  end;
  if P^.Count = 0 then
  begin
    Dispose (P,Done);
    P := NIL
  end;
  GetKeyFiles := P
end;

procedure DoBuild (P: PString); far;

var
  FD  : PExtendedFieldDesc;
  Mode: Integer;

begin
  FD := New (PExtendedFieldDesc,Init);
  PXKeyQuery (P^,FD^.FldName,FD^.FldLen,Mode,FieldHandleArray (FD^.FldArray),
    FD^.FldNum);
  if FD^.FldNum = 0 then
  begin
    FD^.FldName := '';
    Byte (FD^.FldType) := PXEPrimary;
    FD^.FldLen := Database^.GetNumPFields (P^)
  end
  else begin
    if FD^.FldNum < 256 then
    begin
      Cur^.GenericRec^.GetFieldType (FD^.FldNum,FD^.FldType,FD^.FldSubType,
        FD^.FldLen);
      FD^.FldLen := 1
    end
    else Byte (FD^.FldType) := PXEComposite;
    FD^.CaseSens := Mode = 0
  end;
  FldColl^.Insert (FD)
end;

procedure DoPrint (FD: PExtendedFieldDesc); far;

var
  S,T: String;
  I  : Integer;
  N  : String[3];

begin
  Str (FD^.FldNum,T);
  T := Copy (T + Spaces,1,4);
  S := T;
  case Byte (FD^.FldType) of
    Byte (fldChar)  : T := 'A';
    Byte (fldShort) : T := 'S';
    Byte (fldDouble): if FD^.fldSubType = fldStNone then
      T := 'N'
    else T := '$';
    Byte (fldDate): T := 'D';
    Byte (fldBlob): case FD^.fldSubType of
      fldStMemo   : T := 'M';
      fldStBinary : T := 'B';
      fldStFmtMemo: T := 'F';
      fldStOleObj : T := 'O';
      fldStGraphic: T := 'G'
    end;
    PXEPrimary    : T := 'Pri';
    PXEComposite  : T := 'Comp'
  end;
  T := Copy (T + Spaces,1,5);
  S := S + T;
  Str (FD^.FldLen,T);
  T := Copy (T + Spaces,1,5);
  S := S + T;
  if FD^.CaseSens then T := 'X' else T := ' ';
  T := Copy (T + Spaces,1,5);
  S := S + T;
  T := Copy (FD^.FldName + Spaces,1,MaxNameLen + 1);
  S := S + T;
  if Byte (FD^.FldType) = PXEComposite then
  begin
    T := '';
    for I := 1 to FD^.FldLen do
    begin
      Str (FD^.FldArray[I],N);
      if T <> '' then T := T + ',';
      T := T + N
    end;
    S := S + T
  end
  else while (S[Length (S)] = ' ') and (Length (S) > 0) do Dec (S[0]);
  {$I-}
  if OnPrinter then WriteLn (Lst,S) else WriteLn (S);
  {$I+}
  if IOResult > 0 then PrinterError
end;

begin { PrintIndexInfo }
  { first of all we collect indexes' names, if any }
  Coll := GetKeyFiles (Dir + Name);
  { if there are indexes, we proceed }
  if Coll <> NIL then
  begin
    { we need the table to be open to collect all indexes' informations }
    Cur := New (PCursor,InitAndOpen (Database,Dir + Name,0,True));
    if Cur^.LastError <> PXSuccess then ShutDown (Cur^.LastError);
    FldColl := New (PExtFieldCollection,Init (Coll^.Count,0));
    { now we build the collection containing }
    { indexes' informations for this table   }
    Coll^.ForEach (@DoBuild);
    Dispose (Coll,Done);
    Dispose (Cur,Done);
    { and finally we print the result }
    Header[1] := '';
    Header[2] := CenteredStr ('Indexes of table ' + Name + '.DB',80);
    Header[3] := Copy (Line,1,79);
    Header[4] := '         Num  Case';
    Header[5] := 'ID  Type Flds Sens Name                             ' +
      'Fields';
    Header[6] := Copy (Line,1,79);
    for I := 1 to 6 do
    begin
      {$I-}
      if OnPrinter then WriteLn (Lst,Header[I]) else WriteLn (Header[I]);
      {$I+}
      if IOResult > 0 then PrinterError
    end;
    FldColl^.ForEach (@DoPrint);
    Dispose (FldColl,Done)
  end
end;

begin { PrintStructure }
  FSplit (FExpand (Path),Dir,Name,Ext);
  if Name = '' then Name := '*';
  Ext := '.DB';
  FindFirst (Dir + Name + Ext,Archive,DirInfo);
  if DosError > 0 then
  begin
    WriteLn (#7#13#10'File not found or file error');
    ReleaseEngine;
    Halt (1)
  end;
  while DosError = 0 do
  begin
    Name := Copy (DirInfo.Name,1,Pos ('.',DirInfo.Name) - 1);
    TableDescriptor := Database^.GetDescVector (Dir + Name);
    if Database^.LastError <> PXSuccess then
      ShutDown (Database^.LastError);
    Header[1] := '';
    Header[2] := CenteredStr ('Table ' + Name + '.DB',80);
    Header[3] := Copy (Line,1,79);
    Header[4] := 'Field #  Field Name                 Type       ' +
      'Sub        Len     Size';
    Header[5] := Copy (Line,1,79);
    for I := 1 to 5 do
    begin
      {$I-}
      if OnPrinter then WriteLn (Lst,Header[I]) else WriteLn (Header[I]);
      {$I+}
      if IOResult > 0 then PrinterError
    end;
    TableDescriptor^.ForEach (@PrintInfo);
    PrintIndexInfo (Dir,Name);
    Dispose (TableDescriptor,Done);
    {$I-}
    if OnPrinter then Write (Lst,#12#13) else WriteLn;
    {$I+}
    if IOResult > 0 then PrinterError;
    FindNext (DirInfo)
  end
end;

procedure Usage;

begin
  WriteLn ('Usage: DbDesc [/NOPRINTER] [d:\path\]tablename[.DB]' +
    #13#10'              [>] [>>] [output device or file]' +
    #13#10'              (wildcards are OK)'#13#10);
  WriteLn ('Use /NOPRINTER to view the structures without printing.');
  WriteLn ('Use /NOPRINTER together with "> file/device" or ">> file" to ' +
    'redirect output'#13#10'to a file or device without printing.');
  Halt (99)
end;

begin { Main }
  WriteLn ('DbDesc ' + Version + ' - Prints Paradox 4 tables structure' +
    #13#10'by Salvatore Besso, mc8505@mclink.it'#13#10);
  if ParamCount = 0 then Usage;
  for I := 1 to ParamCount do
  begin
    S := ParamStr (I);
    for J := 1 to Length (S) do S[J] := Upcase (S[J]);
    if S[1] = '/' then
    begin
      if (Path <> '') or (S <> '/NOPRINTER') then
        Usage
      else OnPrinter := False
    end
    else if Path = '' then
      Path := ParamStr (I)
    else Usage
  end;
  if Path = '' then Usage;
  FillChar (Line[1],SizeOf (Line) - 1,'-');
  Line[0] := #128;
  FillChar (Spaces[1],SizeOf (Spaces) - 1,' ');
  Spaces[0] := #128;
  OpenEngine;
  PrintStructure;
  ReleaseEngine
end.
