#include "marker.h"

void show_marker(int type, loc pos, int attr, int size)
    {
    setcolor(attr);
    setfillstyle(SOLID_FILL, attr);
    switch(type)
        {
        case BAR:
            bar(pos.X - size, pos.Y - size, pos.X + size, pos.Y + size);
            break;
        case CIRCLE:
            pieslice(pos.X, pos.Y, 0, 360, size);
            break;
	case TRIANGLE:
            int points[] = { pos.X - size, pos.Y + size,
                             pos.X + size, pos.Y + size,
                             pos.X, pos.Y - size,
                             pos.X - size, pos.Y + size };
            fillpoly(4, points);
            break;
	case STAR5:
            int points1[] = { pos.X - 2 * size / 3, pos.Y + size,
                              pos.X, pos.Y + size / 3,
			      pos.X + 2 * size / 3, pos.Y + size,
			      pos.X + size / 2, pos.Y + size / 4,
			      pos.X + size, pos.Y - size / 3,
                              pos.X + size / 3, pos.Y - size / 3,
                              pos.X, pos.Y - size,
                              pos.X - size / 3, pos.Y - size / 3,
			      pos.X - size, pos.Y - size / 3,
			      pos.X - size / 2, pos.Y + size / 4,
                              pos.X - 2 * size / 3, pos.Y + size
			      };
            fillpoly(11, points1);
            break;
	case STAR6:
            int points2[] = { pos.X, pos.Y - size,
                              pos.X + size / 2, pos.Y - size / 2,
                              pos.X + size, pos.Y - size / 2,
                              pos.X + 3 * size / 4, pos.Y,
                              pos.X + size, pos.Y + size / 2,
                              pos.X + size / 2, pos.Y + size / 2,
                              pos.X, pos.Y + size,
                              pos.X - size / 2, pos.Y + size / 2,
                              pos.X - size, pos.Y + size / 2,
                              pos.X - 3 * size / 4, pos.Y,
                              pos.X - size, pos.Y - size / 2,
                              pos.X - size / 2, pos.Y - size / 2,
                              pos.X, pos.Y - size };
            fillpoly(13, points2);
            break;
        case NONE:
	    putpixel(pos, attr);
            break;
	case CROSS:
            bar(pos.X - size / 2, pos.Y - size,
	        pos.X + size / 2, pos.Y + size);
            bar(pos.X - size, pos.Y - size / 2,
	        pos.X + size, pos.Y + size / 2);
            break;
	case X_CROSS:
            int points3[] = { pos.X, pos.Y - size / 2,
                              pos.X + size / 2, pos.Y - size,
                              pos.X + size, pos.Y - size / 2,
                              pos.X + size / 2, pos.Y,
                              pos.X + size, pos.Y + size / 2,
                              pos.X + size / 2, pos.Y + size,
                              pos.X, pos.Y + size / 2,
                              pos.X - size / 2, pos.Y + size,
                              pos.X - size, pos.Y + size / 2,
                              pos.X - size / 2, pos.Y,
                              pos.X - size, pos.Y - size / 2,
                              pos.X - size / 2, pos.Y - size,
                              pos.X, pos.Y - size / 2 };
            fillpoly(13, points3);
            break;

	case DIAMOND:
            int points4[] = { pos.X, pos.Y - size,
                              pos.X + size, pos.Y,
                              pos.X, pos.Y + size,
                              pos.X - size, pos.Y,
                              pos.X, pos.Y - size };
            fillpoly(5, points4);
            break;
	case TRIANGLE2:
            int points5[] = { pos.X - size, pos.Y + size,
                             pos.X + size, pos.Y + size,
                             pos.X, pos.Y - size,
                             pos.X - size, pos.Y + size };
            drawpoly(4, points5);
            break;
	case BAR2:
            rectangle(pos.X - size, pos.Y - size, pos.X + size, pos.Y + size);
            break;
	case CIRCLE2:
            circle(pos.X, pos.Y, size);
            break;
        default:
            break;
	}
    }

/*
void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    show_marker(BAR, loc(20, 100), YELLOW, 8);
    show_marker(CIRCLE, loc(40, 100), YELLOW, 8);
    show_marker(TRIANGLE, loc(60, 100), YELLOW, 8);
    show_marker(STAR5, loc(80, 100), YELLOW, 8);
    show_marker(NONE, loc(100, 100), YELLOW, 8);
    show_marker(STAR6, loc(120, 100), YELLOW, 8);
    show_marker(CROSS, loc(140, 100), YELLOW, 8);
    show_marker(X_CROSS, loc(160, 100), YELLOW, 8);
    show_marker(DIAMOND, loc(180, 100), YELLOW, 8);
    show_marker(TRIANGLE2, loc(200, 100), YELLOW, 8);
    show_marker(BAR2, loc(220, 100), YELLOW, 8);
    show_marker(CIRCLE2, loc(240, 100), YELLOW, 8);
    closegraph();
    }
*/