#ifndef __KNOW_HOW_GRAF_H_
#define __KNOW_HOW_GRAF_H_

#include "grafic.h"
#include "window.h"

class KH_Graf : public Window, public Grafic
    {
    protected:

    public:
        KH_Graf(rect coordinates, char* fName = "", char* h = "",
	       int s = 0, BORDERS b_type = SHOW_BORDER,
	       BORDERS hdr_b_type = SHOW_BORDER,
	       int pat = 0, int hdr_pat = 0,
	       int ax_col = 0, int lab_col = 0, int grid_style = 5,
	       int save_file_name = 0);

	virtual void show();
	virtual void exe(int act = 0);
/* touch() function is used as described below.
   i == 0: write "KH_GRAF" to global[0]

   i == -1 : get options from KNOW-HOW global variables.

   global_i[1]       :            axes used (1, 2, 4, 8 or dizuction).

   global_i[2]       :            x1, number of ticks, -1 for autocalculation.
   global_i[3]       :            x1, number of sub-ticks.
   global_i[4]       :            x1, orientation of labels.

   global_i[5]       :            y1, number of ticks, -1 for autocalculation.
   global_i[6]       :            y1, number of sub-ticks.
   global_i[7]       :            y1, orientation of labels.

   global_i[8]       :            x2, number of ticks, -1 for autocalculation.
   global_i[9]       :            x2, number of sub-ticks.
   global_i[10]      :            x2, orientation of labels.

   global_i[11]      :            y2, number of ticks, -1 for autocalculation.
   global_i[12]      :            y2, number of sub-ticks.
   global_i[13]      :            y2, orientation of labels.

   global_i[20 - n]  :            x1, ticks.
   global_i[n - m]   :            x1, sub_ticks.

   global_i[40 - n]  :            y1, ticks.
   global_i[n - m]   :            y1, sub_ticks.

   global_i[60 - n]  :            x2, ticks.
   global_i[n - m]   :            x2, sub_ticks.

   global_i[80 - n]  :            y2, ticks.
   global_i[n - m]   :            y2, sub_ticks.

   global[0]         :            "KH_GRAF"

   global[10 - n]    :            x1, ticks labels.
   global[30 - n]    :            y1, ticks labels.
   global[50 - n]    :            x2, ticks labels.
   global[70 - n]    :            x2, ticks labels.

   global[1 - 8]     :            min and max double values for all axes.

*/
        virtual void touch(int i = 0);
        int calc_work_rect();
    };


#endif __KNOW_HOW_GRAF_H_