

#ifndef __GEOM
#define __GEOM
#define __GEOM_H

#define location loc
#include <assert.h>


 struct dimension     // District

 { int a,b;

   dimension()  { a=b=0;}
   dimension(int length) {a=0;b=length-1;}
   dimension(int a, int b)  { this->a=a; this->b=b; }

   void sort() // b >= a. If not sure - use sort.
   {if (a>b) {register tmp=a;a=b;b=tmp;}}

   int l()const { return b-a+1;}

   void center(const dimension& stat)   
   {register l1=l();
    a=(stat.l()-l1)/2+stat.a; b=a+l1-1;
    }
   void center(int c)
   { register l1=l();
    a=c+ (a-b)/2; b=a+l1-1;
    }

   int center(){return (a+b)/2;}

   int operator==(const dimension& x){return x.l()==l();}
   int operator<=(const dimension& x){return l()<=x.l();}
   int operator>=(const dimension& x){return l()>=x.l();}

   int operator>(const dimension& x){return l()>x.l();}
   int operator<(const dimension& x){return l()<x.l();}


  };


 struct rect;

 struct loc
 { int X,Y;

   loc(int x,int y): X(x),Y(y){}
   loc(): X(0),Y(0){}
   loc(const loc& L): X(L.X),Y(L.Y){}


   loc& operator+=(const loc& a)
     { X+=a.X;Y+=a.Y; return * this;}
   loc& operator-=(const loc& a)
     { X-=a.X;Y-=a.Y; return * this;}

   void zero() {X=Y=0;}

   rect corner(const loc& cornr);  // See inline expansion below
 };

 inline loc operator+ (const loc& a, const loc& b)
  {
    return loc(a.X+b.X,a.Y+b.Y);
  }

 inline loc operator- (const loc& a, const loc& b)
  {
    return loc(a.X-b.X,a.Y-b.Y);
  }

 inline loc operator+ (const loc& a, int D )
  {
    return loc(a.X+D,a.Y+D);
  }

 inline loc operator- (const loc& a, int D)
  {
    return loc(a.X-D,a.Y-D);
  }



  struct row : dimension
     { int Y;

       row(const loc& O,int length) : dimension(O.X,O.X+length-1){Y=O.Y;}
       row(int x1,int x2,int y):dimension(x1,x2){Y=y;}
       row(const dimension& d,int y)  : dimension(d){Y=y;}

     //
     // + += - -=  operations with loc and int
     //
       row operator+ (const loc& vect)
	 {return row(a+vect.X,b+vect.X,Y+vect.Y);}
       row operator- (const loc& vect)
	 {return row(a-vect.X,b-vect.X,Y-vect.Y);}

       row& operator+= (const loc& vect)
	 {a+=vect.X;b+=vect.X;Y+=vect.Y;return *this;}
       row& operator-= (const loc& vect)
	 { a-=vect.X,b-=vect.X;Y-=vect.Y;return *this;}

       row operator+ (int delta)
	    { return row(*this,Y+delta);}
       row operator- (int delta)
	    { return row(*this,Y-delta);}
       row& operator+= (int delta)
	 {Y+=delta;return *this;}
       row& operator-= (int delta)
	 { Y-=delta;return *this;}

// Move to new place
       void moveto(const loc& newOrg)
	{ register l1=l();
	  a=newOrg.X;
	  b=a+l1-1;
	  Y=newOrg.Y;
	}
     };



//
//
//

 struct rect
  { loc origin,corner;

    rect(const rect& R): origin(R.origin),corner(R.corner){}
    rect(loc org, loc corn){origin=org; corner=corn;}
    rect(int x1,int y1,int x2,int y2) : origin(x1,y1), corner(x2,y2){}
    rect(const dimension& hor,const dimension& vert): origin(hor.a,vert.a),
				       corner(hor.b,vert.b){}
    rect() :origin(),corner(){}
   // rect( loc ext) : origin(),corner(ext){}
   //  This constructor is no more supported, use extent() function instead

    void sort() 
     { register tmp;
     if(origin.X>corner.X) {tmp=origin.X; origin.X=corner.X;corner.X=tmp;}
     if(origin.Y>corner.Y) {tmp=origin.Y; origin.Y=corner.Y;corner.Y=tmp;}
     }

    dimension horiz() const {return dimension(origin.X,corner.X);}
    dimension vert() const {return dimension(origin.Y,corner.Y);}
    int  width() const {return horiz().l();}
    int  height() const {return vert().l();}
    loc extent() const {return loc(horiz().l(),vert().l());}

    unsigned area() const {return width()*height();}

    int  top()    const {return origin.Y;}
    int  left()   const {return origin.X;}
    int  bottom() const {return corner.Y;}
    int  right()  const {return corner.X;}

    loc center()  const 
    {return loc((origin.X+corner.X)/2,(origin.Y+corner.Y)/2);}

    void moveto(const loc& New)
    {corner+=New-origin;origin=New;}


    rect& operator+=(const loc&  vect)
    {origin+=vect; corner+=vect; return * this;}
    rect& operator-=(const loc&  vect)
    {origin-=vect; corner-=vect; return * this;}

    int contains(loc point) const
     {return
      origin.X<=point.X && origin.Y <= point.Y && 
      corner.X>=point.X && corner.Y >= point.Y ;
      }

     int contains( const rect& A) const
     { return contains(A.origin)&& contains(A.corner); }

     void expand(const rect& delta) 
     { origin-=delta.origin; corner+=delta.corner;}

     void symmexpand(loc delta)
     { origin-=delta; corner+=delta;}


  };


 inline rect extent(loc org,loc ext)
   {return rect(org,org+ext-loc(1,1)); }

 inline rect extent(loc ext)
   {return rect(loc(),ext-loc(1,1)); }


 inline rect operator+(const rect& r,  loc v)
  {return rect(r.origin+v ,(r.corner+v));}

 inline rect operator-(const rect& r,loc v)
  {return rect(r.origin-v ,(r.corner-v));}

 inline rect loc::corner(const loc& cornr)
   { return rect(*this,cornr);}

#ifdef __STDLIB_H
#undef max
#undef abs
#endif

inline int max( int a,int b)
 {
   return a>b ? a: b;
 }

#ifndef __STDLIB_H

inline int abs(int x)
 {
  return x<0 ? -x : x;
  }
#endif

inline loc max(loc a, loc b)
  {
   return loc(max(a.X,b.X),max(a.Y,b.Y));
  }


inline loc abs(loc a)
  {
   return loc(abs(a.X),abs(a.Y));
   }


inline loc operator/(loc num,int den)
 {
  assert(den>0);
  return loc(num.X/den,num.Y/den);

 }

inline rect operator/(const rect& num,int den)
   {
     return rect(num.origin/den,num.corner/den);

   }

inline loc operator*(loc m,int m2)
 {
  return loc(m.X*m2,m.Y*m2);

 }

inline rect operator*(const rect& m1,int m2)
   {
     return rect(m1.origin*m2,m1.corner*m2);

   }


inline int operator==(loc a, loc b)
 {

  return a.X==b.X && a.Y==b.Y;
 }

inline int operator==(const rect& a,const rect& b)
  {
   return a.origin==b.origin && a.corner==b.corner;
  }


#endif


