#ifndef __EVENT
#define __EVENT

#include <mouse.h>

// if normal key - ASCII code, if extended - 257 + low code

enum keys { EVENT_NO=0,
	EVENT_ESC = 257,        EVENT_TAB,          EVENT_BKSP,
	EVENT_BELL,             EVENT_RETURN,

	EVENT_LEFT,             EVENT_RIGHT,        EVENT_HOME,
	EVENT_UP,
	EVENT_PG_UP,            EVENT_FIVE,         // center of num. kbd
	EVENT_END,              EVENT_DN,           EVENT_PG_DN,
	EVENT_CTRL_HOME,        EVENT_CTRL_PG_UP,   EVENT_CTRL_END,
	EVENT_CTRL_PG_DN,       EVENT_F1,           EVENT_F2,
	EVENT_F3,               EVENT_F4,           EVENT_F5,
	EVENT_F6,               EVENT_F7,           EVENT_F8,
	EVENT_F9,               EVENT_F10,          EVENT_SHIFT_F1,
	EVENT_SHIFT_F2,         EVENT_SHIFT_F3,     EVENT_SHIFT_F4,
	EVENT_SHIFT_F5,         EVENT_SHIFT_F6,     EVENT_SHIFT_F7,
	EVENT_SHIFT_F8,         EVENT_SHIFT_F9,     EVENT_SHIFT_F10,
	EVENT_CTRL_F1,          EVENT_CTRL_F2,      EVENT_CTRL_F3,
	EVENT_CTRL_F4,          EVENT_CTRL_F5,      EVENT_CTRL_F6,
	EVENT_CTRL_F7,          EVENT_CTRL_F8,      EVENT_CTRL_F9,
	EVENT_CTRL_F10,         EVENT_ALT_F1,       EVENT_ALT_F2,
	EVENT_ALT_F3,           EVENT_ALT_F4,       EVENT_ALT_F5,
	EVENT_ALT_F6,           EVENT_ALT_F7,       EVENT_ALT_F8,
	EVENT_ALT_F9,           EVENT_ALT_F10,      EVENT_ALT_A,
	EVENT_ALT_B,            EVENT_ALT_C,        EVENT_ALT_D,
	EVENT_ALT_E,            EVENT_ALT_F,        EVENT_ALT_G,
	EVENT_ALT_H,            EVENT_ALT_I,        EVENT_ALT_J,
	EVENT_ALT_K,            EVENT_ALT_L,        EVENT_ALT_M,
	EVENT_ALT_N,            EVENT_ALT_O,        EVENT_ALT_P,
	EVENT_ALT_Q,            EVENT_ALT_R,        EVENT_ALT_S,
	EVENT_ALT_T,            EVENT_ALT_U,        EVENT_ALT_V,
	EVENT_ALT_W,            EVENT_ALT_X,        EVENT_ALT_Y,
	EVENT_ALT_Z,

	EVENT_ALT_1,            EVENT_ALT_2,        EVENT_ALT_3,
	EVENT_ALT_4,            EVENT_ALT_5,        EVENT_ALT_6,
	EVENT_ALT_7,            EVENT_ALT_8,        EVENT_ALT_9,
	EVENT_ALT_0,            EVENT_ALT_MINUS,    EVENT_ALT_EQUAL,
	EVENT_ALT_TAB,
	EVENT_INS,              EVENT_DEL,          EVENT_SHIFT_TAB,
	EVENT_CTRL_Y,

	EVENT_CTRL_PRT_SCR,     EVENT_CTRL_BREAK
	};



 /*

   word at 0:417h

	      f  e  d   c  b  a  9  8  7  6  5  4  3  2  1  0
	     Ŀ
	      i c n s _ _aLcLI C N S a c sLsR
	     
                                    Ŀ
                                 Ŀ   
                          Ŀ  Ŀ      
                               Ŀ         
                           
  ĿĿĿĿ
                                  
  
            . .        - + - + - + - +         
		      
		    ac         if 101-key
		          Del key up & Down ( emul)
 keyshiftchange        Right key(alt or control) changed

 */


 // Defines for keyboard shift state Change
 //  naming:
 //  KC + [lt,rt] + {Shift,Ctrl,Alt,Scroll,Num,Caps,Ins,Del} + {Dn,Up}
 //    or
 //  KC +  {Scroll,Num,Caps,Ins} + {On,Off}
 //  ===========================================================
 //  examples
 //
 //   testing for right Alt or Ctrl key  events:
 //   if( (key_shift_change & KCrtCtrlDn) == KCrtCtrlDn ) ....
 //
 //    for  other events  simply use
 //
 //   if( key_shift_change &  KCShiftUp) .....
 //
 //    Usage of  101-keyboard-specific keys is not encouraged !
 //
#define KCltShiftDn               0x00000001L
#define KCltShiftUp               0x00000002L
#define KCrtShiftDn               0x00000004L
#define KCrtShiftUp               0x00000008L
#define KCShiftDn                 0x00000005L
#define KCShiftUp                 0x0000000aL
#define KCCtrlDn                  0x00000010L
#define KCCtrlUp                  0x00000020L
#define KCAltDn                   0x00000040L
#define KCAltUp                   0x00000080L
#define KCScrollOn                0x00000100L
#define KCScrollOff               0x00000200L
#define KCNumOn                   0x00000400L
#define KCNumOff                  0x00000800L
#define KCCapsOn                  0x00001000L
#define KCCapsOff                 0x00002000L
#define KCInsOn                   0x00004000L
#define KCInsOff                  0x00008000L
#define KCltCtrlDn                0x00010000L
#define KCltCtrlUp                0x00020000L
#define KCltAltDn                 0x00040000L
#define KCltAltUp                 0x00080000L
#define KCDelDn                   0x00100000L
#define KCDelUp                   0x00200000L
#define  KCrtCtrl                  0x00400000L  //  do not use
#define  KCrtAlt                   0x00800000L  //  do not use
#define KCrtCtrlDn                0x00400010L
#define KCrtCtrlUp                0x00400020L
#define KCrtAltDn                 0x00800040L
#define KCrtAltUp                 0x00800080L
#define KCScrollDn                0x01000000L
#define KCScrollUp                0x02000000L
#define KCNumDn                   0x04000000L
#define KCNumUp                   0x08000000L
#define KCCapsDn                  0x10000000L
#define KCCapsUp                  0x20000000L
#define KCInsDn                   0x40000000L
#define KCInsUp                   0x80000000L


enum  mouse_change
      { // mouse state change
	// naming :
	// MC + {left,center,right} + {Dn,Up,2}
	// MCmove

	   MCmove=0x1,
	   MCleftDn=0x02,MCleftUp=0x04,
	   MCrightDn=0x08,MCRightUp=0x10,
	   MCcenterDn=0x20,MCcenterUp=0x40,


	   MCleft2=0x100,MCright2=0x200,MCcenter2=0x400,  // double-clicks

	   MCnone=0x00,MC1=0x7e,MC2=0x700,MCall=0x77f
       };

#define MCmiddleDn MCcenterDn     // Synonyms
#define MCmiddleUp MCcenterUp
#define MCmiddle2  MCcenter2





#define KEYEVENT      1
#define SHIFTKEYEVENT 2     // f.e. press SHIFT
#define MOUSEEVENT    4
#define NOEVENT       0




typedef   unsigned long shiftkeychangetype;


struct event
	 {
	 char what;  //KEYEVENT | SHIFTKEYEVENT | MOUSEEVENT | NOEVENT
	 char Delpressed;  // placed here for efficiency; logically  it
			   // should come later

	 union
	 {
	 int key;
	 int mousechange;
	 shiftkeychangetype kbchange;
	 };
	 mousestatus msstatus;
	 unsigned kbstatus;
       //******************
	  operator char() const
		{ return what==KEYEVENT ? (key<256 ? key: 0):0;}
	  int operator ! () const {return what==NOEVENT;}
	  operator int() const {return what!=NOEVENT;}

	  int mouse1() const {if(what!=MOUSEEVENT) return 0;  // single clicks
			return mousechange & MC1;}
	  int mouse2() const {if(what!=MOUSEEVENT) return 0; // double clicks
			return mousechange & MC2;}
	  int keypress() const {if(what!=KEYEVENT) return 0; // keys enum
			return key;}
	  shiftkeychangetype shiftkey() const
			{if(what!=SHIFTKEYEVENT) return 0; // double clicks
			return kbchange;}

	  loc where() const {return msstatus.where();}

	  int is_char() { return char(*this); }
	  int is_control()
		  { return (what == KEYEVENT )
		            && !  char(*this); }
	  };






class EventDriver   //
    {
      static void far * oldkbhandler;
      static unsigned char break_code;
      static volatile char Delispressed;
    protected:
      static unsigned oldkbstatus;
      static mousestatus oldmsstatus;
      static char olddelpressed;

      static void far interrupt kbhandler();
    public:

	EventDriver();
	~EventDriver();

	friend event getevent ( int ,int);
	friend event readevent( int ); // Don't wait !
	friend int eventavail ( int, int);


    };

 //
 //  for parameter 'mask' OR following: KEYEVENT SHIFTKEYEVENT MOUSEEVENT
 //  for parameter 'mousemask' OR mouse_change (MCxxxx) constants
 //
	event getevent ( int mask =-1,int mousemask=MC1);  // wait
// default mousemask value: consider only button presses/releases
	event readevent(int mask =-1 ); // Don't wait !
	int eventavail (int mask =-1,int mousemask=MC1);

	int  keyboard101(); //Check for 101-keyboard present

#endif __EVENT
