#ifndef __ABSTRACT_TABLE_H_
#define __ABSTRACT_TABLE_H_

#include "kh_table.h"
#include "window.h"

/*    This class could show table in window. Its name includes "abstract"
    because we do not define the concrete mechanism of records navigation.
    Block of virtual functions should be overloaded inchild class to
    realize access to the concrete table.
*/

enum KH_TABLE_MODE { KH_EDIT_TABLE, KH_VIEW_TABLE };

class KH_AbstractTable : public KH_TableView, public Window
    {
    protected:
	KH_TABLE_MODE mode;    // Edit or view
    public:
	KH_AbstractTable(rect coordinates, char* fName = "", char* h = "",
	       int s = 0,
	       int col = -1,
	       int* wid = NULL, int* colNum = NULL,
	       BORDERS b_type = SHOW_BORDER,
	       BORDERS hdr_b_type = SHOW_BORDER,
	       int res = 0, int pat = 0, int hdr_pat = 0)
	: Window(coordinates, fName, h, s, b_type, hdr_b_type, res,
	       pat, hdr_pat),
	  KH_TableView(0, 0, col, wid, colNum)
	    {
	    mode = KH_VIEW_TABLE;
	    rect r = textRect(user_screen());
	    setWidth(r.width());
	    setHeight(r.height() - 1);
	    }

	virtual void getFieldName(char* name, int n) { strcpy(name, "Name"); }
	virtual void repose(rect new_pos);
	virtual long RecordNumber()    { return 25L; }
	virtual int getColumnNumber()  { return 8; }
	virtual void showField(int xcell, int x, int y, int flag,
			       int field_type) {}
	virtual int getFieldType(int x, int y) { return 0; }

	virtual void show();
	virtual void exe(int act = 0);
	virtual int writeAccess() { return 0; }
	virtual void saveTable() {}
	virtual void editField() {}
	void showCursor(rect r, int color, int startX, int startY,
				  int endX, int endY);
	void getItemPos(loc l, int* startX, int* startY, int* endX,
			int* endY);
	virtual int getFieldMaxWidth() { return 1; }
	void line_table(rect r);
	virtual int searchField(int ask) { return 1; }

    };

#endif __ABSTRACT_TABLE_H_