// HugeCalc Header File
// Include this file in any module that uses HugeCalc classes/functions

#define HC_MAXDIGITS	300
#define HC_VERSION		"1.00"

#ifndef TRUE
#define TRUE	 		-1
#define FALSE			0
typedef short BOOL;
#endif

class HugeInt
{
	// Friends
	friend HugeInt abs(HugeInt&);
	friend istream& operator>> (istream& is, HugeInt& hi);

	public:
		// Constructors
		HugeInt(int);
		HugeInt(HugeInt&);
		HugeInt();

		// Arithmetic operators with two HugeInts
		HugeInt operator+(HugeInt&);
		HugeInt operator-();
		HugeInt operator-(HugeInt&);
		HugeInt operator*(HugeInt&);

		// Relational operators with two HugeInts
		BOOL operator==(HugeInt&);
		BOOL operator< (HugeInt&);
		BOOL operator<=(HugeInt&);
		BOOL operator> (HugeInt&);
		BOOL operator>=(HugeInt&);

		// Assignment operators with two HugeInts
		// (The assignment operator = is derived from the constructors)
		HugeInt& operator-=(HugeInt& a) {return ((*this)=(*this)-a);};
		HugeInt& operator+=(HugeInt& a) {return ((*this)=(*this)+a);};
		HugeInt& operator*=(HugeInt& a) {return ((*this)=(*this)*a);};

		// Miscellaneous operators and functions
		int operator[](int i) {return (i>=ndigits? 0 : digit[i]);};
		int length() {return ndigits;};

	private:
		char  digit[HC_MAXDIGITS]; // least significant comes first
		short ndigits	: 8;
		short sign		: 1;

		// Internal functions
		HugeInt subtract(HugeInt&);
		void carry(int);
		void trim();
		inline void add_digit(int);
};

extern ostream& operator<< (ostream& os, HugeInt& hi);

// Relational operators with one HugeInt and one int
inline BOOL operator==(int a,HugeInt& b) {return ((HugeInt)a==b);}
inline BOOL operator< (int a,HugeInt& b) {return ((HugeInt)a< b);}
inline BOOL operator<=(int a,HugeInt& b) {return ((HugeInt)a<=b);}
inline BOOL operator> (int a,HugeInt& b) {return ((HugeInt)a> b);}
inline BOOL operator>=(int a,HugeInt& b) {return ((HugeInt)a>=b);}
inline BOOL operator==(HugeInt &a,int b) {return (a==(HugeInt)b);}
inline BOOL operator< (HugeInt &a,int b) {return (a< (HugeInt)b);}
inline BOOL operator<=(HugeInt &a,int b) {return (a<=(HugeInt)b);}
inline BOOL operator> (HugeInt &a,int b) {return (a> (HugeInt)b);}
inline BOOL operator>=(HugeInt &a,int b) {return (a>=(HugeInt)b);}

// Assignment operators with one HugeInt and one int
inline HugeInt& operator-=(HugeInt& a,int b) {return (a=a-(HugeInt)b);}
inline HugeInt& operator+=(HugeInt& a,int b) {return (a=a+(HugeInt)b);}
inline HugeInt& operator*=(HugeInt& a,int b) {return (a=a*(HugeInt)b);}