#include "iostream.h"
#include "csmalloc.h"
#include "demodb.h"


////////////////////////////////////////////////////////////////////////
///////////////  Display Intro screen //////////////////////////////////
////////////////////////////////////////////////////////////////////////

void help(void)
{
      cout<<endl<<endl;
      cout<<"list version 1.0 for "<<_CP_PLATFORM<<endl;
      cout<<"  Lists the database alphabetically. "<<endl;
      cout<<"Copyright (c) ComBits, 1996"<<endl;
      cout<<"Compiled: "<<__DATE__<<",  "<<__TIME__<<endl<<endl;
      cout<<"SYNTAX:  list <name|data|natural>     "<<endl;
      cout<<"  name:    List the NAME fields in alphabetical order. "<<endl;
      cout<<"  data:    List the DATA fields in alphabetical order. "<<endl;
      cout<<"  natural: List the database unsorted. "<<endl<<endl;
      cout<<"EXAMPLE: list name  "<<endl;
}

////////////////////////////////////////////////////////////////////////
///////////////  Main program //////////////////////////////////////////
////////////////////////////////////////////////////////////////////////



int main(int argc,char *argv[])
{

//alloc_logging(TRUE);	 // Uncomment if you like allocation logging.


  DEMO	 demo;	// An instance of the generated DEMO class.

  int	 order;

  if(argc!=2)
  {
    help();
    return 1;
  }


  if(!stricmp(argv[1],"name"))
  {
    order=DEMO_NAME_INDEX;
  }else
  if(!stricmp(argv[1],"data"))
  {
    order=DEMO_DATA_INDEX;
  }else
  if(!stricmp(argv[1],"natural"))
  {
    order=UNSORTED;
  }else
  {
    help();
    return 1;
  }



////// Open the now existing Database and Indexes.

  if(!demo.open(100))  // Open with 100Kb buffers.
  {
     cout<<"Error, can't open databases. "<<endl;
     return 8;
  }



  cout<<endl<<endl;

  demo.order(order);			// Select an index.

  if(demo.top())		      // Read the first key.
  {				      // Fails only if the btree is empty.

    do
    {
      cout.width(55);
      cout.fill('.');
      cout.setf(ios::left, ios::adjustfield);
      cout<<demo.name()<<demo.data()<<endl;
    }
    while(demo.next()); 	      // Next key.
  }



////// Close Database and Indexes.

  if(!demo.close())
  {
     cout<<"Error, while closeing databases. "<<endl;
     return 8;
  }

////// Display errors IF ANY! Otherwise nothing is displayed.

  demo.display_error();


////// Return error level 0 to the command line.

  return 0;

}
