/***********************************************************************

                                       CSA Library, Version 1.6.b 
                                         Released: March 2nd 1995 

       Defining FIELD classes for every type of variable.

                                           Copyright(c) 1994,1995 
                                                           Combis 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSFIELD_H
#define __CSFIELD_H

#ifndef __CSDATE_H
  #include "csdate.h"
#endif

#ifndef __CSTOOLS_H
  #include "cstools.h"
#endif

#ifndef __CSEDSTR_H
  #include "csedstr.h"
#endif

#ifndef __CSWINDOW_H
  #include "cswindow.h"
#endif

#pragma warn -sig
#pragma warn -hid

enum f_protect { EDIT,DISPLAY,BROWSE };


class FIELD: public WINDOW, public EDSTR
{


////////////////////////// Variables  //////////////////////////////////////////

protected:
  int protects;
  int exitfield;
  void *po;
  int e_insert;
  int e_l_pos;
  int e_pos;
  CSCHAR *val_exp;	// validation expression
  uchar  *s_template;	// template string



////////////////////////// Protected functions /////////////////////////////////

protected:

   int (FIELD::*edit_fun)(void);
   void check_displen(void);
   int	read(void)		 { return (this->*edit_fun)(); }
   int	browse_w(void);
   int	edit_w(void);
   int	edit_tpt(void);

   virtual int i_insert(void);
   virtual int max_ok(void) =0;
   virtual int min_ok(void) =0;
   virtual int is_valid(void)  { return TRUE; }


public:


////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////



//////////////////////// Template & Validation /////////////////////////
   void validate(CSCHAR *s)  { val_exp=s;    }
   void picture(CSCHAR *s);
   void picture_off(void);



/////////////////////// Editing ////////////////////////////////////////
    int edit(void)	   { v_exit(FALSE); return read(); }
    int edit_v(void)	   { v_exit(TRUE);  return read(); }
   void init_e_pos(void)   { e_insert=-1; e_l_pos=-1; e_pos=-1; }

   int browse(void)	   { v_exit(FALSE); return browse_w(); }
   int browse_v(void)	   { v_exit(TRUE);  return browse_w(); }



/////////////////////// Defining fields ////////////////////////////////
   void field_color(int col) { screen_color(col); }
   void protect(int t)	   { protects=t; }
   int	protect(void)	   { return protects; }
   void show(void);

   void exit_field(int tf) { exitfield=tf; }
   int	exit_field(void)   { return exitfield; }


////////////////////////Con&Des-structor ///////////////////////////////
   FIELD(void);
   virtual ~FIELD(void);


/////////////////////// Max & Min functions ////////////////////////////
   virtual void set_max(int);
   virtual void set_max(long);
   virtual void set_max(float);
   virtual void set_max(double);
   virtual void set_max(CSCHAR *);
   virtual void set_max(CSCHAR);
   virtual void set_max(DATE &);

   virtual void set_min(int);
   virtual void set_min(long);
   virtual void set_min(float);
   virtual void set_min(double);
   virtual void set_min(CSCHAR *);
   virtual void set_min(CSCHAR);
   virtual void set_min(DATE &);

   virtual void reset_max(void)=0;
   virtual void reset_min(void)=0;




/////////////////////// Operator overloading ///////////////////////////

   void operator=(CSCHAR *s);
   void operator=(CSCHAR &c);
   void operator=(int &i);
   void operator=(long &l);
   void operator=(float &f);
   void operator=(double &d);
   void operator=(DATE &d);


////////////////////////// Miscellaneous ///////////////////////////////////////

   virtual void recreate(void) =0;
   virtual int restore(void)=0;

};



//////////////////////////// int FIELD /////////////////////////////////


class iFIELD: public FIELD
{

private:

   int maxi;
   int mini;


protected:

   int max_ok(void);
   int min_ok(void);
   int restore(void)	    { return convert(*(int *)po); }
   virtual int is_valid(void);
   void recreate(void)		{ }

public:

   iFIELD(void);
   void set_max(int    i)      { maxi=i; }
   void set_min(int    i)      { mini=i; }
   void set_max(long   i)      { maxi=i; }
   void set_min(long   i)      { mini=i; }
   void set_max(float  i)      { maxi=i; }
   void set_min(float  i)      { mini=i; }
   void set_max(double i)      { maxi=i; }
   void set_min(double i)      { mini=i; }
   void reset_max(void);
   void reset_min(void);

};



//////////////////////////// long FIELD /////////////////////////////////


class lFIELD: public FIELD
{

private:

   long maxi;
   long mini;


protected:

   int max_ok(void);
   int min_ok(void);
   int restore(void)	    { return convert(*(long *)po); }
   virtual int is_valid(void);
   void recreate(void)		{ }

public:

   lFIELD(void);
   void set_max(int    i)      { maxi=i; }
   void set_min(int    i)      { mini=i; }
   void set_max(long   i)      { maxi=i; }
   void set_min(long   i)      { mini=i; }
   void set_max(float  i)      { maxi=i; }
   void set_min(float  i)      { mini=i; }
   void set_max(double i)      { maxi=i; }
   void set_min(double i)      { mini=i; }
   void reset_max(void);
   void reset_min(void);

};







//////////////////////////// double FIELD /////////////////////////////////


class dFIELD: public FIELD
{

private:

   double maxi;
   double mini;


protected:

   int max_ok(void);
   int min_ok(void);
   int restore(void)	    { return convert(*(double *)po); }
   virtual int is_valid(void);
   void recreate(void)		{ }

public:

   dFIELD(void);
   void set_max(int    i)      { maxi=i; }
   void set_min(int    i)      { mini=i; }
   void set_max(long   i)      { maxi=i; }
   void set_min(long   i)      { mini=i; }
   void set_max(float  i)      { maxi=i; }
   void set_min(float  i)      { mini=i; }
   void set_max(double i)      { maxi=i; }
   void set_min(double i)      { mini=i; }
   void reset_max(void);
   void reset_min(void);

};



//////////////////////////// float FIELD /////////////////////////////////


class fFIELD: public dFIELD
{


protected:
   int restore(void)	    { return convert(*(float *)po); }
   void recreate(void)		{ }

public:
    fFIELD(void);


};



//////////////////////////// string FIELD /////////////////////////////////


class sFIELD: public FIELD
{

private:

   CSCHAR * maxi;
   CSCHAR * mini;


protected:
   int max_ok(void);
   int min_ok(void);
   int restore(void)	    { return convert((CSCHAR *)po); }
   void recreate(void)	    { FIELD::operator=(((CSCHAR *)po)); }

public:

   sFIELD(void);
   void set_max(CSCHAR *s)    { maxi=s; }
   void set_min(CSCHAR *s)    { mini=s; }
   void reset_max(void);
   void reset_min(void);

};



//////////////////////////// CSCHAR FIELD //////////////////////////////////


class cFIELD: public FIELD
{

private:

   CSCHAR  maxi;
   CSCHAR  mini;


protected:

   int max_ok(void);
   int min_ok(void);
   int restore(void)		{ return convert(*(CSCHAR *)po); }
   virtual int i_insert(void)	{ return FALSE; }
   void recreate(void)		{ }

public:

   cFIELD(void);
   void set_max(CSCHAR i)     { maxi=i; }
   void set_min(CSCHAR i)     { mini=i; }
   void reset_max(void);
   void reset_min(void);

};

//////////////////////////// date FIELD //////////////////////////////////


class aFIELD: public FIELD
{

private:

   DATE  maxi;
   DATE  mini;


protected:

   int max_ok(void);
   int min_ok(void);
   int restore(void)		{ *((DATE *)po)=(CSCHAR *)s; return TRUE; }
   virtual int i_insert(void)	{ return FALSE; }
   virtual int is_valid(void);
   void recreate(void)		{ FIELD::operator=(*(DATE *)po); }

public:

   aFIELD(void);
   void set_max(DATE &);
   void set_min(DATE &);
	void set_max(CSCHAR *s);
	void set_min(CSCHAR *s);
	void reset_max(void);
	void reset_min(void);

};


#pragma warn .sig
#pragma warn .hid


#endif






